/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMdHandlerTestBase;
import org.apache.flink.table.planner.plan.nodes.calcite.Expand;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.calcite.Rank;
import org.apache.flink.table.planner.plan.nodes.common.CommonCalc;
import org.apache.flink.table.planner.plan.nodes.common.CommonPhysicalWindowTableFunction;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalGroupAggregateBase;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001#\t1b\t\\5oWJ+G.\u00143S_^\u001cu.\u001e8u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002\u0006\r\u0005!\u0001\u000f\\1o\u0015\t9\u0001\"A\u0004qY\u0006tg.\u001a:\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011\u0011D\u00127j].\u0014V\r\\'e\u0011\u0006tG\r\\3s)\u0016\u001cHOQ1tK\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u0003'\u0001AQa\u0007\u0001\u0005\u0002q\t!\u0004^3ti\u001e+GOU8x\u0007>,h\u000e^(o)\u0006\u0014G.Z*dC:$\u0012!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0005+:LG\u000f\u000b\u0002\u001bIA\u0011Q\u0005K\u0007\u0002M)\u0011qED\u0001\u0006UVt\u0017\u000e^\u0005\u0003S\u0019\u0012A\u0001V3ti\")1\u0006\u0001C\u00019\u00059B/Z:u\u000f\u0016$(k\\<D_VtGo\u00148WC2,Xm\u001d\u0015\u0003U\u0011BQA\f\u0001\u0005\u0002q\t\u0001\u0004^3ti\u001e+GOU8x\u0007>,h\u000e^(o!J|'.Z2uQ\tiC\u0005C\u00032\u0001\u0011\u0005A$A\fuKN$x)\u001a;S_^\u001cu.\u001e8u\u001f:4\u0015\u000e\u001c;fe\"\u0012\u0001\u0007\n\u0005\u0006i\u0001!\t\u0001H\u0001\u0016i\u0016\u001cHoR3u%><8i\\;oi>s7)\u00197dQ\t\u0019D\u0005C\u00038\u0001\u0011\u0005A$A\fuKN$x)\u001a;S_^\u001cu.\u001e8u\u001f:,\u0005\u0010]1oI\"\u0012a\u0007\n\u0005\u0006u\u0001!\t\u0001H\u0001\u001ai\u0016\u001cHoR3u%><8i\\;oi>sW\t_2iC:<W\r\u000b\u0002:I!)Q\b\u0001C\u00019\u0005)B/Z:u\u000f\u0016$(k\\<D_VtGo\u00148SC:\\\u0007F\u0001\u001f%\u0011\u0015\u0001\u0005\u0001\"\u0001\u001d\u0003U!Xm\u001d;HKR\u0014vn^\"pk:$xJ\\*peRD#a\u0010\u0013\t\u000b\r\u0003A\u0011\u0001\u000f\u00025Q,7\u000f^$fiJ{woQ8v]R|e.Q4he\u0016<\u0017\r^3)\u0005\t#\u0003\"\u0002$\u0001\t\u0003a\u0012A\u0007;fgR<U\r\u001e*po\u000e{WO\u001c;P]^Kg\u000eZ8x\u0003\u001e<\u0007FA#%\u0011\u0015I\u0005\u0001\"\u0001\u001d\u0003a!Xm\u001d;HKR\u0014vn^\"pk:$xJ\\(wKJ\fum\u001a\u0015\u0003\u0011\u0012BQ\u0001\u0014\u0001\u0005\u0002q\tQ\u0003^3ti\u001e+GOU8x\u0007>,h\u000e^(o\u0015>Lg\u000e\u000b\u0002LI!)q\n\u0001C\u00019\u0005QB/Z:u\u000f\u0016$(k\\<D_VtGo\u00148Pm\u0016\u0014XK\\5p]\"\u0012a\n\n\u0005\u0006%\u0002!\t\u0001H\u0001\u001fi\u0016\u001cHoR3u%><8i\\;oi>swJ^3s\u0013:$XM]:fGRD#!\u0015\u0013\t\u000bU\u0003A\u0011\u0001\u000f\u00025Q,7\u000f^$fiJ{woQ8v]R|en\u0014<fe6Kg.^:)\u0005Q#\u0003\"\u0002-\u0001\t\u0003a\u0012\u0001\b;fgR<U\r\u001e*po\u000e{WO\u001c;P]>3XM\u001d#fM\u0006,H\u000e\u001e\u0015\u0003/\u0012BQa\u0017\u0001\u0005\u0002q\tA\u0005^3ti\u001e+GOU8x\u0007>,h\u000e^(o/&tGm\\<UC\ndWMR;oGRLwN\u001c\u0015\u00035\u0012\u0002")
public class FlinkRelMdRowCountTest
extends FlinkRelMdHandlerTestBase {
    @Test
    public void testGetRowCountOnTableScan() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.studentLogicalScan(), this.studentBatchScan(), this.studentStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnTableScan$1(this, scan);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.empLogicalScan(), this.empBatchScan(), this.empStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnTableScan$2(this, scan);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnValues() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)4.0), (Object)this.mq().getRowCount((RelNode)this.logicalValues()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getRowCount((RelNode)this.emptyValues()));
    }

    @Test
    public void testGetRowCountOnProject() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.mq().getRowCount((RelNode)this.logicalProject()));
    }

    @Test
    public void testGetRowCountOnFilter() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)25.0), (Object)this.mq().getRowCount(this.logicalFilter()));
    }

    @Test
    public void testGetRowCountOnCalc() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)25.0), (Object)this.mq().getRowCount((RelNode)this.logicalCalc()));
    }

    @Test
    public void testGetRowCountOnExpand() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Expand[]{this.logicalExpand(), this.flinkLogicalExpand(), this.batchExpand(), this.streamExpand()})).foreach((Function1 & Serializable & scala.Serializable)expand -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnExpand$1(this, expand);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnExchange() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.batchExchange(), this.streamExchange()})).foreach((Function1 & Serializable & scala.Serializable)exchange -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnExchange$1(this, exchange);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnRank() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalRank(), this.flinkLogicalRank(), this.batchLocalRank(), this.streamRank()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnRank$1(this, rank);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getRowCount(this.batchGlobalRank()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Rank[]{this.logicalRank2(), this.flinkLogicalRank2(), this.batchLocalRank2(), this.streamRank2()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnRank$2(this, rank);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)21.0), (Object)this.mq().getRowCount((RelNode)this.batchGlobalRank2()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Rank[]{this.logicalRowNumber(), this.flinkLogicalRowNumber(), this.streamRowNumber()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnRank$3(this, rank);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Rank[]{this.logicalRankWithVariableRange(), this.flinkLogicalRankWithVariableRange(), this.streamRankWithVariableRange()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnRank$4(this, rank);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnSort() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSort(), this.flinkLogicalSort(), this.batchSort(), this.streamSort()})).foreach((Function1 & Serializable & scala.Serializable)sort -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnSort$1(this, sort);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSortLimit(), this.flinkLogicalSortLimit(), this.batchSortLimit(), this.streamSortLimit(), this.batchGlobalSortLimit(), this.logicalLimit(), this.flinkLogicalLimit(), this.batchLimit(), this.batchGlobalLimit(), this.streamLimit()})).foreach((Function1 & Serializable & scala.Serializable)sort -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnSort$2(this, sort);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.batchLocalSortLimit(), this.batchLocalLimit()})).foreach((Function1 & Serializable & scala.Serializable)sort -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnSort$3(this, sort);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnAggregate() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalAgg(), this.flinkLogicalAgg(), this.batchGlobalAggWithLocal(), this.batchGlobalAggWithoutLocal(), this.batchLocalAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnAggregate$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StreamPhysicalGroupAggregateBase[]{this.streamGlobalAggWithLocal(), this.streamGlobalAggWithoutLocal()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnAggregate$2(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalAggWithAuxGroup(), this.flinkLogicalAggWithAuxGroup(), this.batchGlobalAggWithoutLocalWithAuxGroup(), this.batchGlobalAggWithLocalWithAuxGroup(), this.batchLocalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnAggregate$3(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnWindowAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAgg(), this.flinkLogicalWindowAgg(), this.batchLocalWindowAgg(), this.batchGlobalWindowAggWithoutLocalAgg(), this.batchGlobalWindowAggWithLocalAgg(), this.streamWindowAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnWindowAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAggWithAuxGroup(), this.flinkLogicalWindowAggWithAuxGroup(), this.batchLocalWindowAggWithAuxGroup(), this.batchGlobalWindowAggWithoutLocalAggWithAuxGroup(), this.batchGlobalWindowAggWithLocalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnWindowAgg$2(this, agg);
            return BoxedUnit.UNIT;
        });
        this.relBuilder().clear();
        RelNode ts = this.relBuilder().scan(new String[]{"TemporalTable3"}).peek();
        ArrayList aggCallOfWindowAgg = Lists.newArrayList((Object[])new AggregateCall[]{AggregateCall.create((SqlAggFunction)new SqlCountAggFunction("COUNT"), (boolean)false, (boolean)false, (boolean)false, (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)), (int)-1, null, (RelCollation)RelCollations.EMPTY, (int)2, (RelNode)ts, null, (String)"s")});
        LogicalWindowAggregate windowAgg = new LogicalWindowAggregate(ts.getCluster(), ts.getTraitSet(), ts, ImmutableBitSet.of((int[])new int[]{0, 1}), (java.util.List)aggCallOfWindowAgg, this.tumblingGroupWindow(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(this.namedPropertiesOfWindowAgg()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)4.0E9), (Object)this.mq().getRowCount((RelNode)windowAgg));
    }

    @Test
    public void testGetRowCountOnOverAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonCalc[]{this.flinkLogicalOverAgg(), this.batchOverAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnOverAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetRowCountOnJoin() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.mq().getRowCount(this.logicalInnerJoinOnUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalInnerJoinNotOnUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getRowCount(this.logicalInnerJoinOnRHSUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0E7), (Object)this.mq().getRowCount(this.logicalInnerJoinWithEquiAndNonEquiCond()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E15), (Object)this.mq().getRowCount(this.logicalInnerJoinWithoutEquiCond()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getRowCount(this.logicalInnerJoinOnDisjointKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalLeftJoinOnUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalLeftJoinNotOnUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalLeftJoinOnLHSUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getRowCount(this.logicalLeftJoinOnRHSUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalLeftJoinWithEquiAndNonEquiCond()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E15), (Object)this.mq().getRowCount(this.logicalLeftJoinWithoutEquiCond()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalLeftJoinOnDisjointKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.mq().getRowCount(this.logicalRightJoinOnUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalRightJoinNotOnUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getRowCount(this.logicalRightJoinOnLHSUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalRightJoinOnRHSUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getRowCount(this.logicalRightJoinWithEquiAndNonEquiCond()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E15), (Object)this.mq().getRowCount(this.logicalRightJoinWithoutEquiCond()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getRowCount(this.logicalRightJoinOnDisjointKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalFullJoinOnUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalFullJoinNotOnUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalFullJoinOnLHSUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalFullJoinOnRHSUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.1E8), (Object)this.mq().getRowCount(this.logicalFullJoinWithEquiAndNonEquiCond()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E15), (Object)this.mq().getRowCount(this.logicalFullJoinWithoutEquiCond()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.2E8), (Object)this.mq().getRowCount(this.logicalFullJoinOnDisjointKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.mq().getRowCount(this.logicalSemiJoinOnUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalSemiJoinNotOnUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2556.0), (Object)this.mq().getRowCount(this.logicalSemiJoinOnLHSUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getRowCount(this.logicalSemiJoinOnRHSUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1278.0), (Object)this.mq().getRowCount(this.logicalSemiJoinWithEquiAndNonEquiCond()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)4.0E8), (Object)this.mq().getRowCount(this.logicalSemiJoinWithoutEquiCond()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getRowCount(this.logicalSemiJoinOnDisjointKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.9999995E8), (Object)this.mq().getRowCount(this.logicalAntiJoinOnUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E7), (Object)this.mq().getRowCount(this.logicalAntiJoinNotOnUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.99997444E8), (Object)this.mq().getRowCount(this.logicalAntiJoinOnLHSUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2000000.0), (Object)this.mq().getRowCount(this.logicalAntiJoinOnRHSUniqueKeys()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)6.0E8), (Object)this.mq().getRowCount(this.logicalAntiJoinWithEquiAndNonEquiCond()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)6.0E8), (Object)this.mq().getRowCount(this.logicalAntiJoinWithoutEquiCond()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E7), (Object)this.mq().getRowCount(this.logicalAntiJoinOnDisjointKeys()));
    }

    @Test
    public void testGetRowCountOnOverUnion() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.2E8), (Object)this.mq().getRowCount(this.logicalUnion()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.2E8), (Object)this.mq().getRowCount(this.logicalUnionAll()));
    }

    @Test
    public void testGetRowCountOnOverIntersect() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getRowCount(this.logicalIntersect()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getRowCount(this.logicalIntersectAll()));
    }

    @Test
    public void testGetRowCountOnOverMinus() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getRowCount(this.logicalMinus()));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getRowCount(this.logicalMinusAll()));
    }

    @Test
    public void testGetRowCountOnOverDefault() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.mq().getRowCount((RelNode)this.testRel()));
    }

    @Test
    public void testGetRowCountOnWindowTableFunction() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonPhysicalWindowTableFunction[]{this.batchTumbleWindowTVFRel(), this.streamTumbleWindowTVFRel()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnWindowTableFunction$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonPhysicalWindowTableFunction[]{this.batchHopWindowTVFRel(), this.batchCumulateWindowTVFRel(), this.streamHopWindowTVFRel(), this.streamCumulateWindowTVFRel()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdRowCountTest.$anonfun$testGetRowCountOnWindowTableFunction$2(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnTableScan$1(FlinkRelMdRowCountTest $this, TableScan scan) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getRowCount((RelNode)scan));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnTableScan$2(FlinkRelMdRowCountTest $this, TableScan scan) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0E8), (Object)$this.mq().getRowCount((RelNode)scan));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnExpand$1(FlinkRelMdRowCountTest $this, Expand expand) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)150.0), (Object)$this.mq().getRowCount((RelNode)expand));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnExchange$1(FlinkRelMdRowCountTest $this, RelNode exchange) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getRowCount(exchange));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnRank$1(FlinkRelMdRowCountTest $this, RelNode rank) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)$this.mq().getRowCount(rank));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnRank$2(FlinkRelMdRowCountTest $this, Rank rank) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)(7.0 * Predef$.MODULE$.Double2double(FlinkRelMdUtil$.MODULE$.getRankRangeNdv(rank.rankRange())))), (Object)$this.mq().getRowCount((RelNode)rank));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnRank$3(FlinkRelMdRowCountTest $this, Rank rank) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)4.0), (Object)$this.mq().getRowCount((RelNode)rank));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnRank$4(FlinkRelMdRowCountTest $this, Rank rank) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)$this.mq().getRowCount((RelNode)rank));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnSort$1(FlinkRelMdRowCountTest $this, RelNode sort) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getRowCount(sort));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnSort$2(FlinkRelMdRowCountTest $this, RelNode sort) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getRowCount(sort));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnSort$3(FlinkRelMdRowCountTest $this, RelNode sort) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)30.0), (Object)$this.mq().getRowCount(sort));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnAggregate$1(FlinkRelMdRowCountTest $this, SingleRel agg) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.0), (Object)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnAggregate$2(FlinkRelMdRowCountTest $this, StreamPhysicalGroupAggregateBase agg) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnAggregate$3(FlinkRelMdRowCountTest $this, SingleRel agg) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnWindowAgg$1(FlinkRelMdRowCountTest $this, SingleRel agg) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnWindowAgg$2(FlinkRelMdRowCountTest $this, SingleRel agg) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnOverAgg$1(FlinkRelMdRowCountTest $this, CommonCalc agg) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnWindowTableFunction$1(FlinkRelMdRowCountTest $this, CommonPhysicalWindowTableFunction agg) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getRowCount((RelNode)agg));
    }

    public static final /* synthetic */ void $anonfun$testGetRowCountOnWindowTableFunction$2(FlinkRelMdRowCountTest $this, CommonPhysicalWindowTableFunction agg) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)300.0), (Object)$this.mq().getRowCount((RelNode)agg));
    }
}

