/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.processor;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecMultipleInput;
import org.apache.flink.table.planner.plan.nodes.exec.processor.MultipleInputNodeCreationProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ProcessorContext;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ResetTransformationProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.visitor.AbstractExecNodeExactlyOnceVisitor;
import org.apache.flink.table.planner.plan.nodes.exec.visitor.ExecNodeVisitor;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResetTransformationProcessorTest
extends TableTestBase {
    private BatchTableTestUtil util;
    private TableEnvironment tEnv;

    @Before
    public void begin() {
        this.util = this.batchTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.tableEnv();
        this.tEnv.executeSql("CREATE TABLE Source1 (\n  a BIGINT,\n  b BIGINT,\n  c VARCHAR,\n  d BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
        this.tEnv.executeSql("CREATE TABLE Source2 (\n  a BIGINT,\n  b BIGINT,\n  c VARCHAR,\n  d BIGINT\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)");
    }

    @Test
    public void testResetTransformation() {
        String query = "SELECT * FROM Source1 WHERE a > 100";
        ExecNodeGraph execNodeGraph = TableTestUtil.toExecNodeGraph(this.tEnv, query);
        execNodeGraph.getRootNodes().forEach(node -> node.translateToPlan((Planner)this.util.getPlanner()));
        this.assertAllTransformationsIsNotNull(execNodeGraph);
        ResetTransformationProcessor resetTransformationProcessor = new ResetTransformationProcessor();
        resetTransformationProcessor.process(execNodeGraph, new ProcessorContext(this.util.getPlanner()));
        this.assertAllTransformationsIsNull(execNodeGraph);
    }

    @Test
    public void testResetTransformationWithExecMultipleInputInExecGraph() {
        String query = "SELECT Source1.a FROM Source1, Source2 WHERE Source1.a = Source2.a AND Source2.a = (SELECT Source2.a FROM Source2 WHERE b > 100)";
        ExecNodeGraph execNodeGraph = TableTestUtil.toExecNodeGraph(this.tEnv, query);
        MultipleInputNodeCreationProcessor multipleInputNodeCreationProcessor = new MultipleInputNodeCreationProcessor(false);
        multipleInputNodeCreationProcessor.process(execNodeGraph, new ProcessorContext(this.util.getPlanner()));
        execNodeGraph.getRootNodes().forEach(node -> node.translateToPlan((Planner)this.util.getPlanner()));
        this.assertAllTransformationsIsNotNull(execNodeGraph);
        ResetTransformationProcessor resetTransformationProcessor = new ResetTransformationProcessor();
        resetTransformationProcessor.process(execNodeGraph, new ProcessorContext(this.util.getPlanner()));
        this.assertAllTransformationsIsNull(execNodeGraph);
    }

    private void assertAllTransformationsIsNotNull(ExecNodeGraph execNodeGraph) {
        AbstractExecNodeExactlyOnceVisitor visitor = new AbstractExecNodeExactlyOnceVisitor(){

            protected void visitNode(ExecNode<?> node) {
                Assert.assertNotNull((Object)((ExecNodeBase)node).getTransformation());
                this.visitInputs(node);
                if (node instanceof BatchExecMultipleInput) {
                    ExecNode rootNode = ((BatchExecMultipleInput)node).getRootNode();
                    Assert.assertNotNull((Object)((ExecNodeBase)node).getTransformation());
                    this.visitInputs(rootNode);
                }
            }
        };
        execNodeGraph.getRootNodes().forEach(r -> r.accept((ExecNodeVisitor)visitor));
    }

    private void assertAllTransformationsIsNull(ExecNodeGraph execNodeGraph) {
        AbstractExecNodeExactlyOnceVisitor visitor = new AbstractExecNodeExactlyOnceVisitor(){

            protected void visitNode(ExecNode<?> node) {
                Assert.assertNull((Object)((ExecNodeBase)node).getTransformation());
                this.visitInputs(node);
                if (node instanceof BatchExecMultipleInput) {
                    ExecNode rootNode = ((BatchExecMultipleInput)node).getRootNode();
                    Assert.assertNull((Object)((ExecNodeBase)node).getTransformation());
                    this.visitInputs(rootNode);
                }
            }
        };
        execNodeGraph.getRootNodes().forEach(r -> r.accept((ExecNodeVisitor)visitor));
    }
}

