/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ExternalCatalogTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.expressions.RexNodeExpression;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
class ResolvedCatalogTableSerdeTest {
    private static final Map<String, String> OPTIONS = new HashMap<String, String>();
    private static final FlinkTypeFactory FACTORY;
    private static final RexBuilder REX_BUILDER;
    private static final RexNode REX_NODE;
    private static final RexNodeExpression REX_NODE_EXPRESSION;
    private static final ResolvedSchema FULL_RESOLVED_SCHEMA;
    private static final ResolvedCatalogTable FULL_RESOLVED_CATALOG_TABLE;

    ResolvedCatalogTableSerdeTest() {
    }

    static Stream<ResolvedCatalogTable> testResolvedCatalogTableSerde() {
        ResolvedSchema withoutPartitionKey = new ResolvedSchema(Arrays.asList(Column.physical((String)"a", (DataType)DataTypes.STRING()), Column.physical((String)"b", (DataType)DataTypes.INT()), Column.physical((String)"c", (DataType)DataTypes.BOOLEAN()), Column.metadata((String)"d", (DataType)DataTypes.DOUBLE(), (String)"d", (boolean)true), Column.metadata((String)"e", (DataType)DataTypes.DOUBLE(), null, (boolean)false), Column.computed((String)"f", (ResolvedExpression)REX_NODE_EXPRESSION)), Collections.emptyList(), null);
        return Stream.of(FULL_RESOLVED_CATALOG_TABLE, new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(withoutPartitionKey).build(), null, Collections.singletonList("c"), OPTIONS), withoutPartitionKey));
    }

    @ParameterizedTest
    @MethodSource(value={"testResolvedCatalogTableSerde"})
    void testResolvedCatalogTableSerde(ResolvedCatalogTable spec) throws IOException {
        JsonSerdeTestUtil.testJsonRoundTrip(spec, ResolvedCatalogTable.class);
    }

    @Test
    void testDontSerializeOptions() throws IOException {
        SerdeContext serdeCtx = JsonSerdeTestUtil.configuredSerdeContext();
        byte[] actualSerialized = JsonSerdeUtil.createObjectWriter((SerdeContext)serdeCtx).withAttribute((Object)"serialize_options", (Object)false).writeValueAsBytes((Object)FULL_RESOLVED_CATALOG_TABLE);
        ObjectReader objectReader = JsonSerdeUtil.createObjectReader((SerdeContext)serdeCtx);
        JsonNode actualJson = objectReader.readTree(actualSerialized);
        JsonSerdeTestUtil.assertThatJsonContains(actualJson, "schema");
        JsonSerdeTestUtil.assertThatJsonContains(actualJson, "partitionKeys");
        JsonSerdeTestUtil.assertThatJsonDoesNotContain(actualJson, "options");
        JsonSerdeTestUtil.assertThatJsonDoesNotContain(actualJson, "comment");
        ResolvedCatalogTable actual = (ResolvedCatalogTable)objectReader.readValue(actualSerialized, ResolvedCatalogTable.class);
        Assertions.assertThat((Object)actual).isEqualTo((Object)new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(FULL_RESOLVED_SCHEMA).build(), null, Collections.singletonList("c"), Collections.emptyMap()), FULL_RESOLVED_SCHEMA));
    }

    @Test
    void testDontSerializeExternalInlineTable() {
        SerdeContext serdeCtx = JsonSerdeTestUtil.configuredSerdeContext();
        ObjectWriter objectWriter = JsonSerdeUtil.createObjectWriter((SerdeContext)serdeCtx);
        Assertions.assertThatThrownBy(() -> objectWriter.writeValueAsString((Object)new ResolvedCatalogTable((CatalogTable)new ExternalCatalogTable(Schema.newBuilder().fromResolvedSchema(FULL_RESOLVED_SCHEMA).build()), FULL_RESOLVED_SCHEMA))).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(TableException.class, (String)"Cannot serialize the table as it's an external inline table")});
    }

    static {
        OPTIONS.put("a", "1");
        OPTIONS.put("b", "2");
        OPTIONS.put("c", "3");
        FACTORY = new FlinkTypeFactory(ResolvedCatalogTableSerdeTest.class.getClassLoader(), (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);
        REX_BUILDER = new RexBuilder((RelDataTypeFactory)FACTORY);
        REX_NODE = REX_BUILDER.makeInputRef(FACTORY.createSqlType(SqlTypeName.TIMESTAMP), 1);
        REX_NODE_EXPRESSION = new RexNodeExpression(REX_NODE, (DataType)DataTypes.TIMESTAMP().notNull(), "$1", "$1");
        FULL_RESOLVED_SCHEMA = new ResolvedSchema(Arrays.asList(Column.physical((String)"a", (DataType)DataTypes.STRING()), Column.physical((String)"b", (DataType)DataTypes.INT()), Column.physical((String)"c", (DataType)DataTypes.BOOLEAN()), Column.metadata((String)"d", (DataType)DataTypes.DOUBLE(), (String)"d", (boolean)true), Column.metadata((String)"e", (DataType)DataTypes.DOUBLE(), null, (boolean)false), Column.computed((String)"f", (ResolvedExpression)REX_NODE_EXPRESSION)), Collections.singletonList(WatermarkSpec.of((String)"b", (ResolvedExpression)REX_NODE_EXPRESSION)), UniqueConstraint.primaryKey((String)"myPrimaryKey", Arrays.asList("a", "c")));
        FULL_RESOLVED_CATALOG_TABLE = new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(FULL_RESOLVED_SCHEMA).build(), (String)"my table", Collections.singletonList("c"), OPTIONS), FULL_RESOLVED_SCHEMA);
    }
}

