/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableFunc1;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class CorrelateJsonPlanTest
extends TableTestBase {
    private StreamTableTestUtil util;
    private TableEnvironment tEnv;

    @Before
    public void setup() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.getTableEnv();
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int not null,\n  c varchar,\n  d timestamp(3)\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tEnv.executeSql(srcTableDdl);
    }

    @Test
    public void testCrossJoin() {
        String sinkTableDdl = "CREATE TABLE MySink (\n  a varchar,\n  b varchar\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.addTemporarySystemFunction("func1", TableFunc1.class);
        String sqlQuery = "insert into MySink SELECT c, s FROM MyTable, LATERAL TABLE(func1(c)) AS T(s)";
        this.util.verifyJsonPlan(sqlQuery);
    }

    @Test
    @Ignore(value="the case is ignored because of FLINK-21870")
    public void testRegisterByClass() {
        String sinkTableDdl = "CREATE TABLE MySink (\n  a varchar,\n  b varchar\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.tEnv.createTemporaryFunction("func1", TableFunc1.class);
        String sqlQuery = "insert into MySink SELECT c, s FROM MyTable, LATERAL TABLE(func1(c)) AS T(s)";
        this.util.verifyJsonPlan(sqlQuery);
    }

    @Test
    public void testCrossJoinOverrideParameters() {
        String sinkTableDdl = "CREATE TABLE MySink (\n  a varchar,\n  b varchar\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.addTemporarySystemFunction("func1", TableFunc1.class);
        String sqlQuery = "insert into MySink SELECT c, s FROM MyTable, LATERAL TABLE(func1(c, '$')) AS T(s)";
        this.util.verifyJsonPlan(sqlQuery);
    }

    @Test
    public void testLeftOuterJoinWithLiteralTrue() {
        String sinkTableDdl = "CREATE TABLE MySink (\n  a varchar,\n  b varchar\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.addTemporarySystemFunction("func1", TableFunc1.class);
        String sqlQuery = "insert into MySink SELECT c, s FROM MyTable LEFT JOIN LATERAL TABLE(func1(c)) AS T(s) ON TRUE";
        this.util.verifyJsonPlan(sqlQuery);
    }

    @Test
    public void testJoinWithFilter() {
        String sinkTableDdl = "CREATE TABLE MySink (\n  a varchar,\n  b varchar\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.addTemporarySystemFunction("func1", TableFunc1.class);
        String sqlQuery = "insert into MySink select * from (SELECT c, s FROM MyTable, LATERAL TABLE(func1(c)) AS T(s)) as T2 where c = s";
        this.util.verifyJsonPlan(sqlQuery);
    }
}

