/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;

public class UnionJsonPlanTest
extends TableTestBase {
    private StreamTableTestUtil util;
    private TableEnvironment tEnv;

    @Before
    public void setup() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.getTableEnv();
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int not null,\n  c varchar,\n  d timestamp(3)\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tEnv.executeSql(srcTableDdl);
        String srcTableDdl2 = "CREATE TABLE MyTable2 (\n  d bigint,\n  e int not null\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tEnv.executeSql(srcTableDdl2);
    }

    @Test
    public void testUnion() {
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into MySink select * from (select a, b from MyTable) union all (select d, e from MyTable2)");
    }
}

