/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableRule$;
import org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableRuleTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001'\tyCj\\4jG\u0006d7i\u001c:sK2\fG/\u001a+p\u0015>LgN\u0012:p[R+W\u000e]8sC2$\u0016M\u00197f%VdW\rV3ti*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011C\u0011\u0002\tU$\u0018\u000e\\\u000b\u0002EA\u0011QcI\u0005\u0003IY\u00111c\u0015;sK\u0006lG+\u00192mKR+7\u000f^+uS2DaA\n\u0001!\u0002\u0013\u0011\u0013!B;uS2\u0004\u0003\"\u0002\u0015\u0001\t\u0003I\u0013!B:fiV\u0004H#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003OE\u0002\"AM\u001b\u000e\u0003MR!\u0001\u000e\t\u0002\u000b),h.\u001b;\n\u0005Y\u001a$A\u0002\"fM>\u0014X\rC\u00039\u0001\u0011\u0005\u0011&\u0001\ruKN$Hj\\8lkBTu.\u001b8XSRDg)\u001b7uKJD#a\u000e\u001e\u0011\u0005IZ\u0014B\u0001\u001f4\u0005\u0011!Vm\u001d;\t\u000by\u0002A\u0011A\u0015\u00021Q,7\u000f\u001e'fMRdun\\6va*{\u0017N\\(o)J,X\r\u000b\u0002>u!)\u0011\t\u0001C\u0001S\u0005\u0011C/Z:u!J|7\rV5nKR+W\u000e]8sC2Tu.\u001b8XSRDg)\u001b7uKJD#\u0001\u0011\u001e\t\u000b\u0011\u0003A\u0011A\u0015\u0002CQ,7\u000f\u001e*poRKW.\u001a+f[B|'/\u00197K_&tw+\u001b;i\r&dG/\u001a:)\u0005\rS\u0004\"B$\u0001\t\u0003I\u0013!\n;fgR\u0014vn\u001e+j[\u0016dUM\u001a;UK6\u0004xN]1m\u0015>LgnV5uQ\u001aKG\u000e^3sQ\t1%\bC\u0003K\u0001\u0011\u0005\u0011&\u0001\u000buKN$Hj\\8lkBTu.\u001b8P]R\u0013X/\u001a\u0015\u0003\u0013jBQ!\u0014\u0001\u0005\u0002%\na\u0004^3tiB\u0013xn\u0019+j[\u0016$V-\u001c9pe\u0006d'j\\5o\u001f:$&/^3)\u00051S\u0004\"\u0002)\u0001\t\u0003I\u0013!\b;fgR\u0014vn\u001e+j[\u0016$V-\u001c9pe\u0006d'j\\5o\u001f:$&/^3)\u0005=S\u0004\"B*\u0001\t\u0003I\u0013!\u0006;fgR\u0014\u0016n\u001a5u)\u0016l\u0007o\u001c:bY*{\u0017N\u001c\u0015\u0003%jBQA\u0016\u0001\u0005\u0002%\nA\u0003^3ti\u001a+H\u000e\u001c+f[B|'/\u00197K_&t\u0007FA+;\u0011\u0015I\u0006\u0001\"\u0001[\u0003A\u0019X\r^+q\u0007V\u0014(/\u001a8u%VdW\r\u0006\u0002+7\")A\f\u0017a\u0001;\u0006!!/\u001e7f!\tq&-D\u0001`\u0015\t9\u0001M\u0003\u0002b\u001d\u000591-\u00197dSR,\u0017BA2`\u0005)\u0011V\r\\(qiJ+H.\u001a")
public class LogicalCorrelateToJoinFromTemporalTableRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    public StreamTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE T1 (\n                    | id STRING,\n                    | mount INT,\n                    | proctime as PROCTIME(),\n                    | rowtime TIMESTAMP(3),\n                    | WATERMARK FOR rowtime AS rowtime\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE T2 (\n                    | id STRING,\n                    | rate INT,\n                    | PRIMARY KEY(id) NOT ENFORCED\n                    |) WITH (\n                    | 'connector' = 'COLLECTION',\n                    | 'is-bounded' = 'false'\n                    |)\n      ")).stripMargin());
        this.util().addTableSource("T3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rate")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple2<String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableRuleTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testLookupJoinWithFilter() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.LOOKUP_JOIN_WITH_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T2 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    @Test
    public void testLeftLookupJoinOnTrue() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.LOOKUP_JOIN_WITHOUT_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 LEFT JOIN T2 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON TRUE");
    }

    @Test
    public void testProcTimeTemporalJoinWithFilter() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T3 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    @Test
    public void testRowTimeTemporalJoinWithFilter() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T3 FOR SYSTEM_TIME AS OF T1.rowtime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    @Test
    public void testRowTimeLeftTemporalJoinWithFilter() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 LEFT JOIN T3 FOR SYSTEM_TIME AS OF T1.rowtime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    @Test
    public void testLookupJoinOnTrue() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.LOOKUP_JOIN_WITHOUT_FILTER());
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T2 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON TRUE");
    }

    @Test
    public void testProcTimeTemporalJoinOnTrue() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITHOUT_FILTER());
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Currently the join key in Temporal Table Join can not be empty.");
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T3 FOR SYSTEM_TIME AS OF T1.rowtime AS dimTable ON TRUE");
    }

    @Test
    public void testRowTimeTemporalJoinOnTrue() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITHOUT_FILTER());
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Currently the join key in Temporal Table Join can not be empty.");
        this.util().verifyRelPlan("SELECT * FROM T1 JOIN T3 FOR SYSTEM_TIME AS OF T1.proctime AS dimTable ON TRUE");
    }

    @Test
    public void testRightTemporalJoin() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        this.expectedException().expect(AssertionError.class);
        this.expectedException().expectMessage("Correlate has invalid join type RIGHT");
        this.util().verifyRelPlan("SELECT * FROM T1 RIGHT JOIN T3 FOR SYSTEM_TIME AS OF T1.rowtime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    @Test
    public void testFullTemporalJoin() {
        this.setUpCurrentRule((RelOptRule)LogicalCorrelateToJoinFromTemporalTableRule$.MODULE$.WITH_FILTER());
        this.expectedException().expect(AssertionError.class);
        this.expectedException().expectMessage("Correlate has invalid join type FULL");
        this.util().verifyRelPlan("SELECT * FROM T1 FULL JOIN T3 FOR SYSTEM_TIME AS OF T1.rowtime AS dimTable ON T1.id = dimTable.id AND dimTable.rate > 10");
    }

    public void setUpCurrentRule(RelOptRule rule) {
        FlinkChainedProgram programs = new FlinkChainedProgram();
        programs.addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{rule})).build());
        this.util().replaceStreamProgram((FlinkChainedProgram<StreamOptimizeContext>)programs);
    }
}

