/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.factories.TableFactoryHarness;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE;
import org.apache.flink.table.planner.plan.rules.logical.PushProjectIntoLegacyTableSourceScanRuleTest;
import org.apache.flink.table.planner.plan.rules.logical.PushProjectIntoTableSourceScanRule;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.testutils.junit.SharedObjects;
import org.apache.flink.testutils.junit.SharedReference;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;

public class PushProjectIntoTableSourceScanRuleTest
extends PushProjectIntoLegacyTableSourceScanRuleTest {
    @Rule
    public final SharedObjects sharedObjects = SharedObjects.create();

    @Override
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{PushProjectIntoTableSourceScanRule.INSTANCE})).build());
        String ddl1 = "CREATE TABLE MyTable (\n  a int,\n  b bigint,\n  c string\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util().tableEnv().executeSql(ddl1);
        String ddl2 = "CREATE TABLE VirtualTable (\n  a int,\n  b bigint,\n  c string,\n  d as a + 1\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util().tableEnv().executeSql(ddl2);
        String ddl3 = "CREATE TABLE NestedTable (\n  id int,\n  deepNested row<nested1 row<name string, `value` int>, nested2 row<num int, flag boolean>>,\n  nested row<name string, `value` int>,\n  `deepNestedWith.` row<`.value` int, nested row<name string, `.value` int>>,\n  name string,\n  testMap Map<string, string>\n) WITH (\n 'connector' = 'values',\n 'nested-projection-supported' = 'true', 'bounded' = 'true'\n)";
        this.util().tableEnv().executeSql(ddl3);
        String ddl4 = "CREATE TABLE MetadataTable(\n  id int,\n  deepNested row<nested1 row<name string, `value` int>, nested2 row<num int, flag boolean>>,\n  metadata_1 int metadata,\n  metadata_2 string metadata,\n  metadata_3 as cast(metadata_1 as bigint)\n) WITH ( 'connector' = 'values', 'nested-projection-supported' = 'true', 'bounded' = 'true',\n 'readable-metadata' = 'metadata_1:INT, metadata_2:STRING, metadata_3:BIGINT')";
        this.util().tableEnv().executeSql(ddl4);
        String ddl5 = "CREATE TABLE UpsertTable(  id int,\n  deepNested row<nested1 row<name string, `value` int>, nested2 row<num int, flag boolean>>,\n  metadata_1 int metadata,\n  metadata_2 string metadata,\n  PRIMARY KEY(id, deepNested) NOT ENFORCED) WITH (  'connector' = 'values',  'nested-projection-supported' = 'true',  'bounded' = 'false',\n  'changelod-mode' = 'I,UB,D', 'readable-metadata' = 'metadata_1:INT, metadata_2:STRING, metadata_3:BIGINT')";
        this.util().tableEnv().executeSql(ddl5);
        String ddl6 = "CREATE TABLE NestedItemTable (\n  `ID` INT,\n  `Timestamp` TIMESTAMP(3),\n  `Result` ROW<\n    `Mid` ROW<      `data_arr` ROW<`value` BIGINT> ARRAY,\n      `data_map` MAP<STRING, ROW<`value` BIGINT>>     >   >,\n   WATERMARK FOR `Timestamp` AS `Timestamp`\n) WITH (\n 'connector' = 'values',\n 'nested-projection-supported' = 'true', 'bounded' = 'true'\n)";
        this.util().tableEnv().executeSql(ddl6);
        String ddl7 = "CREATE TABLE ItemTable (\n  `ID` INT,\n  `Timestamp` TIMESTAMP(3),\n  `Result` ROW<\n    `data_arr` ROW<`value` BIGINT> ARRAY,\n    `data_map` MAP<STRING, ROW<`value` BIGINT>>>,\n  `outer_array` ARRAY<INT>,\n  `outer_map` MAP<STRING, STRING>,\n   WATERMARK FOR `Timestamp` AS `Timestamp`\n) WITH (\n 'connector' = 'values',\n 'bounded' = 'true'\n)";
        this.util().tableEnv().executeSql(ddl7);
    }

    @Test
    public void testProjectWithMapType() {
        String sqlQuery = "SELECT id, testMap['e']\nFROM NestedTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Override
    @Test
    public void testNestedProject() {
        String sqlQuery = "SELECT id,\n    deepNested.nested1.name AS nestedName,\n    nested.`value` AS nestedValue,\n    deepNested.nested2.flag AS nestedFlag,\n    deepNested.nested2.num AS nestedNum\nFROM NestedTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testComplicatedNestedProject() {
        String sqlQuery = "SELECT id,    deepNested.nested1.name AS nestedName,\n    (`deepNestedWith.`.`.value` + `deepNestedWith.`.nested.`.value`) AS nestedSum\nFROM NestedTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testProjectWithDuplicateMetadataKey() {
        String sqlQuery = "SELECT id, metadata_3, metadata_1 FROM MetadataTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNestProjectWithMetadata() {
        String sqlQuery = "SELECT id,    deepNested.nested1 AS nested1,\n    deepNested.nested1.`value` + deepNested.nested2.num + metadata_1 as results\nFROM MetadataTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNestProjectWithUpsertSource() {
        String sqlQuery = "SELECT id,    deepNested.nested1 AS nested1,\n    deepNested.nested1.`value` + deepNested.nested2.num + metadata_1 as results\nFROM MetadataTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testNestedProjectFieldAccessWithITEM() {
        this.util().verifyRelPlan("SELECT `Result`.`Mid`.data_arr[ID].`value`, `Result`.`Mid`.data_map['item'].`value` FROM NestedItemTable");
    }

    @Test
    public void testNestedProjectFieldAccessWithITEMWithConstantIndex() {
        this.util().verifyRelPlan("SELECT `Result`.`Mid`.data_arr[2].`value`, `Result`.`Mid`.data_arr FROM NestedItemTable");
    }

    @Test
    public void testNestedProjectFieldAccessWithITEMContainsTopLevelAccess() {
        this.util().verifyRelPlan("SELECT `Result`.`Mid`.data_arr[2].`value`, `Result`.`Mid`.data_arr[ID].`value`, `Result`.`Mid`.data_map['item'].`value`, `Result`.`Mid` FROM NestedItemTable");
    }

    @Test
    public void testProjectFieldAccessWithITEM() {
        this.util().verifyRelPlan("SELECT `Result`.data_arr[ID].`value`, `Result`.data_map['item'].`value`, `outer_array`[1], `outer_array`[ID], `outer_map`['item'] FROM ItemTable");
    }

    @Test
    public void testMetadataProjectionWithoutProjectionPushDownWhenSupported() {
        SharedReference appliedKeys = this.sharedObjects.add(new ArrayList());
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(NoPushDownSource.SCHEMA).source(new NoPushDownSource(true, (SharedReference<List<String>>)appliedKeys)).build();
        this.util().tableEnv().createTable("T1", sourceDescriptor);
        this.util().verifyRelPlan("SELECT m1, metadata FROM T1");
        Assertions.assertThat((List)((List)appliedKeys.get())).contains((Object[])new String[]{"m1", "m2"});
    }

    @Test
    public void testMetadataProjectionWithoutProjectionPushDownWhenNotSupported() {
        SharedReference appliedKeys = this.sharedObjects.add(new ArrayList());
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(NoPushDownSource.SCHEMA).source(new NoPushDownSource(false, (SharedReference<List<String>>)appliedKeys)).build();
        this.util().tableEnv().createTable("T2", sourceDescriptor);
        this.util().verifyRelPlan("SELECT m1, metadata FROM T2");
        Assertions.assertThat((List)((List)appliedKeys.get())).contains((Object[])new String[]{"m1", "m2", "m3"});
    }

    @Test
    public void testMetadataProjectionWithoutProjectionPushDownWhenSupportedAndNoneSelected() {
        SharedReference appliedKeys = this.sharedObjects.add(new ArrayList());
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(NoPushDownSource.SCHEMA).source(new NoPushDownSource(true, (SharedReference<List<String>>)appliedKeys)).build();
        this.util().tableEnv().createTable("T3", sourceDescriptor);
        this.util().verifyRelPlan("SELECT 1 FROM T3");
        Assertions.assertThat((List)((List)appliedKeys.get())).hasSize(1);
    }

    @Test
    public void testMetadataProjectionWithoutProjectionPushDownWhenNotSupportedAndNoneSelected() {
        SharedReference appliedKeys = this.sharedObjects.add(new ArrayList());
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(NoPushDownSource.SCHEMA).source(new NoPushDownSource(false, (SharedReference<List<String>>)appliedKeys)).build();
        this.util().tableEnv().createTable("T4", sourceDescriptor);
        this.util().verifyRelPlan("SELECT 1 FROM T4");
        Assertions.assertThat((List)((List)appliedKeys.get())).contains((Object[])new String[]{"m1", "m2", "m3"});
    }

    @Test
    public void testProjectionIncludingOnlyMetadata() {
        AtomicReference<Object> appliedProjectionDataType = new AtomicReference<Object>(null);
        AtomicReference<Object> appliedMetadataDataType = new AtomicReference<Object>(null);
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(PushDownSource.SCHEMA).source(new PushDownSource(appliedProjectionDataType, appliedMetadataDataType)).build();
        this.util().tableEnv().createTable("T5", sourceDescriptor);
        this.util().verifyRelPlan("SELECT metadata FROM T5");
        Assertions.assertThat(appliedProjectionDataType.get()).isNotNull();
        Assertions.assertThat(appliedMetadataDataType.get()).isNotNull();
        Assertions.assertThat((List)DataType.getFieldNames((DataType)appliedProjectionDataType.get())).isEmpty();
        Assertions.assertThat((List)DataType.getFieldNames((DataType)appliedMetadataDataType.get())).containsExactly((Object[])new String[]{"metadata"});
    }

    @Test
    public void testProjectionWithMetadataAndPhysicalFields() {
        AtomicReference<Object> appliedProjectionDataType = new AtomicReference<Object>(null);
        AtomicReference<Object> appliedMetadataDataType = new AtomicReference<Object>(null);
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(PushDownSource.SCHEMA).source(new PushDownSource(appliedProjectionDataType, appliedMetadataDataType)).build();
        this.util().tableEnv().createTable("T5", sourceDescriptor);
        this.util().verifyRelPlan("SELECT metadata, f1 FROM T5");
        Assertions.assertThat(appliedProjectionDataType.get()).isNotNull();
        Assertions.assertThat(appliedMetadataDataType.get()).isNotNull();
        Assertions.assertThat((List)DataType.getFieldNames((DataType)appliedProjectionDataType.get())).containsExactly((Object[])new String[]{"f1"});
        Assertions.assertThat((List)DataType.getFieldNames((DataType)appliedMetadataDataType.get())).isEqualTo(Arrays.asList("f1", "metadata"));
    }

    private static class PushDownSource
    extends TableFactoryHarness.ScanSourceBase
    implements SupportsReadingMetadata,
    SupportsProjectionPushDown {
        public static final Schema SCHEMA = Schema.newBuilder().column("f1", (AbstractDataType)DataTypes.STRING()).columnByMetadata("metadata", (AbstractDataType)DataTypes.STRING(), "m2").columnByMetadata("m3", (AbstractDataType)DataTypes.STRING()).build();
        private final AtomicReference<DataType> appliedProjectionType;
        private final AtomicReference<DataType> appliedMetadataType;

        private PushDownSource(AtomicReference<DataType> appliedProjectionType, AtomicReference<DataType> appliedMetadataType) {
            this.appliedProjectionType = appliedProjectionType;
            this.appliedMetadataType = appliedMetadataType;
        }

        public Map<String, DataType> listReadableMetadata() {
            HashMap<String, DataType> metadata = new HashMap<String, DataType>();
            metadata.put("m1", DataTypes.STRING());
            metadata.put("m2", DataTypes.STRING());
            metadata.put("m3", DataTypes.STRING());
            return metadata;
        }

        public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
            this.appliedMetadataType.set(producedDataType);
        }

        public boolean supportsNestedProjection() {
            return false;
        }

        public void applyProjection(int[][] projectedFields, DataType producedDataType) {
            this.appliedProjectionType.set(producedDataType);
        }
    }

    private static class NoPushDownSource
    extends TableFactoryHarness.ScanSourceBase
    implements SupportsReadingMetadata {
        public static final Schema SCHEMA = Schema.newBuilder().columnByMetadata("m1", (AbstractDataType)DataTypes.STRING()).columnByMetadata("metadata", (AbstractDataType)DataTypes.STRING(), "m2").columnByMetadata("m3", (AbstractDataType)DataTypes.STRING()).build();
        private final boolean supportsMetadataProjection;
        private final SharedReference<List<String>> appliedMetadataKeys;

        public NoPushDownSource(boolean supportsMetadataProjection, SharedReference<List<String>> appliedMetadataKeys) {
            this.supportsMetadataProjection = supportsMetadataProjection;
            this.appliedMetadataKeys = appliedMetadataKeys;
        }

        public Map<String, DataType> listReadableMetadata() {
            HashMap<String, DataType> metadata = new HashMap<String, DataType>();
            metadata.put("m1", DataTypes.STRING());
            metadata.put("m2", DataTypes.STRING());
            metadata.put("m3", DataTypes.STRING());
            return metadata;
        }

        public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
            ((List)this.appliedMetadataKeys.get()).clear();
            ((List)this.appliedMetadataKeys.get()).addAll(metadataKeys);
        }

        public boolean supportsMetadataProjection() {
            return this.supportsMetadataProjection;
        }
    }
}

