/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.planner.factories.TableFactoryHarness;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;

public class RemoveUnreachableCoalesceArgumentsRuleTest
extends TableTestBase {
    private StreamTableTestUtil util;

    @Before
    public void before() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        TableDescriptor sourceDescriptor = TableFactoryHarness.newBuilder().schema(Schema.newBuilder().column("f0", DataTypes.STRING().nullable()).column("f1", DataTypes.STRING().notNull()).column("f2", DataTypes.STRING().nullable()).build()).unboundedScanSource().build();
        this.util.tableEnv().createTable("T", sourceDescriptor);
    }

    @Test
    public void testOnlyLastNonNull() {
        this.util.verifyRelPlan("SELECT COALESCE(f0, f1) FROM T");
    }

    @Test
    public void testAllNullable() {
        this.util.verifyRelPlan("SELECT COALESCE(f0, f2) FROM T");
    }

    @Test
    public void testDropLastConstant() {
        this.util.verifyRelPlan("SELECT COALESCE(f0, f1, '-') FROM T");
    }

    @Test
    public void testDropCoalesce() {
        this.util.verifyRelPlan("SELECT COALESCE(f1, '-') FROM T");
    }

    @Test
    public void testFilterCoalesce() {
        this.util.verifyRelPlan("SELECT * FROM T WHERE COALESCE(f0, f1, '-') = 'abc'");
    }

    @Test
    public void testJoinCoalesce() {
        this.util.verifyRelPlan("SELECT * FROM T t1 LEFT JOIN T t2 ON COALESCE(t1.f0, '-', t1.f2) = t2.f0");
    }

    @Test
    public void testMultipleCoalesces() {
        this.util.verifyRelPlan("SELECT COALESCE(1),\nCOALESCE(1, 2),\nCOALESCE(cast(NULL as int), 2),\nCOALESCE(1, cast(NULL as int)),\nCOALESCE(cast(NULL as int), cast(NULL as int), 3),\nCOALESCE(4, cast(NULL as int), cast(NULL as int), cast(NULL as int)),\nCOALESCE('1'),\nCOALESCE('1', '23'),\nCOALESCE(cast(NULL as varchar), '2'),\nCOALESCE('1', cast(NULL as varchar)),\nCOALESCE(cast(NULL as varchar), cast(NULL as varchar), '3'),\nCOALESCE('4', cast(NULL as varchar), cast(NULL as varchar), cast(NULL as varchar)),\nCOALESCE(1.0),\nCOALESCE(1.0, 2),\nCOALESCE(cast(NULL as double), 2.0),\nCOALESCE(cast(NULL as double), 2.0, 3.0),\nCOALESCE(2.0, cast(NULL as double), 3.0),\nCOALESCE(cast(NULL as double), cast(NULL as double))");
    }
}

