/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.rules.logical.SplitAggregateRuleTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001'\t12\u000b\u001d7ji\u0006;wM]3hCR,'+\u001e7f)\u0016\u001cHO\u0003\u0002\u0004\t\u00059An\\4jG\u0006d'BA\u0003\u0007\u0003\u0015\u0011X\u000f\\3t\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0006kRLGn]\u0005\u00033Y\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\n\u0005\nA!\u001e;jYV\t!\u0005\u0005\u0002\u0016G%\u0011AE\u0006\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u0002+Q,7\u000f^*j]\u001edW\rR5ti&t7\r^!hOR\t!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0003V]&$\bFA\u00142!\t\u0011T'D\u00014\u0015\t!\u0004#A\u0003kk:LG/\u0003\u00027g\t!A+Z:u\u0011\u0015A\u0004\u0001\"\u0001*\u0003A!Xm\u001d;TS:<G.Z'j]\u0006;w\r\u000b\u00028c!)1\b\u0001C\u0001S\u00059B/Z:u'&tw\r\\3GSJ\u001cHOV1mk\u0016\fum\u001a\u0015\u0003uEBQA\u0010\u0001\u0005\u0002%\nQ\u0003^3ti6+H\u000e^5ESN$\u0018N\\2u\u0003\u001e<7\u000f\u000b\u0002>c!)\u0011\t\u0001C\u0001S\u0005aB/Z:u'&tw\r\\3NCb<\u0016\u000e\u001e5ESN$\u0018N\\2u\u0003\u001e<\u0007F\u0001!2\u0011\u0015!\u0005\u0001\"\u0001*\u0003\r\"Xm\u001d;TS:<G.\u001a$jeN$h+\u00197vK^KG\u000f\u001b#jgRLgn\u0019;BO\u001eD#aQ\u0019\t\u000b\u001d\u0003A\u0011A\u0015\u0002EQ,7\u000f^*j]\u001edW\rT1tiZ\u000bG.^3XSRDG)[:uS:\u001cG/Q4hQ\t1\u0015\u0007C\u0003K\u0001\u0011\u0005\u0011&\u0001\u0011uKN$8+\u001b8hY\u0016d\u0015n\u001d;BO\u001e<\u0016\u000e\u001e5ESN$\u0018N\\2u\u0003\u001e<\u0007FA%2\u0011\u0015i\u0005\u0001\"\u0001*\u0003)\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e<\u0016\u000e\u001e5BY2tuN\u001c#jgRLgn\u0019;BO\u001eD#\u0001T\u0019\t\u000bA\u0003A\u0011A\u0015\u0002AQ,7\u000f^*j]\u001edW\rR5ti&t7\r^!hO^KG\u000f[$s_V\u0004()\u001f\u0015\u0003\u001fFBQa\u0015\u0001\u0005\u0002%\na\u0007^3tiNKgn\u001a7f\t&\u001cH/\u001b8di\u0006;wmV5uQ\u0006sGMT8o\t&\u001cH/\u001b8di\u0006;wm\u00148TC6,7i\u001c7v[:D#AU\u0019\t\u000bY\u0003A\u0011A\u0015\u0002UQ,7\u000f^*p[\u0016\u001cu\u000e\\;n]N\u0014u\u000e\u001e5J]\u0012K7\u000f^5oGR\fumZ!oI\u001e\u0013x.\u001e9Cs\"\u0012Q+\r\u0005\u00063\u0002!\t!K\u0001\u0018i\u0016\u001cH/Q4h/&$\bNR5mi\u0016\u00148\t\\1vg\u0016D#\u0001W\u0019\t\u000bq\u0003A\u0011A\u0015\u0002#Q,7\u000f^'vYRLwI]8va\nK8\u000f\u000b\u0002\\c!)q\f\u0001C\u0001S\u0005yA/Z:u\u0003\u001e<w+\u001b;i\u0015>Lg\u000e\u000b\u0002_c!)!\r\u0001C\u0001S\u0005AB/Z:u\u0005V\u001c7.\u001a;t\u0007>tg-[4ve\u0006$\u0018n\u001c8)\u0005\u0005\f\u0004\"B3\u0001\t\u0003I\u0013a\t;fgRlU\u000f\u001c;ja2,G)[:uS:\u001cG/Q4h\u001f:\u001c\u0016-\\3D_2,XN\u001c\u0015\u0003IFBQ\u0001\u001b\u0001\u0005\u0002%\na\u0005^3ti\u0006;wMR5mi\u0016\u00148\t\\1vg\u0016\u0014u\u000e\u001e5XSRD\u0017I^4B]\u0012\u001cu.\u001e8uQ\t9\u0017\u0007")
public class SplitAggregateRuleTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testSingleDistinctAgg() {
        this.util().verifyRelPlan("SELECT COUNT(DISTINCT c) FROM MyTable");
    }

    @Test
    public void testSingleMinAgg() {
        this.util().verifyRelPlan("SELECT MIN(c) FROM MyTable");
    }

    @Test
    public void testSingleFirstValueAgg() {
        this.util().verifyRelPlan("SELECT FIRST_VALUE(c) FROM MyTable GROUP BY a");
    }

    @Test
    public void testMultiDistinctAggs() {
        this.util().verifyRelPlan("SELECT COUNT(DISTINCT a), SUM(DISTINCT b) FROM MyTable");
    }

    @Test
    public void testSingleMaxWithDistinctAgg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT b), MAX(c)\n        |FROM MyTable\n        |GROUP BY a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSingleFirstValueWithDistinctAgg() {
        this.util().verifyRelPlan("SELECT a, FIRST_VALUE(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleLastValueWithDistinctAgg() {
        this.util().verifyRelPlan("SELECT a, LAST_VALUE(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleListAggWithDistinctAgg() {
        this.util().verifyRelPlan("SELECT a, LISTAGG(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleDistinctAggWithAllNonDistinctAgg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT c), SUM(b), AVG(b), MAX(b), MIN(b), COUNT(b), COUNT(*)\n        |FROM MyTable\n        |GROUP BY a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSingleDistinctAggWithGroupBy() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT c) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleDistinctAggWithAndNonDistinctAggOnSameColumn() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT b), SUM(b), AVG(b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSomeColumnsBothInDistinctAggAndGroupBy() {
        this.util().verifyRelPlan("SELECT a, COUNT(DISTINCT a), COUNT(b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testAggWithFilterClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b) FILTER (WHERE NOT b = 2),\n         |  SUM(b) FILTER (WHERE NOT b = 5),\n         |  SUM(b) FILTER (WHERE NOT b = 2)\n         |FROM MyTable\n         |GROUP BY a\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultiGroupBys() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  c, MIN(b), MAX(b), SUM(b), COUNT(*), COUNT(DISTINCT a)\n         |FROM(\n         |  SELECT\n         |    a, AVG(b) as b, MAX(c) as c\n         |  FROM MyTable\n         |  GROUP BY a\n         |) GROUP BY c\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggWithJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT *\n         |FROM(\n         |  SELECT\n         |    c, SUM(b) as b, SUM(b) as d, COUNT(DISTINCT a) as a\n         |  FROM(\n         |    SELECT\n         |      a, COUNT(DISTINCT b) as b, SUM(b) as c, SUM(b) as d\n         |    FROM MyTable\n         |    GROUP BY a)\n         |  GROUP BY c\n         |) as MyTable1 JOIN MyTable ON MyTable1.b = MyTable.a\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testBucketsConfiguration() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_BUCKET_NUM, (Object)100);
        String sqlQuery = "SELECT COUNT(DISTINCT c) FROM MyTable";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testMultipleDistinctAggOnSameColumn() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b),\n         |  COUNT(DISTINCT b) FILTER(WHERE b <> 5),\n         |  SUM(b),\n         |  AVG(b)\n         |FROM MyTable\n         |GROUP BY a\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testAggFilterClauseBothWithAvgAndCount() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b) FILTER (WHERE NOT b = 2),\n         |  SUM(b) FILTER (WHERE NOT b = 5),\n         |  COUNT(b),\n         |  AVG(b),\n         |  SUM(b)\n         |FROM MyTable\n         |GROUP BY a\n         |")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    public SplitAggregateRuleTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.SplitAggregateRuleTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().buildStreamProgram(FlinkStreamProgram$.MODULE$.PHYSICAL());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }
}

