/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.CalcTest$;
import org.apache.flink.table.planner.plan.utils.MyPojo;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u0001M\u0011\u0001bQ1mGR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0014\u0001A\u0003%!%A\u0003vi&d\u0007\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0003tKR,\b\u000fF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\u001d\n\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0011\u0003\u0015QWO\\5u\u0013\t14G\u0001\u0004CK\u001a|'/\u001a\u0005\u0006q\u0001!\t!K\u0001\u0010i\u0016\u001cHo\u00148msB\u0013xN[3di\"\u0012qG\u000f\t\u0003emJ!\u0001P\u001a\u0003\tQ+7\u000f\u001e\u0005\u0006}\u0001!\t!K\u0001\u0016i\u0016\u001cH\u000f\u0015:pU\u0016\u001cGoV5uQ:\u000bW.\u001b8hQ\ti$\bC\u0003B\u0001\u0011\u0005\u0011&A\tuKN$X*\u001e7uSB\u0013xN[3diND#\u0001\u0011\u001e\t\u000b\u0011\u0003A\u0011A\u0015\u0002\u001dQ,7\u000f^(oYf4\u0015\u000e\u001c;fe\"\u00121I\u000f\u0005\u0006\u000f\u0002!\t!K\u0001\u0016i\u0016\u001cH\u000fR5tUVt7\r^5wK\u001aKG\u000e^3sQ\t1%\bC\u0003K\u0001\u0011\u0005\u0011&A\u000buKN$8i\u001c8kk:\u001cG/\u001b<f\r&dG/\u001a:)\u0005%S\u0004\"B'\u0001\t\u0003I\u0013\u0001\u0005;fgRlU\u000f\u001c;j\r&dG/\u001a:tQ\ta%\bC\u0003Q\u0001\u0011\u0005\u0011&\u0001\u000buKN$\bK]8kK\u000e$\u0018I\u001c3GS2$XM\u001d\u0015\u0003\u001fjBQa\u0015\u0001\u0005\u0002%\na\u0001^3ti&s\u0007F\u0001*;\u0011\u00151\u0006\u0001\"\u0001*\u0003m!Xm\u001d;GS2$XM](o\u001d>t\u0017i]2jS2KG/\u001a:bY\"\u0012QK\u000f\u0005\u00063\u0002!\t!K\u0001\ni\u0016\u001cHOT8u\u0013:D#\u0001\u0017\u001e\t\u000bq\u0003A\u0011A\u0015\u0002-Q,7\u000f^'vYRL\u0007\u000f\\3GY\u0006$H/\u001a8j]\u001eD#a\u0017\u001e\t\u000b}\u0003A\u0011A\u0015\u0002#Q,7\u000f^%om\u0006d\u0017\u000e\u001a$jK2$7\u000f\u000b\u0003_u\u0005\u0014\u0017\u0001C3ya\u0016\u001cG/\u001a3$\u0003\r\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a\u0006\u0002\u0007\u0005\u0004\u0018.\u0003\u0002iK\n\u0019b+\u00197jI\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\")!\u000e\u0001C\u0001S\u0005!B/Z:u!JLW.\u001b;jm\u0016l\u0015\r\u001d+za\u0016D#!\u001b\u001e\t\u000b5\u0004A\u0011A\u0015\u0002/Q,7\u000f\u001e(p]B\u0013\u0018.\\5uSZ,W*\u00199UsB,\u0007F\u00017;\u0011\u0015\u0001\b\u0001\"\u0001*\u0003-!Xm\u001d;S_^$\u0016\u0010]3)\u0005=T\u0004\"B:\u0001\t\u0003I\u0013!\u0004;fgR\f%O]1z)f\u0004X\r\u000b\u0002su!)a\u000f\u0001C\u0001S\u00059B/Z:u!J|'.Z2u/&$\b\u000eR1uKRK\b/\u001a\u0015\u0003kjBQ!\u001f\u0001\u0005\u0002%\na\u0003^3ti\u001aKG\u000e^3s/&$\b\u000eR1uKRK\b/\u001a\u0015\u0003qjBQ\u0001 \u0001\u0005\u0002%\nA\u0002^3tiB{'n\u001c+za\u0016D#a\u001f\u001e\t\u000b}\u0004A\u0011A\u0015\u0002\u001bQ,7\u000f^'jq\u0016$G+\u001f9fQ\tq(\b\u0003\u0004\u0002\u0006\u0001!\t!K\u0001\u001ai\u0016\u001cHo\u0014:XSRD\u0017j\u001d(vY2\u0004&/\u001a3jG\u0006$X\rK\u0002\u0002\u0004iBa!a\u0003\u0001\t\u0003I\u0013\u0001\u0006;fgR|%oV5uQ&\u001bh*\u001e7m\u0013:Le\rK\u0002\u0002\niBa!!\u0005\u0001\t\u0003I\u0013A\n;fgR$UmY5nC2\f%O]1z/&$\b\u000eR5gM\u0016\u0014XM\u001c;Qe\u0016\u001c\u0017n]5p]\"\u001a\u0011q\u0002\u001e\t\r\u0005]\u0001\u0001\"\u0001*\u0003\u0011\"Xm\u001d;EK\u000eLW.\u00197NCB<\u0016\u000e\u001e5ES\u001a4WM]3oiB\u0013XmY5tS>t\u0007fAA\u000bu!1\u0011Q\u0004\u0001\u0005\u0002%\nQ\u0005^3ti\u000e\u000bGnY'fe\u001e,w+\u001b;i\u001d>tG)\u001a;fe6Lg.[:uS\u000e,\u0005\u0010\u001d:)\u0007\u0005m!\b\u0003\u0004\u0002$\u0001!\t!K\u0001'i\u0016\u001cHoQ1mG6+'oZ3XSRDgj\u001c8EKR,'/\\5oSN$\u0018nY#yaJ\u0014\u0004fAA\u0011u\u0001")
public class CalcTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.CalcTest$$anon$9 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addFunction("random_udf", new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
    }

    @Test
    public void testOnlyProject() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable");
    }

    @Test
    public void testProjectWithNaming() {
        this.util().verifyExecPlan("SELECT `1-_./\u00dc`, b, c FROM (SELECT a as `1-_./\u00dc`, b, c FROM MyTable)");
    }

    @Test
    public void testMultiProjects() {
        this.util().verifyExecPlan("SELECT c FROM (SELECT a, c FROM MyTable)");
    }

    @Test
    public void testOnlyFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE b > 0");
    }

    @Test
    public void testDisjunctiveFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a < 10 OR a > 20");
    }

    @Test
    public void testConjunctiveFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a < 10 AND b > 20");
    }

    @Test
    public void testMultiFilters() {
        this.util().verifyExecPlan("SELECT * FROM (SELECT * FROM MyTable WHERE b > 0) t WHERE a < 50");
    }

    @Test
    public void testProjectAndFilter() {
        this.util().verifyExecPlan("SELECT a, b + 1 FROM MyTable WHERE b > 2");
    }

    @Test
    public void testIn() {
        String sql = "SELECT * FROM MyTable WHERE b IN (1, 3, 4, 5, 6) AND c = 'xx'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testFilterOnNonAsciiLiteral() {
        String sql = "SELECT a, b, c, c || TRIM(' \u4e16\u754c ') FROM MyTable WHERE c = '\u4f60\u597d'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testNotIn() {
        String sql = "SELECT * FROM MyTable WHERE b NOT IN (1, 3, 4, 5, 6) OR c = 'xx'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultipleFlattening() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>> unused = new ScalaCaseClassSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>>(this, fieldSerializers){

                    public Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((Tuple2)fields[0]), (Object)((Tuple2)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.plan.stream.sql.CalcTest$$anon$10 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT MyTable2.a.*, c, MyTable2.b.* FROM MyTable2");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidFields() {
        this.util().tableEnv().sqlQuery("SELECT a, foo FROM MyTable");
    }

    @Test
    public void testPrimitiveMapType() {
        this.util().verifyExecPlan("SELECT MAP[b, 30, 10, a] FROM MyTable");
    }

    @Test
    public void testNonPrimitiveMapType() {
        this.util().verifyExecPlan("SELECT MAP[a, c] FROM MyTable");
    }

    @Test
    public void testRowType() {
        this.util().verifyExecPlan("SELECT ROW(1, 'Hi', a) FROM MyTable");
    }

    @Test
    public void testArrayType() {
        this.util().verifyExecPlan("SELECT ARRAY['Hi', 'Hello', c] FROM MyTable");
    }

    @Test
    public void testProjectWithDateType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c,\n        | DATE '1984-07-12',\n        | TIME '14:34:24',\n        | TIMESTAMP '1984-07-12 14:34:24'\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testFilterWithDateType() {
        this.util().addTableSource("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, Date, Time, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Date, Time, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Date, Time, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Date, Time, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Date, Time, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((Date)fields[1]), (Object)((Time)fields[2]), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.plan.stream.sql.CalcTest$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable3\n        |WHERE b = DATE '1984-07-12' AND c = TIME '14:34:24' AND d = TIMESTAMP '1984-07-12 14:34:24'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testPojoType() {
        this.util().addTableSource("MyTable4", (TypeInformation[])((Object[])new TypeInformation[]{TypeExtractor.createTypeInfo(MyPojo.class)}), (String[])((Object[])new String[]{"a"}));
        this.util().verifyExecPlan("SELECT a FROM MyTable4");
    }

    @Test
    public void testMixedType() {
        this.util().addTableSource("MyTable5", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.plan.stream.sql.CalcTest$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT ROW(a, b, c), ARRAY[12, b], MAP[a, c] FROM MyTable5 WHERE (a, b, c) = ('foo', 12, TIMESTAMP '1984-07-12 14:34:24')");
    }

    @Test
    public void testOrWithIsNullPredicate() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 10 OR a IS NULL");
    }

    @Test
    public void testOrWithIsNullInIf() {
        this.util().verifyExecPlan("SELECT IF(c = '' OR c IS NULL, 'a', 'b') FROM MyTable");
    }

    @Test
    public void testDecimalArrayWithDifferentPrecision() {
        this.util().verifyExecPlan("SELECT ARRAY[0.12, 0.5, 0.99]");
    }

    @Test
    public void testDecimalMapWithDifferentPrecision() {
        this.util().verifyExecPlan("SELECT MAP['a', 0.12, 'b', 0.5]");
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr() {
        String sqlQuery = "SELECT a, a1 FROM (SELECT a, random_udf(b) AS a1 FROM MyTable) t WHERE a1 > 10";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr2() {
        String sqlQuery = "SELECT a FROM (SELECT a, b FROM MyTable) t WHERE random_udf(b) > 10";
        this.util().verifyRelPlan(sqlQuery);
    }
}

