/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.DeduplicateTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001'\tyA)\u001a3va2L7-\u0019;f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0005!\u0001\u0001\u0007\t\u0019!C\u0001C\u0005!Q\u000f^5m+\u0005\u0011\u0003CA\u000b$\u0013\t!cCA\nTiJ,\u0017-\u001c+bE2,G+Z:u+RLG\u000eC\u0005'\u0001\u0001\u0007\t\u0019!C\u0001O\u0005AQ\u000f^5m?\u0012*\u0017\u000f\u0006\u0002)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t!QK\\5u\u0011\u001dyS%!AA\u0002\t\n1\u0001\u001f\u00132\u0011%\t\u0004\u00011A\u0001B\u0003&!%A\u0003vi&d\u0007\u0005C\u00034\u0001\u0011\u0005A'A\u0003tKR,\u0006\u000fF\u0001)Q\t\u0011d\u0007\u0005\u00028u5\t\u0001H\u0003\u0002:!\u0005)!.\u001e8ji&\u00111\b\u000f\u0002\u0007\u0005\u00164wN]3\t\u000bu\u0002A\u0011\u0001\u001b\u0002OQ,7\u000f^%om\u0006d\u0017\u000e\u001a*po:+XNY3s\u0007>tG-\u001b;j_:|e\u000e\u0015:pGRLW.\u001a\u0015\u0003y}\u0002\"a\u000e!\n\u0005\u0005C$\u0001\u0002+fgRDQa\u0011\u0001\u0005\u0002Q\na\u0005^3ti&sg/\u00197jIJ{wOT;nE\u0016\u00148i\u001c8eSRLwN\\(o%><H/[7fQ\t\u0011u\bC\u0003G\u0001\u0011\u0005A'\u0001\u0010uKN$H*Y:u%><x+\u001b;i/&tGm\\<P]J{w\u000f^5nK\"\u0012Qi\u0010\u0005\u0006\u0013\u0002!\t\u0001N\u0001\u001ci\u0016\u001cHoU5na2,g)\u001b:tiJ{wo\u00148S_^$\u0018.\\3)\u0005!{\u0004\"\u0002'\u0001\t\u0003!\u0014a\t;fgRl\u0015N\\5CCR\u001c\u0007.\u00138gKJ4\u0015N]:u%><xJ\u001c*poRLW.\u001a\u0015\u0003\u0017~BQa\u0014\u0001\u0005\u0002Q\n!\u0004^3tiNKW\u000e\u001d7f\u0019\u0006\u001cHOU8x\u001f:\u0014vn\u001e;j[\u0016D#AT \t\u000bI\u0003A\u0011\u0001\u001b\u0002EQ,7\u000f^'j]&\u0014\u0015\r^2i\u0013:4WM\u001d'bgR\u0014vn^(o%><H/[7fQ\t\tv\bC\u0003V\u0001\u0011\u0005A'A\u000euKN$8+[7qY\u0016d\u0015m\u001d;S_^|e\u000e\u0015:pGRLW.\u001a\u0015\u0003)~BQ\u0001\u0017\u0001\u0005\u0002Q\n!\u0005^3tiNKW\u000e\u001d7f\u0019\u0006\u001cHOU8x\u001f:\u0014U/\u001b7uS:\u0004&o\\2uS6,\u0007FA,@\u0011\u0015Y\u0006\u0001\"\u00015\u0003q!Xm\u001d;TS6\u0004H.\u001a$jeN$(k\\<P]B\u0013xn\u0019;j[\u0016D#AW \t\u000by\u0003A\u0011\u0001\u001b\u0002GQ,7\u000f^*j[BdWMR5sgR\u0014vn^(o\u0005VLG\u000e^5o!J|7\r^5nK\"\u0012Ql\u0010")
public class DeduplicateTest
extends TableTestBase {
    private StreamTableTestUtil util;

    public StreamTableTestUtil util() {
        return this.util;
    }

    public void util_$eq(StreamTableTestUtil x$1) {
        this.util = x$1;
    }

    @Before
    public void setUp() {
        this.util_$eq(this.streamTestUtil(this.streamTestUtil$default$1()));
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.DeduplicateTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testInvalidRowNumberConditionOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT a, ROW_NUMBER() OVER (PARTITION BY b ORDER BY proctime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 2\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInvalidRowNumberConditionOnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT a, ROW_NUMBER() OVER (PARTITION BY b ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testLastRowWithWindowOnRowtime() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofMillis(500L));
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE T (\n        | `a` INT,\n        | `b` STRING,\n        | `ts` TIMESTAMP(3),\n        | WATERMARK FOR `ts` AS `ts`\n        |) WITH (\n        | 'connector' = 'COLLECTION',\n        | 'is-bounded' = 'false'\n        |)\n      ")).stripMargin());
        String deduplicateSQl = new StringOps(Predef$.MODULE$.augmentString("\n        |(\n        |SELECT a, b, ts\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER (PARTITION BY a ORDER BY ts DESC) as rowNum\n        |  FROM T\n        |)\n        |WHERE rowNum = 1\n        |)\n      ")).stripMargin();
        String windowSql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(151).append("\n         |select b, sum(a), TUMBLE_START(ts, INTERVAL '0.004' SECOND)\n         |FROM ").append(deduplicateSQl).append("\n         |GROUP BY b, TUMBLE(ts, INTERVAL '0.004' SECOND)\n      ").toString())).stripMargin();
        this.util().verifyExplain(windowSql);
    }

    @Test
    public void testSimpleFirstRowOnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime ASC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num <= 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMiniBatchInferFirstRowOnRowtime() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)3L));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |    a INT,\n         |    b VARCHAR,\n         |    rowtime TIMESTAMP(3),\n         |    proctime as PROCTIME(),\n         |    WATERMARK FOR rowtime AS rowtime\n         |) WITH (\n         | 'connector' = 'COLLECTION',\n         | 'is-bounded' = 'false'\n         |)\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(b) FROM (\n        |  SELECT a, b\n        |  FROM (\n        |    SELECT *,\n        |        ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime ASC) as rank_num\n        |    FROM T)\n        |  WHERE rank_num <= 1\n        |)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleLastRowOnRowtime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMiniBatchInferLastRowOnRowtime() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)BoxesRunTime.boxToLong((long)3L));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (\n         |    a INT,\n         |    b VARCHAR,\n         |    rowtime TIMESTAMP(3),\n         |    proctime as PROCTIME(),\n         |    WATERMARK FOR rowtime AS rowtime\n         |) WITH (\n         | 'connector' = 'COLLECTION',\n         | 'is-bounded' = 'false'\n         |)\n         |")).stripMargin();
        this.util().tableEnv().executeSql(ddl);
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(b) FROM (\n        |  SELECT a, b\n        |  FROM (\n        |    SELECT *,\n        |        ROW_NUMBER() OVER (PARTITION BY a ORDER BY rowtime DESC) as rank_num\n        |    FROM T)\n        |  WHERE rank_num = 1\n        |)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleLastRowOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY proctime DESC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleLastRowOnBuiltinProctime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER (ORDER BY PROCTIME() DESC) as rowNum\n        |  FROM MyTable\n        |)\n        |WHERE rowNum = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSimpleFirstRowOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c\n        |FROM (\n        |  SELECT *,\n        |      ROW_NUMBER() OVER (PARTITION BY a ORDER BY proctime ASC) as rank_num\n        |  FROM MyTable)\n        |WHERE rank_num = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testSimpleFirstRowOnBuiltinProctime() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *,\n        |    ROW_NUMBER() OVER (PARTITION BY a ORDER BY PROCTIME() ASC) as rowNum\n        |  FROM MyTable\n        |)\n        |WHERE rowNum = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }
}

