/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u0001U\u0011Q\"Q4he\u0016<\u0017\r^3UKN$(BA\u0002\u0005\u0003\r\twm\u001a\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u0013)\tA\u0001\u001d7b]*\u00111\u0002D\u0001\ba2\fgN\\3s\u0015\tia\"A\u0003uC\ndWM\u0003\u0002\u0010!\u0005)a\r\\5oW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0005eQ\u0011!B;uS2\u001c\u0018BA\u000e\u0019\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\bE\u0001\u0011\r\u0011\"\u0003$\u0003\u0011)H/\u001b7\u0016\u0003\u0011\u0002\"aF\u0013\n\u0005\u0019B\"aE*ue\u0016\fW\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0015\u0001A\u0003%A%A\u0003vi&d\u0007\u0005C\u0003+\u0001\u0011\u00051&\u0001\u0010uKN$xI]8va&twm\u00148O_:,\u00050[:uK:$h)[3mIR\tA\u0006\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0003V]&$\b\u0006B\u00154si\u0002\"\u0001N\u001c\u000e\u0003UR!A\u000e\n\u0002\u000b),h.\u001b;\n\u0005a*$\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002wA\u0011AhP\u0007\u0002{)\u0011a\bD\u0001\u0004CBL\u0017B\u0001!>\u0005M1\u0016\r\\5eCRLwN\\#yG\u0016\u0004H/[8o\u0011\u0015\u0011\u0005\u0001\"\u0001,\u0003q!Xm\u001d;He>,\b/\u001b8h\u0013:4\u0018\r\\5e'\u0016dWm\u0019;j_:DC!Q\u001a:u!)Q\t\u0001C\u0001W\u0005aB/Z:u\u0007\u0006tgn\u001c;D_VtGo\u00148Nk2$\u0018NR5fY\u0012\u001c\bF\u0001#4\u0011\u0015A\u0005\u0001\"\u0001,\u0003Q!Xm\u001d;BO\u001e<\u0016\u000e\u001e5NS:L')\u0019;dQ\"\u0012qi\r\u0005\u0006\u0017\u0002!\taK\u0001\u001fi\u0016\u001cH/Q4h\u0003\u001a$XM]+oS>tw+\u001b;i\u001b&t\u0017NQ1uG\"D#AS\u001a\t\u000b9\u0003A\u0011A\u0016\u00021Q,7\u000f^$s_V\u0004()_,ji\"|W\u000f^,j]\u0012|w\u000f\u000b\u0002Ng!)\u0011\u000b\u0001C\u0001W\u0005aB/Z:u\u0019>\u001c\u0017\r\\$m_\n\fG.Q4h\u0003\u001a$XM]+oS>t\u0007F\u0001)4\u0011\u0015!\u0006\u0001\"\u0001,\u0003]!Xm\u001d;BO\u001e<\u0016\u000e\u001e5GS2$XM]\"mCV\u001cX\r\u000b\u0002Tg!)q\u000b\u0001C\u0001W\u00051C/Z:u\u0003\u001e<w+\u001b;i\r&dG/\u001a:DY\u0006,8/Z,ji\"dunY1m\u000f2|'-\u00197)\u0005Y\u001b\u0004\"\u0002.\u0001\t\u0003Y\u0013a\u0006;fgR\fumZ(o\t&4g-\u001a:f]R$\u0016\u0010]3tQ\tI6\u0007C\u0003^\u0001\u0011\u00051&A\fuKN$\u0018I^4P]\u0012KgMZ3sK:$H+\u001f9fg\"\u0012Al\r\u0005\u0006A\u0002!\taK\u0001\u0013i\u0016\u001cH/\u0011<h/&$\bNU3ue\u0006\u001cG\u000f\u000b\u0002`g!)1\r\u0001C\u0001W\u00059A/Z:u'Vl\u0007F\u000124\u0011\u00151\u0007\u0001\"\u0001,\u0003I!Xm\u001d;Tk6<\u0016\u000e\u001e5SKR\u0014\u0018m\u0019;)\u0005\u0015\u001c\u0004\"B5\u0001\t\u0003Y\u0013a\u0006;fgRl\u0015N\\(o\t&4g-\u001a:f]R$\u0016\u0010]3tQ\tA7\u0007C\u0003m\u0001\u0011\u00051&\u0001\nuKN$X*\u001b8XSRD'+\u001a;sC\u000e$\bFA64\u0011\u0015y\u0007\u0001\"\u0001,\u0003]!Xm\u001d;NCb|e\u000eR5gM\u0016\u0014XM\u001c;UsB,7\u000f\u000b\u0002og!)!\u000f\u0001C\u0001W\u0005\u0011B/Z:u\u001b\u0006Dx+\u001b;i%\u0016$(/Y2uQ\t\t8\u0007C\u0003v\u0001\u0011\u00051&\u0001\u000euKN$xI]8va\nKx+\u001b;i\u0007>t7\u000f^1oi.+\u0017\u0010\u000b\u0002ug!)\u0001\u0010\u0001C\u0001W\u0005aB/Z:u\u0007>dW/\u001c8J]R,'O^1m-\u0006d\u0017\u000eZ1uS>t\u0007FA<4\u0011\u0015Y\b\u0001\"\u0001,\u0003\u0011\"Xm\u001d;GS2$XM]3e\u0007>dW/\u001c8J]R,'O^1m-\u0006d\u0017\u000eZ1uS>t\u0007F\u0001>4\u0011\u0015q\b\u0001\"\u0001,\u0003i!Xm\u001d;He>,\boS3z\u001d>$X*\u0019;dQNKgn\u001b)lQ\ti8\u0007\u0003\u0004\u0002\u0004\u0001!\taK\u0001\u0015i\u0016\u001cHo\u0012:pkB\\U-_%o'&t7\u000eU6)\u0007\u0005\u00051\u0007\u0003\u0004\u0002\n\u0001!\taK\u0001'i\u0016\u001cHo\u0012:pkB\u0014Vm];mi2{7\u000f^+qg\u0016\u0014HoS3z/&$\bnU5oWB[\u0007fAA\u0004g!1\u0011q\u0002\u0001\u0005\u0002-\nA\u0004^3ti\u0006\u0003\bO]8yS6\fG/Z\"pk:$H)[:uS:\u001cG\u000f\u000b\u0004\u0002\u000eMJ\u00141C\u0012\u0003\u0003+\u00012\u0001PA\f\u0013\r\tI\"\u0010\u0002\u000f)\u0006\u0014G.Z#yG\u0016\u0004H/[8o\u0011\u0019\ti\u0002\u0001C\u0001W\u0005qA/Z:u\u0007>,h\u000e^*uCJ$\bfAA\u000eg!1\u00111\u0005\u0001\u0005\u0002-\n!\u0004^3ti\u000e{WO\u001c;Ti\u0006\u0014HoV5uQ6+G/\u00193bi\u0006D3!!\t4\u0011\u0019\tI\u0003\u0001C\u0001W\u0005qB/Z:u\u0007>,h\u000e^*uCJ$x+\u001b;i\u001b\u0016$\u0018\rZ1uC>sG.\u001f\u0015\u0004\u0003O\u0019\u0004BBA\u0018\u0001\u0011\u00051&A\u000euKN$8i\\;oiN#\u0018M\u001d;XSRDg*Z:uK\u0012\u0014vn\u001e\u0015\u0004\u0003[\u0019\u0004")
public class AggregateTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test(expected=ValidationException.class)
    public void testGroupingOnNonExistentField() {
        this.util().verifyExecPlan("SELECT COUNT(*) FROM MyTable GROUP BY foo");
    }

    @Test(expected=ValidationException.class)
    public void testGroupingInvalidSelection() {
        this.util().verifyExecPlan("SELECT b FROM MyTable GROUP BY a");
    }

    @Test
    public void testCannotCountOnMultiFields() {
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("We now only support the count of one field");
        this.util().verifyExecPlan("SELECT b, COUNT(a, c) FROM MyTable GROUP BY b");
    }

    @Test
    public void testAggWithMiniBatch() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        this.util().verifyExecPlan("SELECT b, COUNT(DISTINCT a), MAX(b), SUM(c)  FROM MyTable GROUP BY b");
    }

    @Test
    public void testAggAfterUnionWithMiniBatch() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, sum(b), count(distinct c)\n        |FROM (\n        |  SELECT * FROM T1\n        |  UNION ALL\n        |  SELECT * FROM T2\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(query);
    }

    @Test
    public void testGroupByWithoutWindow() {
        this.util().verifyExecPlan("SELECT COUNT(a) FROM MyTable GROUP BY b");
    }

    @Test
    public void testLocalGlobalAggAfterUnion() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, SUM(b), COUNT(DISTINCT c)\n        |FROM (\n        |  SELECT * FROM T1\n        |  UNION ALL\n        |  SELECT * FROM T2\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggWithFilterClause() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  SUM(b) FILTER (WHERE c = 'A'),\n        |  COUNT(DISTINCT c) FILTER (WHERE d is true),\n        |  MAX(b)\n        |FROM T GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggWithFilterClauseWithLocalGlobal() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(1L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  SUM(b) FILTER (WHERE c = 'A'),\n        |  COUNT(DISTINCT c) FILTER (WHERE d is true),\n        |  COUNT(DISTINCT c) FILTER (WHERE b = 1),\n        |  MAX(b)\n        |FROM T GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAggOnDifferentTypes() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  a,\n        |  SUM(CAST(1 as INT)),\n        |  SUM(CAST(2 as BIGINT)),\n        |  SUM(CAST(3 as TINYINT)),\n        |  SUM(CAST(4 as SMALLINT)),\n        |  SUM(CAST(5 as FLOAT)),\n        |  SUM(CAST(6 as DECIMAL)),\n        |  SUM(CAST(7 as DOUBLE))\n        |FROM T GROUP BY a\n    ")).stripMargin();
        this.util().verifyRelPlanWithType(sql);
    }

    @Test
    public void testAvgOnDifferentTypes() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT AVG(`byte`),\n                                 |       AVG(`short`),\n                                 |       AVG(`int`),\n                                 |       AVG(`long`),\n                                 |       AVG(`float`),\n                                 |       AVG(`double`),\n                                 |       AVG(`decimal3020`),\n                                 |       AVG(`decimal105`)\n                                 |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testAvgWithRetract() {
        this.util().verifyRelPlan("SELECT AVG(a) FROM (SELECT AVG(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSum() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT SUM(`byte`),\n                                 |       SUM(`short`),\n                                 |       SUM(`int`),\n                                 |       SUM(`long`),\n                                 |       SUM(`float`),\n                                 |       SUM(`double`),\n                                 |       SUM(`decimal3020`),\n                                 |       SUM(`decimal105`)\n                                 |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testSumWithRetract() {
        this.util().verifyRelPlan("SELECT SUM(a) FROM (SELECT SUM(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMinOnDifferentTypes() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT MIN(`byte`),\n                                 |       MIN(`short`),\n                                 |       MIN(`int`),\n                                 |       MIN(`long`),\n                                 |       MIN(`float`),\n                                 |       MIN(`double`),\n                                 |       MIN(`decimal3020`),\n                                 |       MIN(`decimal105`),\n                                 |       MIN(`boolean`),\n                                 |       MIN(`date`),\n                                 |       MIN(`time`),\n                                 |       MIN(`timestamp`),\n                                 |       MIN(`string`)\n                                 |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testMinWithRetract() {
        this.util().verifyRelPlan("SELECT MIN(a) FROM (SELECT MIN(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMaxOnDifferentTypes() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT MAX(`byte`),\n                                 |       MAX(`short`),\n                                 |       MAX(`int`),\n                                 |       MAX(`long`),\n                                 |       MAX(`float`),\n                                 |       MAX(`double`),\n                                 |       MAX(`decimal3020`),\n                                 |       MAX(`decimal105`),\n                                 |       MAX(`boolean`),\n                                 |       MAX(`date`),\n                                 |       MAX(`time`),\n                                 |       MAX(`timestamp`),\n                                 |       MAX(`string`)\n                                 |FROM MyTable1\n      ")).stripMargin());
    }

    @Test
    public void testMaxWithRetract() {
        this.util().verifyRelPlan("SELECT MAX(a) FROM (SELECT MAX(a) AS a FROM T GROUP BY b)", (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testGroupByWithConstantKey() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, MAX(b), c FROM (SELECT a, 'test' AS c, b FROM T) t GROUP BY a, c\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testColumnIntervalValidation() {
        this.util().verifyExecPlan("SELECT b, SUM(a) FROM MyTable WHERE a > 0.1 and a < 10 GROUP BY b");
    }

    @Test
    public void testFilteredColumnIntervalValidation() {
        this.util().verifyExecPlan(new StringOps(Predef$.MODULE$.augmentString("\n                           |SELECT\n                           |  SUM(uv) FILTER (WHERE c = 'all') AS all_uv\n                           |FROM (\n                           |  SELECT\n                           |    c, COUNT(1) AS uv\n                           |  FROM T\n                           |  GROUP BY c\n                           |) t\n                           |")).stripMargin());
    }

    @Test
    public void testGroupKeyNotMatchSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE sink (\n                               | id VARCHAR,\n                               | cnt BIGINT,\n                               | PRIMARY KEY (cnt) NOT ENFORCED\n                               |) WITH (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO sink\n        |SELECT c, COUNT(*) cnt FROM T GROUP BY c\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testGroupKeyInSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE sink (\n                               | a INT,\n                               | b BIGINT,\n                               | cnt BIGINT,\n                               | PRIMARY KEY (a, b) NOT ENFORCED\n                               |) WITH (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO sink\n        |SELECT a, MAX(b) b, COUNT(*) cnt FROM T GROUP BY a\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testGroupResultLostUpsertKeyWithSinkPk() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE sink (\n                               | id VARCHAR,\n                               | cnt BIGINT,\n                               | PRIMARY KEY (id) NOT ENFORCED\n                               |) WITH (\n                               | 'connector' = 'values'\n                               | ,'sink-insert-only' = 'false'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExplainInsert(new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO sink\n        |SELECT c, COUNT(*) cnt FROM T GROUP BY a, c\n        |")).stripMargin(), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test(expected=TableException.class)
    public void testApproximateCountDistinct() {
        this.util().verifyExecPlan("SELECT APPROX_COUNT_DISTINCT(b) FROM MyTable");
    }

    @Test
    public void testCountStart() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | id VARCHAR,\n                               | cnt BIGINT\n                               |) WITH (\n                               | 'connector' = 'values'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT COUNT(*) FROM src");
    }

    @Test
    public void testCountStartWithMetadata() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | sys_col VARCHAR METADATA,\n                               | id VARCHAR,\n                               | cnt BIGINT\n                               |) WITH (\n                               | 'connector' = 'values',\n                               | 'readable-metadata' = 'sys_col:STRING'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT COUNT(*) FROM src");
    }

    @Test
    public void testCountStartWithMetadataOnly() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | sys_col VARCHAR METADATA,\n                               | id VARCHAR METADATA,\n                               | cnt BIGINT METADATA\n                               |) WITH (\n                               | 'connector' = 'values',\n                               | 'readable-metadata' = 'sys_col:STRING,id:STRING,cnt:BIGINT'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT COUNT(*) FROM src");
    }

    @Test
    public void testCountStartWithNestedRow() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | nested row<name string, `value` int>,\n                               | sys_col VARCHAR METADATA,\n                               | id VARCHAR,\n                               | cnt BIGINT\n                               |) WITH (\n                               | 'connector' = 'values',\n                               | 'readable-metadata' = 'sys_col:STRING'\n                               |)\n                               |")).stripMargin());
        this.util().verifyExecPlan("SELECT COUNT(*) FROM src");
    }

    public AggregateTest() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "proctime")).proctime(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "rowtime")).rowtime()}), new CaseClassTypeInfo<Tuple3<Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, String, Object>>(this, fieldSerializers){

                    public Tuple3<Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("T2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.stream.sql.agg.AggregateTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable1", (TypeInformation[])((Object[])new TypeInformation[]{Types.BYTE(), Types.SHORT(), Types.INT(), Types.LONG(), Types.FLOAT(), Types.DOUBLE(), Types.BOOLEAN(), Types.STRING(), Types.LOCAL_DATE(), Types.LOCAL_TIME(), Types.LOCAL_DATE_TIME(), DecimalDataTypeInfo.of((int)30, (int)20), DecimalDataTypeInfo.of((int)10, (int)5)}), (String[])((Object[])new String[]{"byte", "short", "int", "long", "float", "double", "boolean", "string", "date", "time", "timestamp", "decimal3020", "decimal105"}));
    }
}

