/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.rules.physical.stream.IncrementalAggregateRule$;
import org.apache.flink.table.planner.plan.stream.sql.agg.DistinctAggregateTest$;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u0001U\u0011Q\u0003R5ti&t7\r^!hOJ,w-\u0019;f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011mZ4\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0007gR\u0014X-Y7\u000b\u0005%Q\u0011\u0001\u00029mC:T!a\u0003\u0007\u0002\u000fAd\u0017M\u001c8fe*\u0011QBD\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001fA\tQA\u001a7j].T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\"$D\u0001\u0019\u0015\tI\"\"A\u0003vi&d7/\u0003\u0002\u001c1\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016D\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0018gBd\u0017\u000e\u001e#jgRLgn\u0019;BO\u001e,e.\u00192mK\u0012\u0004\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0003A\twm\u001a)iCN,WI\u001c4pe\u000e,'\u000f\u0005\u0002\u0018O%\u0011\u0001\u0006\u0007\u0002\u0017\u0003\u001e<'/Z4bi\u0016\u0004\u0006.Y:f'R\u0014\u0018\r^3hs\")!\u0006\u0001C\u0001W\u00051A(\u001b8jiz\"2\u0001\f\u00180!\ti\u0003!D\u0001\u0003\u0011\u0015i\u0012\u00061\u0001\u001f\u0011\u0015)\u0013\u00061\u0001'\u0011\u001d\t\u0004A1A\u0005\u0012I\nA!\u001e;jYV\t1\u0007\u0005\u0002\u0018i%\u0011Q\u0007\u0007\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007o\u0001\u0001\u000b\u0011B\u001a\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000be\u0002A\u0011\u0001\u001e\u0002\r\t,gm\u001c:f)\u0005Y\u0004CA\u0010=\u0013\ti\u0004E\u0001\u0003V]&$\bF\u0001\u001d@!\t\u00015)D\u0001B\u0015\t\u0011%#A\u0003kk:LG/\u0003\u0002E\u0003\n1!)\u001a4pe\u0016DQA\u0012\u0001\u0005\u0002i\nQ\u0003^3tiNKgn\u001a7f\t&\u001cH/\u001b8di\u0006;w\r\u000b\u0002F\u0011B\u0011\u0001)S\u0005\u0003\u0015\u0006\u0013A\u0001V3ti\")A\n\u0001C\u0001u\u0005)B/Z:u\u001bVdG/\u001b#jgRLgn\u0019;BO\u001e\u001c\bFA&I\u0011\u0015y\u0005\u0001\"\u0001;\u0003q!Xm\u001d;TS:<G.Z'bq^KG\u000f\u001b#jgRLgn\u0019;BO\u001eD#A\u0014%\t\u000bI\u0003A\u0011\u0001\u001e\u0002GQ,7\u000f^*j]\u001edWMR5sgR4\u0016\r\\;f/&$\b\u000eR5ti&t7\r^!hO\"\u0012\u0011\u000b\u0013\u0005\u0006+\u0002!\tAO\u0001#i\u0016\u001cHoU5oO2,G*Y:u-\u0006dW/Z,ji\"$\u0015n\u001d;j]\u000e$\u0018iZ4)\u0005QC\u0005\"\u0002-\u0001\t\u0003Q\u0014\u0001\t;fgR\u001c\u0016N\\4mK2K7\u000f^!hO^KG\u000f\u001b#jgRLgn\u0019;BO\u001eD#a\u0016%\t\u000bm\u0003A\u0011\u0001\u001e\u0002UQ,7\u000f^*j]\u001edW\rR5ti&t7\r^!hO^KG\u000f[!mY:{g\u000eR5ti&t7\r^!hO\"\u0012!\f\u0013\u0005\u0006=\u0002!\tAO\u0001+i\u0016\u001cH\u000fV<p\t&\u001cH/\u001b8di\u0006;wM]3hCR,w+\u001b;i\u001d>tG)[:uS:\u001cG/Q4hQ\ti\u0006\nC\u0003b\u0001\u0011\u0005!(\u0001\u0011uKN$8+\u001b8hY\u0016$\u0015n\u001d;j]\u000e$\u0018iZ4XSRDwI]8va\nK\bF\u00011I\u0011\u0015!\u0007\u0001\"\u0001;\u0003Y\"Xm\u001d;TS:<G.\u001a#jgRLgn\u0019;BO\u001e<\u0016\u000e\u001e5B]\u0012tuN\u001c#jgRLgn\u0019;BO\u001e|enU1nK\u000e{G.^7oQ\t\u0019\u0007\nC\u0003h\u0001\u0011\u0005!(\u0001\u0016uKN$8k\\7f\u0007>dW/\u001c8t\u0005>$\b.\u00138ESN$\u0018N\\2u\u0003\u001e<\u0017I\u001c3He>,\bOQ=)\u0005\u0019D\u0005\"\u00026\u0001\t\u0003Q\u0014a\u0006;fgR\fumZ,ji\"4\u0015\u000e\u001c;fe\u000ec\u0017-^:fQ\tI\u0007\nC\u0003n\u0001\u0011\u0005!(A\tuKN$X*\u001e7uS\u001e\u0013x.\u001e9CsND#\u0001\u001c%\t\u000bA\u0004A\u0011\u0001\u001e\u0002AQ,7\u000f^*j]\u001edW\rR5ti&t7\r^,ji\"\u0014V\r\u001e:bGRLwN\u001c\u0015\u0003_\"CQa\u001d\u0001\u0005\u0002i\n1\u0006^3tiN+XnQ8v]R<\u0016\u000e\u001e5TS:<G.\u001a#jgRLgn\u0019;B]\u0012\u0014V\r\u001e:bGRLwN\u001c\u0015\u0003e\"CQA\u001e\u0001\u0005\u0002i\n\u0001\u0004^3ti6Kg.T1y/&$\bNU3ue\u0006\u001cG/[8oQ\t)\b\nC\u0003z\u0001\u0011\u0005!(A\u0013uKN$h)\u001b:tiZ\u000bG.^3MCN$h+\u00197vK^KG\u000f\u001b*fiJ\f7\r^5p]\"\u0012\u0001\u0010\u0013\u0015\u0007\u0001q\f)!a\u0002\u0011\u0007u\f\t!D\u0001\u007f\u0015\ty\u0018)\u0001\u0004sk:tWM]\u0005\u0004\u0003\u0007q(a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f\t\u0015a\u0002:v]:,'o]\u0005\u0005\u0003'\tiAA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0004\b\u0003/\u0011\u0001\u0012AA\r\u0003U!\u0015n\u001d;j]\u000e$\u0018iZ4sK\u001e\fG/\u001a+fgR\u00042!LA\u000e\r\u0019\t!\u0001#\u0001\u0002\u001eM!\u00111DA\u0010!\ry\u0012\u0011E\u0005\u0004\u0003G\u0001#AB!osJ+g\rC\u0004+\u00037!\t!a\n\u0015\u0005\u0005e\u0001\u0002CA\u0016\u00037!\t!!\f\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u00020A1\u0011\u0011GA\u001d\u0003{i!!a\r\u000b\u0007E\n)D\u0003\u0002\u00028\u0005!!.\u0019<b\u0013\u0011\tY$a\r\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0003 \u0003\u007f\t\u0019%C\u0002\u0002B\u0001\u0012Q!\u0011:sCf\u00042aHA#\u0013\r\t9\u0005\t\u0002\u0004\u0003:L\b\u0006CA\u0015\u0003\u0017\nI&a\u0017\u0011\t\u00055\u00131\u000b\b\u0005\u0003\u0017\ty%\u0003\u0003\u0002R\u00055\u0011!\u0004)be\u0006lW\r^3sSj,G-\u0003\u0003\u0002V\u0005]#A\u0003)be\u0006lW\r^3sg*!\u0011\u0011KA\u0007\u0003\u0011q\u0017-\\3\"\u0005\u0005u\u0013!M:qY&$H)[:uS:\u001cG/Q4h\u000b:\f'\r\\3e{m\u0004T\u0010\f\u0011bO\u001e\u0004\u0006.Y:f\u000b:4wN]2fevZ\u0018' ")
public class DistinctAggregateTest
extends TableTestBase {
    private final boolean splitDistinctAggEnabled;
    private final AggregatePhaseStrategy aggPhaseEnforcer;
    private final StreamTableTestUtil util;

    @Parameterized.Parameters(name="splitDistinctAggEnabled={0}, aggPhaseEnforcer={1}")
    public static Collection<Object[]> parameters() {
        return DistinctAggregateTest$.MODULE$.parameters();
    }

    public StreamTableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        this.util().tableEnv().getConfig().setIdleStateRetentionTime(Time.hours((long)1L), Time.hours((long)2L));
        this.util().enableMiniBatch();
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)this.aggPhaseEnforcer.toString());
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_DISTINCT_AGG_SPLIT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)this.splitDistinctAggEnabled));
        this.util().tableEnv().getConfig().set(IncrementalAggregateRule$.MODULE$.TABLE_OPTIMIZER_INCREMENTAL_AGG_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Test
    public void testSingleDistinctAgg() {
        this.util().verifyExecPlan("SELECT COUNT(DISTINCT c) FROM MyTable");
    }

    @Test
    public void testMultiDistinctAggs() {
        this.util().verifyExecPlan("SELECT COUNT(DISTINCT a), SUM(DISTINCT b) FROM MyTable");
    }

    @Test
    public void testSingleMaxWithDistinctAgg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT b), MAX(c)\n        |FROM MyTable\n        |GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSingleFirstValueWithDistinctAgg() {
        this.util().verifyExecPlan("SELECT a, FIRST_VALUE(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleLastValueWithDistinctAgg() {
        this.util().verifyExecPlan("SELECT a, LAST_VALUE(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleListAggWithDistinctAgg() {
        this.util().verifyExecPlan("SELECT a, LISTAGG(c), COUNT(DISTINCT b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleDistinctAggWithAllNonDistinctAgg() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT c), SUM(b), AVG(b), MAX(b), MIN(b), COUNT(b), COUNT(*)\n        |FROM MyTable\n        |GROUP BY a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testTwoDistinctAggregateWithNonDistinctAgg() {
        this.util().verifyExecPlan("SELECT c, SUM(DISTINCT a), SUM(a), COUNT(DISTINCT b) FROM MyTable GROUP BY c");
    }

    @Test
    public void testSingleDistinctAggWithGroupBy() {
        this.util().verifyExecPlan("SELECT a, COUNT(DISTINCT c) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSingleDistinctAggWithAndNonDistinctAggOnSameColumn() {
        this.util().verifyExecPlan("SELECT a, COUNT(DISTINCT b), SUM(b), AVG(b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testSomeColumnsBothInDistinctAggAndGroupBy() {
        this.util().verifyExecPlan("SELECT a, COUNT(DISTINCT a), COUNT(b) FROM MyTable GROUP BY a");
    }

    @Test
    public void testAggWithFilterClause() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  a,\n         |  COUNT(DISTINCT b) FILTER (WHERE NOT b = 2),\n         |  SUM(b) FILTER (WHERE NOT b = 5),\n         |  SUM(b) FILTER (WHERE NOT b = 2)\n         |FROM MyTable\n         |GROUP BY a\n       ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testMultiGroupBys() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  c, MIN(b), MAX(b), SUM(b), COUNT(*), COUNT(DISTINCT a)\n         |FROM(\n         |  SELECT\n         |    a, AVG(b) as b, MAX(c) as c\n         |  FROM MyTable\n         |  GROUP BY a\n         |) GROUP BY c\n       ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSingleDistinctWithRetraction() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, COUNT(DISTINCT b), COUNT(1)\n        |FROM (\n        |  SELECT c, AVG(a) as a, AVG(b) as b\n        |  FROM MyTable\n        |  GROUP BY c\n        |) GROUP BY a\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testSumCountWithSingleDistinctAndRetraction() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  b, SUM(b1), COUNT(DISTINCT b1), COUNT(1)\n         |FROM(\n         |   SELECT\n         |     a, COUNT(b) as b, MAX(b) as b1\n         |   FROM MyTable\n         |   GROUP BY a\n         |) GROUP BY b\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testMinMaxWithRetraction() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  c, MIN(b), MAX(b), SUM(b), COUNT(*), COUNT(DISTINCT a)\n         |FROM(\n         |  SELECT\n         |    a, AVG(b) as b, MAX(c) as c\n         |  FROM MyTable\n         |  GROUP BY a\n         |) GROUP BY c\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    @Test
    public void testFirstValueLastValueWithRetraction() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT\n         |  b, FIRST_VALUE(c), LAST_VALUE(c), COUNT(DISTINCT c)\n         |FROM(\n         |  SELECT\n         |    a, COUNT(DISTINCT b) as b, MAX(b) as c\n         |  FROM MyTable\n         |  GROUP BY a\n         |) GROUP BY b\n       ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])new ExplainDetail[]{ExplainDetail.CHANGELOG_MODE}));
    }

    public DistinctAggregateTest(boolean splitDistinctAggEnabled, AggregatePhaseStrategy aggPhaseEnforcer) {
        this.splitDistinctAggEnabled = splitDistinctAggEnabled;
        this.aggPhaseEnforcer = aggPhaseEnforcer;
        this.util = this.streamTestUtil(this.streamTestUtil$default$1());
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.stream.sql.agg.DistinctAggregateTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

