/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.stream.sql.join;

import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001U\u0011abV5oI><(j\\5o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005!!n\\5o\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\rM$(/Z1n\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\u0011\u0011DC\u0001\u0006kRLGn]\u0005\u00037a\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0003\u0011\u001d\u0011\u0003A1A\u0005\n\r\nA!\u001e;jYV\tA\u0005\u0005\u0002\u0018K%\u0011a\u0005\u0007\u0002\u0014'R\u0014X-Y7UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007Q\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b)\u0002A\u0011A\u0016\u0002mQ,7\u000f^*j[Bd\u0017NZ=Uk6\u0014G.Z,j]\u0012|w\u000f\u0016,G\u0005\u00164wN]3XS:$wn\u001e&pS:<\u0016\u000e\u001e5Uo>\u001c\u0015\r\\2\u0015\u00031\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012A!\u00168ji\"\u0012\u0011f\r\t\u0003i]j\u0011!\u000e\u0006\u0003mI\tQA[;oSRL!\u0001O\u001b\u0003\tQ+7\u000f\u001e\u0005\u0006u\u0001!\taK\u00018i\u0016\u001cHoU5na2Lg-\u001f+v[\ndWmV5oI><HK\u0016$CK\u001a|'/Z,j]\u0012|wOS8j]^KG\u000f\u001b'fMR\u001c\u0015\r\\2)\u0005e\u001a\u0004\"B\u001f\u0001\t\u0003Y\u0013\u0001\u000f;fgR\u001c\u0016.\u001c9mS\u001aLH+^7cY\u0016<\u0016N\u001c3poR3fIQ3g_J,w+\u001b8e_^Tu.\u001b8XSRD'+[4ii\u000e\u000bGn\u0019\u0015\u0003yMBQ\u0001\u0011\u0001\u0005\u0002-\n1\u0006^3tiNKW\u000e\u001d7jMf$V/\u001c2mK^Kg\u000eZ8x)Z3%)\u001a4pe\u0016<\u0016N\u001c3po*{\u0017N\u001c\u0015\u0003\u007fMBQa\u0011\u0001\u0005\u0002-\n\u0011\u0006^3tiVs7/\u001e9q_J$X\rZ,j]\u0012|w\u000f\u0016,G?R+XN\u00197f\u001f:\u0004&o\\2uS6,\u0007F\u0001\"4\u0011\u00151\u0005\u0001\"\u0001,\u0003M\"Xm\u001d;TS6\u0004H.\u001b4z\u0011>\u0004x+\u001b8e_^$fK\u0012\"fM>\u0014XmV5oI><(j\\5o/&$\b\u000eV<p\u0007\u0006d7\r\u000b\u0002Fg!)\u0011\n\u0001C\u0001W\u0005!D/Z:u'&l\u0007\u000f\\5gs\"{\u0007oV5oI><HK\u0016$CK\u001a|'/Z,j]\u0012|wOS8j]^KG\u000f\u001b'fMR\u001c\u0015\r\\2)\u0005!\u001b\u0004\"\u0002'\u0001\t\u0003Y\u0013!\u000e;fgR\u001c\u0016.\u001c9mS\u001aL\bj\u001c9XS:$wn\u001e+W\r\n+gm\u001c:f/&tGm\\<K_&tw+\u001b;i%&<\u0007\u000e^\"bY\u000eD#aS\u001a\t\u000b=\u0003A\u0011A\u0016\u0002QQ,7\u000f^*j[Bd\u0017NZ=I_B<\u0016N\u001c3poR3fIQ3g_J,w+\u001b8e_^Tu.\u001b8)\u00059\u001b\u0004\"\u0002*\u0001\t\u0003Y\u0013A\n;fgR,fn];qa>\u0014H/\u001a3XS:$wn\u001e+W\r~Cu\u000e](o!J|7\r^5nK\"\u0012\u0011k\r\u0005\u0006+\u0002!\taK\u00019i\u0016\u001cHoU5na2Lg-_\"v[Vd\u0017\r^3XS:$wn\u001e+W\r\n+gm\u001c:f/&tGm\\<K_&tw+\u001b;i)^|7)\u00197dQ\t!6\u0007C\u0003Y\u0001\u0011\u00051&A\u001duKN$8+[7qY&4\u0017pQ;nk2\fG/Z,j]\u0012|w\u000f\u0016,G\u0005\u00164wN]3XS:$wn\u001e&pS:<\u0016\u000e\u001e5MK\u001a$8)\u00197dQ\t96\u0007C\u0003\\\u0001\u0011\u00051&\u0001\u001euKN$8+[7qY&4\u0017pQ;nk2\fG/Z,j]\u0012|w\u000f\u0016,G\u0005\u00164wN]3XS:$wn\u001e&pS:<\u0016\u000e\u001e5SS\u001eDGoQ1mG\"\u0012!l\r\u0005\u0006=\u0002!\taK\u0001.i\u0016\u001cHoU5na2Lg-_\"v[Vd\u0017\r^3XS:$wn\u001e+W\r\n+gm\u001c:f/&tGm\\<K_&t\u0007FA/4\u0011\u0015\t\u0007\u0001\"\u0001,\u0003-\"Xm\u001d;V]N,\b\u000f]8si\u0016$w+\u001b8e_^$fKR0Dk6,H.\u0019;f\u001f:\u0004&o\\2uS6,\u0007F\u000114\u0011\u0015!\u0007\u0001\"\u0001,\u0003U!Xm\u001d;O_R\u001c\u0016-\\3XS:$wn\u001e+za\u0016D#aY\u001a\t\u000b\u001d\u0004A\u0011A\u0016\u0002+Q,7\u000f\u001e(piN\u000bW.Z,j]\u0012|wo\u00159fG\"\u0012am\r\u0005\u0006U\u0002!\taK\u0001\u001di\u0016\u001cHOT8u'\u0006lW\rV5nK\u0006#HO]5ckR,G+\u001f9fQ\tI7\u0007C\u0003n\u0001\u0011\u00051&A\u0016uKN$X*[:t/&tGm\\<F]\u0012LenQ8oI&$\u0018n\u001c8G_J$V/\u001c2mK^Kg\u000eZ8xQ\ta7\u0007C\u0003q\u0001\u0011\u00051&A\u0017uKN$X*[:t/&tGm\\<Ti\u0006\u0014H/\u00138D_:$\u0017\u000e^5p]\u001a{'\u000fV;nE2,w+\u001b8e_^D#a\\\u001a\t\u000bM\u0004A\u0011A\u0016\u0002QQ,7\u000f^'jgN<\u0016N\u001c3po\u0016sG-\u00138D_:$\u0017\u000e^5p]\u001a{'\u000fS8q/&tGm\\<)\u0005I\u001c\u0004\"\u0002<\u0001\t\u0003Y\u0013A\u000b;fgRl\u0015n]:XS:$wn^*uCJ$\u0018J\\\"p]\u0012LG/[8o\r>\u0014\bj\u001c9XS:$wn\u001e\u0015\u0003kNBQ!\u001f\u0001\u0005\u0002-\nQ\u0006^3ti6K7o],j]\u0012|w/\u00128e\u0013:\u001cuN\u001c3ji&|gNR8s\u0007VlW\u000f\\1uK^Kg\u000eZ8xQ\tA8\u0007C\u0003}\u0001\u0011\u00051&A\u0018uKN$X*[:t/&tGm\\<Ti\u0006\u0014H/\u00138D_:$\u0017\u000e^5p]\u001a{'oQ;nk2\fG/Z,j]\u0012|w\u000f\u000b\u0002|g!)q\u0010\u0001C\u0001W\u0005YB/Z:u\u001f:$V/\u001c2mK^Kg\u000eZ8x\u0003\u001e<'/Z4bi\u0016D#A`\u001a\t\r\u0005\u0015\u0001\u0001\"\u0001,\u0003\u0015\"Xm\u001d;P]R+XN\u00197f/&tGm\\<BO\u001e\u0014XmZ1uK>s\u0007K]8di&lW\rK\u0002\u0002\u0004MBa!a\u0003\u0001\t\u0003Y\u0013\u0001\u0007;fgR|e\u000eS8q/&tGm\\<BO\u001e\u0014XmZ1uK\"\u001a\u0011\u0011B\u001a\t\r\u0005E\u0001\u0001\"\u0001,\u0003\t\"Xm\u001d;P]\"{\u0007oV5oI><\u0018iZ4sK\u001e\fG/Z(o!J|7\r^5nK\"\u001a\u0011qB\u001a\t\r\u0005]\u0001\u0001\"\u0001,\u0003u!Xm\u001d;P]\u000e+X.\u001e7bi\u0016<\u0016N\u001c3po\u0006;wM]3hCR,\u0007fAA\u000bg!1\u0011Q\u0004\u0001\u0005\u0002-\nq\u0005^3ti>s7)^7vY\u0006$XmV5oI><\u0018iZ4sK\u001e\fG/Z(o!J|7\r^5nK\"\u001a\u00111D\u001a\t\r\u0005\r\u0002\u0001\"\u0001,\u0003e!Xm\u001d;XS:$wn\u001e&pS:<\u0016\u000e\u001e5O_:,\u0015/^5)\u0007\u0005\u00052\u0007\u0003\u0004\u0002*\u0001!\taK\u0001(i\u0016\u001cH\u000fV5nK\u0006#HO]5ckR,\u0007K]8qC\u001e\fG/\u001a$pe^Kg\u000eZ8x\u0015>Lg\u000eK\u0002\u0002(MBa!a\f\u0001\t\u0003Y\u0013\u0001\u000b;fgR$\u0016.\\3BiR\u0014\u0018NY;uKB\u0013x\u000e]1hCR,gi\u001c:XS:$wn\u001e&pS:\f\u0004fAA\u0017g!1\u0011Q\u0007\u0001\u0005\u0002-\n\u0001\u0006^3ti^Kg\u000eZ8x!J|\u0007/\u001a:usB\u0013x\u000e]1hCR,gi\u001c:XS:$wn\u001e&pS:D3!a\r4\u0011\u0019\tY\u0004\u0001C\u0001W\u0005qA/Z:u'\u0016l\u0017NS8j]&s\u0005fAA\u001dg!1\u0011\u0011\t\u0001\u0005\u0002-\nQ\u0002^3tiN+W.[#ySN$\bfAA g!1\u0011q\t\u0001\u0005\u0002-\n\u0011\u0003^3ti\u0006sG/\u001b&pS:tu\u000e^%OQ\r\t)e\r\u0005\u0007\u0003\u001b\u0002A\u0011A\u0016\u0002)Q,7\u000f^!oi&Tu.\u001b8O_R,\u00050[:uQ\r\tYe\r\u0005\u0007\u0003'\u0002A\u0011A\u0016\u0002;Q,7\u000f\u001e&pS:<\u0016\u000e\u001e5Jg:{G\u000fR5ti&t7\r\u001e$s_6D3!!\u00154\u0001")
public class WindowJoinTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(this.streamTestUtil$default$1());

    private StreamTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testSimplifyTumbleWindowTVFBeforeWindowJoinWithTwoCalc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  WHERE c > 10\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  WHERE c > 10\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSimplifyTumbleWindowTVFBeforeWindowJoinWithLeftCalc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  WHERE c > 10\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSimplifyTumbleWindowTVFBeforeWindowJoinWithRightCalc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  WHERE c > 10\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSimplifyTumbleWindowTVFBeforeWindowJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testUnsupportedWindowTVF_TumbleOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.a, L.b, L.c, R.a, R.b, R.c\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.thrown().expectMessage("Processing time Window Join is not supported yet.");
        this.thrown().expect(TableException.class);
        this.util().verifyExplain(sql);
    }

    @Test
    public void testSimplifyHopWindowTVFBeforeWindowJoinWithTwoCalc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  WHERE c > 10\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  WHERE c > 10\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSimplifyHopWindowTVFBeforeWindowJoinWithLeftCalc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  WHERE c > 10\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSimplifyHopWindowTVFBeforeWindowJoinWithRightCalc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  WHERE c > 10\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSimplifyHopWindowTVFBeforeWindowJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testUnsupportedWindowTVF_HopOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.a, L.b, L.c, R.a, R.b, R.c\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.thrown().expectMessage("Processing time Window Join is not supported yet.");
        this.thrown().expect(TableException.class);
        this.util().verifyExplain(sql);
    }

    @Test
    public void testSimplifyCumulateWindowTVFBeforeWindowJoinWithTwoCalc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  WHERE c > 10\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  WHERE c > 10\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSimplifyCumulateWindowTVFBeforeWindowJoinWithLeftCalc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  WHERE c > 10\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSimplifyCumulateWindowTVFBeforeWindowJoinWithRightCalc() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  WHERE c > 10\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSimplifyCumulateWindowTVFBeforeWindowJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT *\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testUnsupportedWindowTVF_CumulateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.a, L.b, L.c, R.a, R.b, R.c\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.thrown().expectMessage("Processing time Window Join is not supported yet.");
        this.thrown().expect(TableException.class);
        this.util().verifyExplain(sql);
    }

    @Test
    public void testNotSameWindowType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testNotSameWindowSpec() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '2' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  CUMULATE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testNotSameTimeAttributeType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testMissWindowEndInConditionForTumbleWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testMissWindowStartInConditionForTumbleWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testMissWindowEndInConditionForHopWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testMissWindowStartInConditionForHopWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testMissWindowEndInConditionForCumulateWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testMissWindowStartInConditionForCumulateWindow() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnTumbleWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnTumbleWindowAggregateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnHopWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnHopWindowAggregateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |  HOP(TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '5' MINUTE, INTERVAL '10' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnCumulateWindowAggregate() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testOnCumulateWindowAggregateOnProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testWindowJoinWithNonEqui() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(proctime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a AND\n        | CAST(L.window_start AS BIGINT) > R.uv\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTimeAttributePropagateForWindowJoin() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyTable3 (\n                                |  a INT,\n                                |  b STRING NOT NULL,\n                                |  c BIGINT,\n                                |  rowtime TIMESTAMP(3),\n                                |  proctime as PROCTIME(),\n                                |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                                |) with (\n                                |  'connector' = 'values'\n                                |)\n                                |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp AS\n        |SELECT\n        |  L.window_time as rowtime,\n        |  L.a as a,\n        |  L.b as l_b,\n        |  L.c as l_c,\n        |  R.b as r_b,\n        |  R.c as r_c\n        |FROM (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |) L\n        |JOIN (\n        |  SELECT *\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT tmp.*, MyTable3.* FROM tmp JOIN MyTable3 ON\n        | tmp.a = MyTable3.a AND\n        | tmp.rowtime BETWEEN\n        |   MyTable3.rowtime - INTERVAL '10' SECOND AND\n        |   MyTable3.rowtime + INTERVAL '1' HOUR\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testTimeAttributePropagateForWindowJoin1() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyTable4 (\n                                |  a INT,\n                                |  b STRING NOT NULL,\n                                |  c BIGINT,\n                                |  rowtime TIMESTAMP(3),\n                                |  proctime as PROCTIME(),\n                                |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                                |) with (\n                                |  'connector' = 'values'\n                                |)\n                                |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp1 AS\n        |SELECT\n        |  L.window_time as rowtime,\n        |  L.a,\n        |  L.cnt as l_cnt,\n        |  L.uv as l_uv,\n        |  R.cnt as r_cnt,\n        |  R.uv as r_uv\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT tmp1.*, MyTable4.* FROM tmp1 JOIN MyTable4 ON\n        | tmp1.a = MyTable4.a AND\n        | tmp1.rowtime BETWEEN\n        |   MyTable4.rowtime - INTERVAL '10' SECOND AND\n        |   MyTable4.rowtime + INTERVAL '1' HOUR\n        |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testWindowPropertyPropagateForWindowJoin() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE VIEW tmp2 AS\n        |SELECT\n        |  L.window_start as window_start,\n        |  L.window_end as window_end,\n        |  L.a,\n        |  L.cnt as l_cnt,\n        |  L.uv as l_uv,\n        |  R.cnt as r_cnt,\n        |  R.uv as r_uv\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(\n        |    CUMULATE(\n        |      TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '10' MINUTE, INTERVAL '1' HOUR))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a\n      ")).stripMargin());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |(\n        |  SELECT *,\n        |    ROW_NUMBER() OVER(\n        |      PARTITION BY window_start, window_end ORDER BY l_cnt DESC) as rownum\n        |  FROM tmp2\n        |)\n        |WHERE rownum <= 3\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSemiJoinIN() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L WHERE L.a IN (\n        |SELECT a FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |WHERE L.window_start = R.window_start AND L.window_end = R.window_end)\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testSemiExist() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L WHERE EXISTS (\n        |SELECT * FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |WHERE L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a)\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testAntiJoinNotIN() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L WHERE L.a NOT IN (\n        |SELECT a FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |WHERE L.window_start = R.window_start AND L.window_end = R.window_end)\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testAntiJoinNotExist() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L WHERE NOT EXISTS (\n        |SELECT * FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |WHERE L.window_start = R.window_start AND L.window_end = R.window_end AND L.a = R.a)\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testJoinWithIsNotDistinctFrom() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT L.*, R.*\n        |FROM (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) L\n        |JOIN (\n        |  SELECT\n        |    a,\n        |    window_start,\n        |    window_end,\n        |    window_time,\n        |    count(*) as cnt,\n        |    count(distinct c) AS uv\n        |  FROM TABLE(TUMBLE(TABLE MyTable2, DESCRIPTOR(rowtime), INTERVAL '15' MINUTE))\n        |  GROUP BY a, window_start, window_end, window_time\n        |) R\n        |ON L.window_start = R.window_start AND L.window_end = R.window_end AND\n        |L.a IS NOT DISTINCT FROM R.a\n      ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    public WindowJoinTest() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |CREATE TABLE MyTable (\n                              |  a INT,\n                              |  b STRING NOT NULL,\n                              |  c BIGINT,\n                              |  rowtime TIMESTAMP(3),\n                              |  proctime as PROCTIME(),\n                              |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                              |) with (\n                              |  'connector' = 'values'\n                              |)\n                              |")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                              |CREATE TABLE MyTable2 (\n                              |  a INT,\n                              |  b STRING NOT NULL,\n                              |  c BIGINT,\n                              |  rowtime TIMESTAMP(3),\n                              |  proctime as PROCTIME(),\n                              |  WATERMARK FOR rowtime AS rowtime - INTERVAL '1' SECOND\n                              |) with (\n                              |  'connector' = 'values'\n                              |)\n                              |")).stripMargin());
    }
}

