/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ParallelismSettingTest
extends TableTestBase {
    private BatchTableTestUtil util;

    @Before
    public void before() {
        this.util = this.batchTestUtil(TableConfig.getDefault());
        this.util.getTableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)4);
        this.util.tableEnv().executeSql("CREATE TABLE MyTable (\n  a BIGINT,\n  b BIGINT,\n  c VARCHAR\n) WITH (\n  'connector' = 'filesystem',\n  'format' = 'testcsv',\n  'path' = '/tmp')");
    }

    @Test
    public void testParallelismSettingAfterSingletonShuffleRemove() {
        this.util.getTableEnv().executeSql("CREATE TABLE MySink (\n  b bigint\n) with (\n  'connector' = 'values',\n  'sink-insert-only' = 'false',\n  'table-sink-class' = 'DEFAULT')");
        Transformation<?> sink = this.generateTransformation("INSERT INTO MySink SELECT MAX(b) FROM (SELECT SUM(b) AS b FROM MyTable)");
        Transformation topAgg = (Transformation)sink.getInputs().get(0);
        Assertions.assertThat((int)topAgg.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)topAgg.getMaxParallelism()).isEqualTo(1);
        Transformation bottomAgg = (Transformation)topAgg.getInputs().get(0);
        Assertions.assertThat((int)bottomAgg.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)bottomAgg.getMaxParallelism()).isEqualTo(1);
    }

    @Test
    public void testSortQuery() {
        this.util.getTableEnv().executeSql("CREATE TABLE MySink (\n  a bigint,\n  b bigint,\n  c varchar\n) with (\n  'connector' = 'values',\n  'sink-insert-only' = 'false',\n  'table-sink-class' = 'DEFAULT')");
        Transformation<?> sink = this.generateTransformation("INSERT INTO MySink SELECT * FROM MyTable ORDER BY a");
        Transformation sort = (Transformation)sink.getInputs().get(0);
        Assertions.assertThat((int)sort.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)sort.getMaxParallelism()).isEqualTo(1);
        Transformation exchange = (Transformation)sort.getInputs().get(0);
        Assertions.assertThat((int)exchange.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)exchange.getMaxParallelism()).isEqualTo(1);
        Transformation source = (Transformation)exchange.getInputs().get(0);
        Assertions.assertThat((int)source.getParallelism()).isEqualTo(4);
        Assertions.assertThat((int)source.getMaxParallelism()).isEqualTo(-1);
    }

    @Test
    public void testLimitQuery() {
        this.util.getTableEnv().executeSql("CREATE TABLE MySink (\n  a bigint,\n  b bigint,\n  c varchar\n) with (\n  'connector' = 'values',\n  'sink-insert-only' = 'false',\n  'table-sink-class' = 'DEFAULT')");
        Transformation<?> sink = this.generateTransformation("INSERT INTO MySink SELECT * FROM MyTable LIMIT 5");
        Transformation topLimit = (Transformation)sink.getInputs().get(0);
        Assertions.assertThat((int)topLimit.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)topLimit.getMaxParallelism()).isEqualTo(1);
        Transformation exchange = (Transformation)topLimit.getInputs().get(0);
        Assertions.assertThat((int)exchange.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)exchange.getMaxParallelism()).isEqualTo(1);
        Transformation bottomLimit = (Transformation)exchange.getInputs().get(0);
        Assertions.assertThat((int)bottomLimit.getParallelism()).isEqualTo(4);
        Assertions.assertThat((int)bottomLimit.getMaxParallelism()).isEqualTo(-1);
    }

    @Test
    public void testSortLimitQuery() {
        this.util.getTableEnv().executeSql("CREATE TABLE MySink (\n  a bigint,\n  b bigint,\n  c varchar\n) with (\n  'connector' = 'values',\n  'sink-insert-only' = 'false',\n  'table-sink-class' = 'DEFAULT')");
        Transformation<?> sink = this.generateTransformation("INSERT INTO MySink SELECT * FROM MyTable ORDER BY a LIMIT 5");
        Transformation topSortLimit = (Transformation)sink.getInputs().get(0);
        Assertions.assertThat((int)topSortLimit.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)topSortLimit.getMaxParallelism()).isEqualTo(1);
        Transformation exchange = (Transformation)topSortLimit.getInputs().get(0);
        Assertions.assertThat((int)exchange.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)exchange.getMaxParallelism()).isEqualTo(1);
        Transformation bottomSortLimit = (Transformation)exchange.getInputs().get(0);
        Assertions.assertThat((int)bottomSortLimit.getParallelism()).isEqualTo(4);
        Assertions.assertThat((int)bottomSortLimit.getMaxParallelism()).isEqualTo(-1);
    }

    @Test
    public void testRankQuery() {
        this.util.getTableEnv().executeSql("CREATE TABLE MySink (\n  a bigint,\n  b bigint,\n  rk bigint\n) with (\n  'connector' = 'values',\n  'sink-insert-only' = 'false',\n  'table-sink-class' = 'DEFAULT')");
        Transformation<?> sink = this.generateTransformation("INSERT INTO MySink SELECT * FROM (SELECT a, b, RANK() OVER (ORDER BY a, c) rk FROM MyTable) t WHERE rk = 2");
        Transformation calc = (Transformation)sink.getInputs().get(0);
        Assertions.assertThat((int)calc.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)calc.getMaxParallelism()).isEqualTo(-1);
        Transformation topRank = (Transformation)calc.getInputs().get(0);
        Assertions.assertThat((int)topRank.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)topRank.getMaxParallelism()).isEqualTo(1);
        Transformation topSort = (Transformation)topRank.getInputs().get(0);
        Assertions.assertThat((int)topSort.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)topSort.getMaxParallelism()).isEqualTo(1);
        Transformation exchange = (Transformation)topSort.getInputs().get(0);
        Assertions.assertThat((int)exchange.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)exchange.getMaxParallelism()).isEqualTo(1);
        Transformation bottomRank = (Transformation)exchange.getInputs().get(0);
        Assertions.assertThat((int)bottomRank.getParallelism()).isEqualTo(4);
        Assertions.assertThat((int)bottomRank.getMaxParallelism()).isEqualTo(-1);
        Transformation bottomSort = (Transformation)bottomRank.getInputs().get(0);
        Assertions.assertThat((int)bottomSort.getParallelism()).isEqualTo(4);
        Assertions.assertThat((int)bottomSort.getMaxParallelism()).isEqualTo(-1);
    }

    @Test
    public void testJoinQuery() {
        this.util.tableEnv().executeSql("CREATE TABLE MyTable2 (\n  d BIGINT,\n  e BIGINT,\n  f VARCHAR\n) WITH (\n  'connector' = 'filesystem',\n  'format' = 'testcsv',\n  'path' = '/tmp')");
        this.util.getTableEnv().executeSql("CREATE TABLE MySink (\n  a bigint,\n  b bigint,\n  d bigint,\n  e bigint\n) with (\n  'connector' = 'values',\n  'sink-insert-only' = 'false',\n  'table-sink-class' = 'DEFAULT')");
        this.util.getTableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin, SortMergeJoin");
        Transformation<?> sink = this.generateTransformation("INSERT INTO MySink SELECT a, b, d, e FROM MyTable FULL JOIN MyTable2 on a = d");
        Transformation join = (Transformation)sink.getInputs().get(0);
        Assertions.assertThat((int)join.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)join.getMaxParallelism()).isEqualTo(1);
        Transformation leftExchange = (Transformation)join.getInputs().get(0);
        Assertions.assertThat((int)leftExchange.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)leftExchange.getMaxParallelism()).isEqualTo(1);
        Transformation leftCalc = (Transformation)leftExchange.getInputs().get(0);
        Assertions.assertThat((int)leftCalc.getParallelism()).isEqualTo(4);
        Assertions.assertThat((int)leftCalc.getMaxParallelism()).isEqualTo(-1);
        Transformation rightExchange = (Transformation)join.getInputs().get(1);
        Assertions.assertThat((int)rightExchange.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)rightExchange.getMaxParallelism()).isEqualTo(1);
        Transformation rightCalc = (Transformation)rightExchange.getInputs().get(0);
        Assertions.assertThat((int)rightCalc.getParallelism()).isEqualTo(4);
        Assertions.assertThat((int)rightCalc.getMaxParallelism()).isEqualTo(-1);
    }

    private Transformation<?> generateTransformation(String statement) {
        List operations = this.util.getPlanner().getParser().parse(statement);
        List transformations = this.util.getPlanner().translate(Collections.singletonList((ModifyOperation)operations.get(0)));
        Assertions.assertThat((List)transformations).hasSize(1);
        return (Transformation)transformations.get(0);
    }
}

