/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql;

import java.io.Serializable;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.runtime.batch.sql.MultipleInputITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0001\u0003\u0001M\u00111#T;mi&\u0004H.Z%oaV$\u0018\nV\"bg\u0016T!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0019\tQ!\u001e;jYNL!!\u0007\f\u0003\u001b\t\u000bGo\u00195UKN$()Y:f\u0011!Y\u0002A!A!\u0002\u0013a\u0012aC:ik\u001a4G.Z'pI\u0016\u0004\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\r\r|W.\\8o\u0015\t\tC\"A\u0002ba&L!a\t\u0010\u0003!\t\u000bGo\u00195TQV4g\r\\3N_\u0012,\u0007\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u001bM\u001c\u0007.\u001a3vY\u0016\u0014H+\u001f9f!\t9sG\u0004\u0002)i9\u0011\u0011F\r\b\u0003UEr!a\u000b\u0019\u000f\u00051zS\"A\u0017\u000b\u00059\u0012\u0012A\u0002\u001fs_>$h(C\u0001\u0012\u0013\ty\u0001#\u0003\u0002\u000e\u001d%\u00111\u0007D\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\u0005U2\u0014!\u0005&pE6\u000bg.Y4fe>\u0003H/[8og*\u00111\u0007D\u0005\u0003qe\u0012QbU2iK\u0012,H.\u001a:UsB,'BA\u001b7\u0011\u0015Y\u0004\u0001\"\u0001=\u0003\u0019a\u0014N\\5u}Q\u0019Qh\u0010!\u0011\u0005y\u0002Q\"\u0001\u0002\t\u000bmQ\u0004\u0019\u0001\u000f\t\u000b\u0015R\u0004\u0019\u0001\u0014\t\u000b\t\u0003A\u0011I\"\u0002\r\t,gm\u001c:f)\u0005!\u0005CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%\u0001B+oSRD#!Q&\u0011\u00051{U\"A'\u000b\u00059\u0003\u0012!\u00026v]&$\u0018B\u0001)N\u0005\u0019\u0011UMZ8sK\")!\u000b\u0001C\u0001\u0007\u00061B/Z:u\u0005\u0006\u001c\u0018nY'vYRL\u0007\u000f\\3J]B,H\u000f\u000b\u0002R)B\u0011A*V\u0005\u0003-6\u0013A\u0001V3ti\")\u0001\f\u0001C\u0001\u0007\u00061B/Z:u\u001b\u0006t\u00170T;mi&\u0004H.Z%oaV$8\u000f\u000b\u0002X)\")1\f\u0001C\u0001\u0007\u00061B/Z:u\u0015>LgnV5uQ\u0006;w-Q:Qe>\u0014W\r\u000b\u0002[)\")a\f\u0001C\u0001\u0007\u0006AB/Z:u\u001d>\u0004&/[8sSRL8i\u001c8tiJ\f\u0017N\u001c;)\u0005u#\u0006\"B1\u0001\t\u0003\u0019\u0015!\u0005;fgR\u0014V\r\\1uK\u0012Le\u000e];ug\"\u0012\u0001\r\u0016\u0005\u0006I\u0002!\taQ\u0001\u0019i\u0016\u001cHOU3mCR,G-\u00138qkR\u001cx+\u001b;i\u0003\u001e<\u0007FA2U\u0011\u00159\u0007\u0001\"\u0001D\u0003\u0019\"Xm\u001d;EK\u0006$Gn\\2l\u0007\u0006,8/\u001a3Cs\u0016C8\r[1oO\u0016Le.\u00118dKN$xN\u001d\u0015\u0003MRCQA\u001b\u0001\u0005\u0002\r\u000ba\u0003^3ti6\u000b\u0007pU;qa>\u0014H/\u001a3J]B,Ho\u001d\u0015\u0003SRCQ!\u001c\u0001\u0005\u00029\f\u0001d\u00195fG.lU\u000f\u001c;ja2,\u0017J\u001c9viJ+7/\u001e7u)\t!u\u000eC\u0003\u0004Y\u0002\u0007\u0001\u000f\u0005\u0002rk:\u0011!o\u001d\t\u0003Y\u0019K!\u0001\u001e$\u0002\rA\u0013X\rZ3g\u0013\t1xO\u0001\u0004TiJLgn\u001a\u0006\u0003i\u001aCS\u0001A=\u0000\u0003\u0003\u0001\"A_?\u000e\u0003mT!\u0001`'\u0002\rI,hN\\3s\u0013\tq8PA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%Q*A\u0004sk:tWM]:\n\t\u00055\u0011q\u0001\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000f\u0005E!\u0001#\u0001\u0002\u0014\u0005\u0019R*\u001e7uSBdW-\u00138qkRLEkQ1tKB\u0019a(!\u0006\u0007\r\u0005\u0011\u0001\u0012AA\f'\u0011\t)\"!\u0007\u0011\u0007\u0015\u000bY\"C\u0002\u0002\u001e\u0019\u0013a!\u00118z%\u00164\u0007bB\u001e\u0002\u0016\u0011\u0005\u0011\u0011\u0005\u000b\u0003\u0003'A\u0001\"!\n\u0002\u0016\u0011\u0005\u0011qE\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHCAA\u0015!\u0015)\u00151FA\u0018\u0013\r\tiC\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0006\u000b\u0006-\u0012\u0011\u0007\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0012\u0001\u00026bm\u0006LA!a\u0010\u00026\t1qJ\u00196fGRD\u0003\"a\t\u0002D\u0005e\u00131\f\t\u0005\u0003\u000b\n\u0019F\u0004\u0003\u0002H\u0005=c\u0002BA%\u0003\u001br1aKA&\u0013\tq\u0005#C\u0002\u0002\n5KA!!\u0015\u0002\b\u0005i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!!\u0016\u0002X\tQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\u0005E\u0013qA\u0001\u0005]\u0006lW-\t\u0002\u0002^\u0005!3\u000f[;gM2,Wj\u001c3fu\u0001Z\b' \u0017!g\u000eDW\rZ;mKJ$\u0016\u0010]3;Am\fT\u0010\u0003\u0005\u0002b\u0005UA\u0011AA2\u0003I9WM\\3sCR,'+\u00198e_6$\u0015\r^1\u0015\u0005\u0005\u0015\u0004CBA4\u0003c\n9H\u0004\u0003\u0002j\u00055db\u0001\u0017\u0002l%\tq)C\u0002\u0002p\u0019\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002t\u0005U$aA*fc*\u0019\u0011q\u000e$\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wR1!! \r\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\t)a\u001f\u0003\u0007I{w\u000fC\u0006\u0002\u0006\u0006U\u0001R1A\u0005\u0002\u0005\u001d\u0015a\u0002:poRK\b/Z\u000b\u0003\u0003\u0013\u0003B!a#\u0002\u00146\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*A\u0005usB,W\u000f^5mg*\u0019\u00111\b\u0011\n\t\u0005U\u0015Q\u0012\u0002\f%><H+\u001f9f\u0013:4w\u000eC\u0006\u0002\u001a\u0006U\u0001R1A\u0005\u0002\u0005m\u0015!\u00038vY2\f'\r\\3t+\t\ti\nE\u0003F\u0003W\ty\nE\u0002F\u0003CK1!a)G\u0005\u001d\u0011un\u001c7fC:D1\"a*\u0002\u0016!\u0015\r\u0011\"\u0001\u0002*\u0006)A-\u0019;b1V\u0011\u0011Q\r\u0005\f\u0003[\u000b)\u0002#b\u0001\n\u0003\tI+A\u0003eCR\f\u0017\fC\u0006\u00022\u0006U\u0001R1A\u0005\u0002\u0005%\u0016!\u00023bi\u0006T\u0006bCA[\u0003+A)\u0019!C\u0001\u0003S\u000bQ\u0001Z1uCR\u0003")
public class MultipleInputITCase
extends BatchTestBase {
    private final BatchShuffleMode shuffleMode;
    private final JobManagerOptions.SchedulerType schedulerType;

    public static Seq<Row> dataT() {
        return MultipleInputITCase$.MODULE$.dataT();
    }

    public static Seq<Row> dataZ() {
        return MultipleInputITCase$.MODULE$.dataZ();
    }

    public static Seq<Row> dataY() {
        return MultipleInputITCase$.MODULE$.dataY();
    }

    public static Seq<Row> dataX() {
        return MultipleInputITCase$.MODULE$.dataX();
    }

    public static boolean[] nullables() {
        return MultipleInputITCase$.MODULE$.nullables();
    }

    public static RowTypeInfo rowType() {
        return MultipleInputITCase$.MODULE$.rowType();
    }

    public static Seq<Row> generateRandomData() {
        return MultipleInputITCase$.MODULE$.generateRandomData();
    }

    @Parameterized.Parameters(name="shuffleMode: {0}, schedulerType: {1}")
    public static Object[][] parameters() {
        return MultipleInputITCase$.MODULE$.parameters();
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.registerCollection("x", MultipleInputITCase$.MODULE$.dataX(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nx", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("y", MultipleInputITCase$.MODULE$.dataY(), MultipleInputITCase$.MODULE$.rowType(), "d, e, f, ny", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("z", MultipleInputITCase$.MODULE$.dataZ(), MultipleInputITCase$.MODULE$.rowType(), "g, h, i, nz", MultipleInputITCase$.MODULE$.nullables());
        this.registerCollection("t", MultipleInputITCase$.MODULE$.dataT(), MultipleInputITCase$.MODULE$.rowType(), "a, b, c, nt", MultipleInputITCase$.MODULE$.nullables());
        this.tEnv().getConfig().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)this.shuffleMode);
        this.tEnv().getConfig().set(JobManagerOptions.SCHEDULER, (Object)this.schedulerType);
    }

    @Test
    public void testBasicMultipleInput() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n                               |SELECT * FROM\n                               |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n                               |  INNER JOIN\n                               |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n                               |  ON T1.a = T2.d\n                               |")).stripMargin());
    }

    @Test
    public void testManyMultipleInputs() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (\n        |    SELECT a, ny, nz FROM x\n        |      LEFT JOIN y ON x.a = y.ny\n        |      LEFT JOIN z ON x.a = z.nz),\n        |  T2 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN t ON T1.a = t.a\n        |      INNER JOIN y ON T1.a = y.d),\n        |  T3 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN y ON T1.a = y.d\n        |      INNER JOIN t ON T1.a = t.a),\n        |  T4 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T2 GROUP BY b),\n        |  T5 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T3 GROUP BY b)\n        |SELECT * FROM\n        |  (SELECT t.b, sd, sy, sz FROM T4 LEFT JOIN t ON T4.b = t.b)\n        |  UNION ALL\n        |  (SELECT y.e, sd, sy, sz FROM T5 LEFT JOIN y ON T5.b = y.e)\n        |")).stripMargin());
    }

    @Test
    public void testJoinWithAggAsProbe() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  LEFT JOIN\n        |  (SELECT d, SUM(a) AS sm FROM T GROUP BY d) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin());
    }

    @Test
    public void testNoPriorityConstraint() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  INNER JOIN y ON x.a = y.d\n        |  INNER JOIN t ON x.a = t.a\n        |")).stripMargin());
    }

    @Test
    public void testRelatedInputs() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT x.a AS a, x.b AS b FROM x))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin());
    }

    @Test
    public void testRelatedInputsWithAgg() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT COUNT(x.a) AS a, x.b AS b FROM x GROUP BY x.b))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin());
    }

    @Test
    public void testDeadlockCausedByExchangeInAncestor() {
        this.checkMultipleInputResult(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (\n        |  SELECT x1.*, x2.a AS k, (x1.b + x2.b) AS v\n        |  FROM x x1 LEFT JOIN x x2 ON x1.a = x2.a WHERE x2.a > 0)\n        |SELECT x.a, x.b, T1.* FROM x LEFT JOIN T1 ON x.a = T1.k WHERE x.a > 0 AND T1.v = 0\n        |")).stripMargin());
    }

    @Test
    public void testMaxSupportedInputs() {
        RowTypeInfo rowType = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "test"}))}));
        boolean[] nullables = new boolean[]{true, true};
        this.registerCollection("left_table", data, rowType, "a, b", nullables);
        this.registerCollection("right_table", data, rowType, "c, d", nullables);
        int numJoins = 62;
        scala.collection.mutable.StringBuilder sql = new scala.collection.mutable.StringBuilder("SELECT t0.a, t0.b");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).foreach((Function1 & Serializable & scala.Serializable)i -> sql.append(new StringBuilder(10).append(", t").append(BoxesRunTime.unboxToInt((Object)i)).append(".c, t").append(BoxesRunTime.unboxToInt((Object)i)).append(".d").toString()));
        sql.append(" from left_table as t0");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numJoins).foreach((Function1 & Serializable & scala.Serializable)i -> sql.append(new StringBuilder(53).append(" left join right_table as t").append(BoxesRunTime.unboxToInt((Object)i)).append(" on t0.a = t").append(BoxesRunTime.unboxToInt((Object)i)).append(".c and t").append(BoxesRunTime.unboxToInt((Object)i)).append(".c = 1").toString()));
        this.checkMultipleInputResult(sql.toString());
    }

    public void checkMultipleInputResult(String sql) {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        Seq<Row> expected = this.executeQuery(sql);
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.checkResult(sql, expected, this.checkResult$default$3());
    }

    public MultipleInputITCase(BatchShuffleMode shuffleMode, JobManagerOptions.SchedulerType schedulerType) {
        this.shuffleMode = shuffleMode;
        this.schedulerType = schedulerType;
    }
}

