/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.sql.agg;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;
import scala.collection.Seq;

public class LocalAggregatePushDownITCase
extends BatchTestBase {
    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.env().setParallelism(1);
        String testDataId = TestValuesTableFactory.registerData(TestData.personData());
        String ddl = "CREATE TABLE AggregatableTable (\n  id int,\n  age int,\n  name string,\n  height int,\n  gender string,\n  deposit bigint,\n  points bigint,\n  metadata_1 BIGINT METADATA,\n  metadata_2 STRING METADATA,\n  PRIMARY KEY (`id`) NOT ENFORCED\n) WITH (\n  'connector' = 'values',\n  'data-id' = '" + testDataId + "',\n  'filterable-fields' = 'id;age',\n  'readable-metadata' = 'metadata_1:BIGINT, metadata_2:STRING',\n  'bounded' = 'true'\n)";
        this.tEnv().executeSql(ddl);
        String ddl2 = "CREATE TABLE AggregatableTable_Part (\n  id int,\n  age int,\n  name string,\n  height int,\n  gender string,\n  deposit bigint,\n  points bigint,\n  distance BIGINT,\n  type STRING\n) PARTITIONED BY (type)\nWITH (\n  'connector' = 'values',\n  'data-id' = '" + testDataId + "',\n  'filterable-fields' = 'id;age',\n  'partition-list' = 'type:A;type:B;type:C;type:D',\n  'bounded' = 'true'\n)";
        this.tEnv().executeSql(ddl2);
        String ddl3 = "CREATE TABLE AggregatableTable_No_Proj (\n  id int,\n  age int,\n  name string,\n  height int,\n  gender string,\n  deposit bigint,\n  points bigint,\n  distance BIGINT,\n  type STRING\n)\nWITH (\n  'connector' = 'values',\n  'data-id' = '" + testDataId + "',\n  'filterable-fields' = 'id;age',\n  'enable-projection-push-down' = 'false',\n  'bounded' = 'true'\n)";
        this.tEnv().executeSql(ddl3);
    }

    @Test
    public void testPushDownLocalHashAggWithGroup() {
        this.checkResult("SELECT\n  avg(deposit) as avg_dep,\n  sum(deposit),\n  count(1),\n  gender\nFROM\n  AggregatableTable\nGROUP BY gender\nORDER BY avg_dep", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{126, 630, 5, "f"}), Row.of((Object[])new Object[]{220, 1320, 6, "m"}))), false);
    }

    @Test
    public void testDisablePushDownLocalAgg() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_SOURCE_AGGREGATE_PUSHDOWN_ENABLED, (Object)false);
        this.checkResult("SELECT\n  avg(deposit) as avg_dep,\n  sum(deposit),\n  count(1),\n  gender\nFROM\n  AggregatableTable\nGROUP BY gender\nORDER BY avg_dep", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{126, 630, 5, "f"}), Row.of((Object[])new Object[]{220, 1320, 6, "m"}))), false);
    }

    @Test
    public void testPushDownLocalHashAggWithoutGroup() {
        this.checkResult("SELECT\n  avg(deposit),\n  sum(deposit),\n  count(*)\nFROM\n  AggregatableTable", (Seq<Row>)JavaScalaConversionUtil.toScala(Collections.singletonList(Row.of((Object[])new Object[]{177, 1950, 11}))), false);
    }

    @Test
    public void testPushDownLocalSortAggWithoutSort() {
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        this.checkResult("SELECT\n  avg(deposit),\n  sum(deposit),\n  count(*)\nFROM\n  AggregatableTable", (Seq<Row>)JavaScalaConversionUtil.toScala(Collections.singletonList(Row.of((Object[])new Object[]{177, 1950, 11}))), false);
    }

    @Test
    public void testPushDownLocalSortAggWithSort() {
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashAgg");
        this.checkResult("SELECT\n  avg(deposit),\n  sum(deposit),\n  count(1),\n  gender,\n  age\nFROM\n  AggregatableTable\nGROUP BY gender, age", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{50, 50, 1, "f", 19}), Row.of((Object[])new Object[]{200, 200, 1, "f", 20}), Row.of((Object[])new Object[]{250, 750, 3, "m", 23}), Row.of((Object[])new Object[]{126, 380, 3, "f", 25}), Row.of((Object[])new Object[]{300, 300, 1, "m", 27}), Row.of((Object[])new Object[]{170, 170, 1, "m", 28}), Row.of((Object[])new Object[]{100, 100, 1, "m", 34}))), false);
    }

    @Test
    public void testPushDownLocalAggAfterFilterPushDown() {
        this.checkResult("SELECT\n  avg(deposit),\n  sum(deposit),\n  count(1),\n  gender,\n  age\nFROM\n  AggregatableTable\nWHERE age <= 20\nGROUP BY gender, age", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{50, 50, 1, "f", 19}), Row.of((Object[])new Object[]{200, 200, 1, "f", 20}))), false);
    }

    @Test
    public void testPushDownLocalAggWithMetadata() {
        this.checkResult("SELECT\n  sum(metadata_1),\n  metadata_2\nFROM\n  AggregatableTable\nGROUP BY metadata_2", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{156, Character.valueOf('C')}), Row.of((Object[])new Object[]{183, Character.valueOf('A')}), Row.of((Object[])new Object[]{51, Character.valueOf('D')}), Row.of((Object[])new Object[]{70, Character.valueOf('B')}))), false);
    }

    @Test
    public void testPushDownLocalAggWithPartition() {
        this.checkResult("SELECT\n  sum(deposit),\n  count(1),\n  type,\n  name\nFROM\n  AggregatableTable_Part\nWHERE type in ('A', 'C')GROUP BY type, name", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{150, 1, "C", "jack"}), Row.of((Object[])new Object[]{180, 1, "A", "emma"}), Row.of((Object[])new Object[]{200, 1, "A", "tom"}), Row.of((Object[])new Object[]{200, 1, "C", "eva"}), Row.of((Object[])new Object[]{300, 1, "C", "danny"}), Row.of((Object[])new Object[]{400, 1, "A", "tommas"}), Row.of((Object[])new Object[]{50, 1, "C", "olivia"}))), false);
    }

    @Test
    public void testPushDownLocalAggWithoutProjectionPushDown() {
        this.checkResult("SELECT\n  avg(deposit),\n  sum(deposit),\n  count(1),\n  gender,\n  age\nFROM\n  AggregatableTable_No_Proj\nWHERE age <= 20\nGROUP BY gender, age", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{50, 50, 1, "f", 19}), Row.of((Object[])new Object[]{200, 200, 1, "f", 20}))), false);
    }

    @Test
    public void testPushDownLocalAggWithoutAuxGrouping() {
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)"TWO_PHASE");
        this.checkResult("SELECT\n  id,\n  name,\n  count(*)\nFROM\n  AggregatableTable\nWHERE id > 8\nGROUP BY id, name", (Seq<Row>)JavaScalaConversionUtil.toScala(Arrays.asList(Row.of((Object[])new Object[]{9, "emma", 1}), Row.of((Object[])new Object[]{10, "benji", 1}), Row.of((Object[])new Object[]{11, "eva", 1}))), false);
    }
}

