/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.GroupedTable;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ImperativeAggregateFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$;
import org.apache.flink.table.planner.runtime.batch.table.Top10;
import org.apache.flink.table.planner.runtime.batch.table.WC;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.CollectionBatchExecTable$;
import org.apache.flink.table.planner.utils.CountAccumulator;
import org.apache.flink.table.planner.utils.CountAggFunction;
import org.apache.flink.table.planner.utils.NonMergableCount;
import org.apache.flink.table.planner.utils.NonMergableCountAcc;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.junit.Rule;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple7;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.MutableList;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001%\t\t\u0012iZ4sK\u001e\fG/[8o\u0013R\u001b\u0015m]3\u000b\u0005\r!\u0011!\u0002;bE2,'BA\u0003\u0007\u0003\u0015\u0011\u0017\r^2i\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0007-Q!\u0001D\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\r\u0005)Q\u000f^5mg&\u0011\u0001$\u0006\u0002\u000e\u0005\u0006$8\r\u001b+fgR\u0014\u0015m]3\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005\u0011\u0001\"B\u0010\u0001\t\u0003\u0001\u0013AD;tKNdUmZ1dsJ{wo]\u000b\u0002CA\u0011!\u0005J\u0007\u0002G)\u0011aCC\u0005\u0003K\r\u0012\u0011\u0003T3hC\u000eL(k\\<SKN|WO]2fQ\tqr\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+\u001f\u0005)!.\u001e8ji&\u0011A&\u000b\u0002\u0005%VdW\rC\u0003/\u0001\u0011\u0005q&\u0001\u000fuKN$\u0018iZ4sK\u001e\fG/[8o/&$\bnQ1tK\u000ec\u0017m]:\u0015\u0003A\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012A!\u00168ji\"\u0012Qf\u000e\t\u0003QaJ!!O\u0015\u0003\tQ+7\u000f\u001e\u0005\u0006w\u0001!\taL\u0001\u0015i\u0016\u001cH/Q4he\u0016<\u0017\r^5p]RK\b/Z:)\u0005i:\u0004\"\u0002 \u0001\t\u0003y\u0013a\b;fgR<vN]6j]\u001e\fum\u001a:fO\u0006$\u0018n\u001c8ECR\fG+\u001f9fg\"\u0012Qh\u000e\u0005\u0006\u0003\u0002!\taL\u0001\u000fi\u0016\u001cH\u000f\u0015:pU\u0016\u001cG/[8oQ\t\u0001u\u0007C\u0003E\u0001\u0011\u0005q&A\u000fuKN$\u0018iZ4sK\u001e\fG/[8o/&$\b.\u0011:ji\"lW\r^5dQ\t\u0019u\u0007C\u0003H\u0001\u0011\u0005q&A\u000euKN$\u0018iZ4sK\u001e\fG/[8o/&$\b\u000eV<p\u0007>,h\u000e\u001e\u0015\u0003\r^BQA\u0013\u0001\u0005\u0002=\na\u0004^3ti\u0006;wM]3hCRLwN\\!gi\u0016\u0014\bK]8kK\u000e$\u0018n\u001c8)\u0005%;\u0004\"B'\u0001\t\u0003y\u0013\u0001\u0007;fgR\u001c\u0016\u000bT*us2,\u0017iZ4sK\u001e\fG/[8og\"\u0012Aj\u000e\u0005\u0006!\u0002!\taL\u0001\u0014i\u0016\u001cH\u000fU8k_\u0006;wM]3hCRLwN\u001c\u0015\u0003\u001f^BQa\u0015\u0001\u0005\u0002=\nA\u0002^3ti\u0012K7\u000f^5oGRD#AU\u001c\t\u000bY\u0003A\u0011A\u0018\u00025Q,7\u000f\u001e#jgRLgn\u0019;BMR,'/Q4he\u0016<\u0017\r^3)\u0005U;\u0004\"B-\u0001\t\u0003y\u0013\u0001\u0006;fgR<%o\\;qK\u0012\fum\u001a:fO\u0006$X\r\u000b\u0002Yo!)A\f\u0001C\u0001_\u0005yB/Z:u\u000fJ|W\u000f]5oO.+\u0017PR8so\u0006\u0014H-\u00134O_R,6/\u001a3)\u0005m;\u0004\"B0\u0001\t\u0003y\u0013A\u0006;fgR<%o\\;q\u001d>\fum\u001a:fO\u0006$\u0018n\u001c8)\u0005y;\u0004\"\u00022\u0001\t\u0003y\u0013A\u0007;fgR\fum\u001a:fO\u0006$X-R7qif$\u0015\r^1TKR\u001c\bFA18\u0011\u0015)\u0007\u0001\"\u00010\u0003\u0001\"Xm\u001d;He>,\b/\u001a3BO\u001e\u0014XmZ1uK^KG\u000f\u001b'p]\u001e\\U-_:)\u0005\u0011<\u0004\"\u00025\u0001\t\u0003y\u0013!\t;fgR<%o\\;qK\u0012\fum\u001a:fO\u0006$XmV5uQ\u000e{gn\u001d;b]R\f\u0004FA48\u0011\u0015Y\u0007\u0001\"\u00010\u0003\u0005\"Xm\u001d;He>,\b/\u001a3BO\u001e\u0014XmZ1uK^KG\u000f[\"p]N$\u0018M\u001c;3Q\tQw\u0007C\u0003o\u0001\u0011\u0005q&\u0001\u0012uKN$xI]8va\u0016$\u0017iZ4sK\u001e\fG/Z,ji\",\u0005\u0010\u001d:fgNLwN\u001c\u0015\u0003[^BQ!\u001d\u0001\u0005\u0002=\na\u0004^3ti\u001e\u0013x.\u001e9fI\u0006;wM]3hCR,w+\u001b;i\r&dG/\u001a:)\u0005A<\u0004\"\u0002;\u0001\t\u0003y\u0013a\u0006;fgR\fe.\u00197zi&\u001c\u0017iZ4sK\u001e\fG/[8oQ\t\u0019x\u0007C\u0003x\u0001\u0011\u0005q&\u0001\u000buKN$8i\\7qY\u0016D\u0018iZ4sK\u001e\fG/\u001a\u0015\u0003m^BQA\u001f\u0001\u0005\u0002=\n1\u0002^3ti\u000e{G\u000e\\3di\"\u0012\u0011p\u000e")
public class AggregationITCase
extends BatchTestBase {
    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    @Test
    public void testAggregationWithCaseClass() {
        Table inputTable = CollectionBatchExecTable$.MODULE$.getSmallNestedTupleDataSet(this.tEnv(), "a, b");
        Table result = inputTable.where(package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).get("_1")).$greater(package$.MODULE$.int2Literal(0))).select(new Expression[]{(Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).get("_1")).avg(), (Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).get("_2")).sum(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).count()});
        String expected = "2,6,3";
        Seq<Row> results = this.executeQuery(result);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAggregationTypes() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), null).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).sum(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).sum0(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).min(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).max(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).count(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).avg()});
        Seq<Row> results = this.executeQuery(t);
        String expected = "231,231,1,21,21,11";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testWorkingAggregationDataTypes() {
        Table t = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple7[]{new Tuple7((Object)BoxesRunTime.boxToByte((byte)1), (Object)BoxesRunTime.boxToShort((short)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)"Hello"), new Tuple7((Object)BoxesRunTime.boxToByte((byte)2), (Object)BoxesRunTime.boxToShort((short)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)"Ciao")}), ClassTag$.MODULE$.apply(Tuple7.class), new CaseClassTypeInfo<Tuple7<Object, Object, Object, Object, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>>(this, fieldSerializers){

                    public Tuple7<Object, Object, Object, Object, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple7((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)((String)fields[6]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).avg(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).avg(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).avg(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_4")).avg(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_5")).avg(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_6")).avg(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_7")).count()});
        String expected = "1,1,1,1,1.5,1.5,2";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testProjection() {
        Table t = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)BoxesRunTime.boxToByte((byte)1), (Object)BoxesRunTime.boxToShort((short)1)), new scala.Tuple2((Object)BoxesRunTime.boxToByte((byte)2), (Object)BoxesRunTime.boxToShort((short)2))}), ClassTag$.MODULE$.apply(scala.Tuple2.class), new CaseClassTypeInfo<scala.Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, Object>>(this, fieldSerializers){

                    public scala.Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).avg(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).sum(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).count(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).avg(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).sum()});
        String expected = "1,3,2,1,3";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAggregationWithArithmetic() {
        Table t = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)"Hello"), new scala.Tuple2((Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)"Ciao")}), ClassTag$.MODULE$.apply(scala.Tuple2.class), new CaseClassTypeInfo<scala.Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, String>>(this, fieldSerializers){

                    public scala.Tuple2<Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).$plus(package$.MODULE$.int2Literal(2))).avg()).$plus(package$.MODULE$.int2Literal(2)), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).count()).$plus(package$.MODULE$.int2Literal(5))});
        String expected = "5.5,7";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAggregationWithTwoCount() {
        Table t = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new scala.Tuple2[]{new scala.Tuple2((Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)"Hello"), new scala.Tuple2((Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)"Ciao")}), ClassTag$.MODULE$.apply(scala.Tuple2.class), new CaseClassTypeInfo<scala.Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, String>>(this, fieldSerializers){

                    public scala.Tuple2<Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$$anon$17 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).count(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).count()});
        String expected = "2,2";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAggregationAfterProjection() {
        Table t = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple7[]{new Tuple7((Object)BoxesRunTime.boxToByte((byte)1), (Object)BoxesRunTime.boxToShort((short)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)"Hello"), new Tuple7((Object)BoxesRunTime.boxToByte((byte)2), (Object)BoxesRunTime.boxToShort((short)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)"Ciao")}), ClassTag$.MODULE$.apply(Tuple7.class), new CaseClassTypeInfo<Tuple7<Object, Object, Object, Object, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, String>>(this, fieldSerializers){

                    public Tuple7<Object, Object, Object, Object, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple7((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)((String)fields[6]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$$anon$18 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3"))}).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).avg(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).sum(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).count()});
        String expected = "1,3,2";
        Seq<Row> result = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(result).asJava()), (String)expected);
    }

    @Test
    public void testSQLStyleAggregations() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b ,c").select(new Expression[]{(Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).sum()).as("a1", new String[0]), (Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).min()).as("b1", new String[0]), (Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).max()).as("c1", new String[0]), (Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).avg()).as("d1", new String[0]), (Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).count()).as("e1", new String[0])});
        String expected = "231,1,21,11,21";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testPojoAggregation() {
        Table input;
        Table expr = input = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new WC[]{new WC("hello", 1L), new WC("hello", 1L), new WC("ciao", 1L), new WC("hola", 1L), new WC("hola", 1L)}), ClassTag$.MODULE$.apply(WC.class), new CaseClassTypeInfo<WC>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<WC> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<WC> unused = new ScalaCaseClassSerializer<WC>(this, fieldSerializers){

                    public WC createInstance(Object[] fields) {
                        return new WC((String)fields[0], BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$$anon$19 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Seq<Row> result = this.executeQuery(expr.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "word"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "word")), package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "frequency")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "frequency"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).filter(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "frequency")).$eq$eq$eq(package$.MODULE$.int2Literal(2))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "word")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "frequency")).$times(package$.MODULE$.int2Literal(10))}));
        Seq mappedResult = (Seq)result.map((Function1 & Serializable & scala.Serializable)row -> new scala.Tuple2(row.getField(0), row.getField(1)), Seq$.MODULE$.canBuildFrom());
        String expected = "(hello,20)\n(hola,20)";
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(mappedResult).asJava()), (String)expected);
    }

    @Test
    public void testDistinct() {
        Table ds = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c");
        Table distinct = ds.select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).distinct();
        String expected = "1\n2\n3\n4\n5\n6\n";
        Seq<Row> results = this.executeQuery(distinct);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testDistinctAfterAggregate() {
        Table ds = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "a, b, c, d, e");
        Table distinct = ds.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}).distinct();
        String expected = "1\n2\n3\n";
        Seq<Row> results = this.executeQuery(distinct);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupedAggregate() {
        CountAggFunction countFun = new CountAggFunction();
        JavaUserDefinedAggFunctions.WeightedAvgWithMergeAndReset wAvgFun = new JavaUserDefinedAggFunctions.WeightedAvgWithMergeAndReset();
        JavaUserDefinedAggFunctions.CountDistinctWithMergeAndReset countDistinct = new JavaUserDefinedAggFunctions.CountDistinctWithMergeAndReset();
        Expression[] expressionArray = new Expression[6];
        expressionArray[0] = package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"));
        expressionArray[1] = (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum();
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Long.class), (List)Nil$.MODULE$);
        Class<CountAccumulator> clazz = CountAccumulator.class;
        expressionArray[2] = package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)countFun, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), (TypeInformation)new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        expressionArray[3] = package$.MODULE$.call((UserDefinedFunction)wAvgFun, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        expressionArray[4] = package$.MODULE$.call((UserDefinedFunction)wAvgFun, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}));
        expressionArray[5] = package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)countDistinct, (TypeInformation)BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.CountDistinctAccum.class)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).select(expressionArray);
        String expected = "1,1,1,1,1,1\n2,5,2,2,2,2\n3,15,3,3,5,3\n4,34,4,4,8,4\n5,65,5,5,13,5\n6,111,6,6,18,6\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupingKeyForwardIfNotUsed() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()});
        String expected = "1\n5\n15\n34\n65\n111\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupNoAggregation() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).select(new Expression[]{package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))});
        String expected = "1\n2\n3\n4\n5\n6\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAggregateEmptyDataSets() {
        NonMergableCount myAgg = new NonMergableCount();
        Table t1 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), new MutableList(), "a, b", ClassTag$.MODULE$.apply(scala.Tuple2.class), new CaseClassTypeInfo<scala.Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, String>>(this, fieldSerializers){

                    public scala.Tuple2<Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$$anon$20 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count()});
        Table t2 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), new MutableList(), "a, b", ClassTag$.MODULE$.apply(scala.Tuple2.class), new CaseClassTypeInfo<scala.Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$21 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, String>>(this, fieldSerializers){

                    public scala.Tuple2<Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$$anon$21 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum(), package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)myAgg, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), (TypeInformation)new CaseClassTypeInfo<NonMergableCountAcc>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$22 x$1) {
                return x$1.types;
            }

            public TypeSerializer<NonMergableCountAcc> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$9[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<NonMergableCountAcc> unused = new ScalaCaseClassSerializer<NonMergableCountAcc>(this, fieldSerializers){

                    public NonMergableCountAcc createInstance(Object[] fields) {
                        return new NonMergableCountAcc(BoxesRunTime.unboxToLong((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$9(org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$$anon$22 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))})), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count()});
        Table t3 = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), new MutableList(), "a, b", ClassTag$.MODULE$.apply(scala.Tuple2.class), new CaseClassTypeInfo<scala.Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$23 x$1) {
                return x$1.types;
            }

            public TypeSerializer<scala.Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$10[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<scala.Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<scala.Tuple2<Object, String>>(this, fieldSerializers){

                    public scala.Tuple2<Object, String> createInstance(Object[] fields) {
                        return new scala.Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$10(org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$$anon$23 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum(), package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)myAgg, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), (TypeInformation)new CaseClassTypeInfo<NonMergableCountAcc>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$24 x$1) {
                return x$1.types;
            }

            public TypeSerializer<NonMergableCountAcc> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$11[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<NonMergableCountAcc> unused = new ScalaCaseClassSerializer<NonMergableCountAcc>(this, fieldSerializers){

                    public NonMergableCountAcc createInstance(Object[] fields) {
                        return new NonMergableCountAcc(BoxesRunTime.unboxToLong((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$11(org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$$anon$24 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).apply((Seq)Nil$.MODULE$), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).count()});
        String expected1 = "null,0";
        String expected2 = "null,0,0";
        String expected3 = "null,0,0";
        Seq<Row> results1 = this.executeQuery(t1);
        Seq<Row> results2 = this.executeQuery(t2);
        Seq<Row> results3 = this.executeQuery(t3);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results1).asJava()), (String)expected1);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results2).asJava()), (String)expected2);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results3).asJava()), (String)expected3);
    }

    @Test
    public void testGroupedAggregateWithLongKeys() {
        Table ds = BatchTableEnvUtil$.MODULE$.fromCollection(this.tEnv(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhaa", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhaa", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhaa", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhaa", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhaa", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhab", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhab", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhab", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)"hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhab", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2))})), "a,b,c", ClassTag$.MODULE$.apply(Tuple3.class), new CaseClassTypeInfo<Tuple3<String, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$25 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$12[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Object>>(this, fieldSerializers){

                    public Tuple3<String, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$12(org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$$anon$25 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).sum()});
        String expected = "10\n8\n";
        Seq<Row> results = this.executeQuery(ds);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupedAggregateWithConstant1() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.LiteralIntExpression(4).as((Symbol)SymbolLiteral.bootstrap("apply", "four"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "four")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "four")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()});
        String expected = "4,2\n4,3\n4,5\n4,5\n4,5\n4,6\n4,6\n4,6\n4,3\n4,4\n4,6\n4,1\n4,4\n4,4\n4,5\n4,6\n4,2\n4,3\n4,4\n4,5\n4,6\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupedAggregateWithConstant2() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.LiteralIntExpression(4).as((Symbol)SymbolLiteral.bootstrap("apply", "four"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}).groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "four"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "four")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()});
        String expected = "4,1\n4,5\n4,15\n4,34\n4,65\n4,111\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupedAggregateWithExpression() {
        Table t = CollectionBatchExecTable$.MODULE$.get5TupleDataSet(this.tEnv(), "a, b, c, d, e").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$percent(package$.MODULE$.int2Literal(3))}).select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")).min(), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).avg(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")).count()});
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(6).append("0,1,").append(1).append(",1").toString(), new StringBuilder(6).append("7,1,").append(4).append(",2").toString(), new StringBuilder(6).append("2,1,").append(3).append(",2").toString(), new StringBuilder(6).append("3,2,").append(3).append(",3").toString(), new StringBuilder(6).append("1,2,").append(3).append(",3").toString(), new StringBuilder(7).append("14,2,").append(5).append(",1").toString(), new StringBuilder(7).append("12,3,").append(5).append(",1").toString(), new StringBuilder(6).append("5,3,").append(4).append(",2").toString()}))).mkString("\n");
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testGroupedAggregateWithFilter() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).sum()}).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).$eq$eq$eq(package$.MODULE$.int2Literal(2)));
        String expected = "2,5\n";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testAnalyticAggregation() {
        Table ds = BatchTableEnvUtil$.MODULE$.fromElements(this.tEnv(), Predef$.MODULE$.wrapRefArray((Object[])new Tuple7[]{new Tuple7((Object)BoxesRunTime.boxToByte((byte)1), (Object)BoxesRunTime.boxToShort((short)1), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToFloat((float)1.0f), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BigDecimal.ONE), new Tuple7((Object)BoxesRunTime.boxToByte((byte)2), (Object)BoxesRunTime.boxToShort((short)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToFloat((float)2.0f), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)new BigDecimal(2))}), ClassTag$.MODULE$.apply(Tuple7.class), new CaseClassTypeInfo<Tuple7<Object, Object, Object, Object, Object, Object, BigDecimal>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$26 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple7<Object, Object, Object, Object, Object, Object, BigDecimal>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$13[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, BigDecimal>> unused = new ScalaCaseClassSerializer<Tuple7<Object, Object, Object, Object, Object, Object, BigDecimal>>(this, fieldSerializers){

                    public Tuple7<Object, Object, Object, Object, Object, Object, BigDecimal> createInstance(Object[] fields) {
                        return new Tuple7((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)fields[0])), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)fields[4])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[5])), (Object)((BigDecimal)fields[6]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$13(org.apache.flink.table.planner.runtime.batch.table.AggregationITCase$$anon$26 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        Table res = ds.select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).stddevPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).stddevPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).stddevPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_4")).stddevPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_5")).stddevPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_6")).stddevPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_7")).stddevPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).stddevSamp(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).stddevSamp(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).stddevSamp(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_4")).stddevSamp(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_5")).stddevSamp(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_6")).stddevSamp(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_7")).stddevSamp(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).varPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).varPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).varPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_4")).varPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_5")).varPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_6")).varPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_7")).varPop(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")).varSamp(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2")).varSamp(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_3")).varSamp(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_4")).varSamp(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_5")).varSamp(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_6")).varSamp(), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_7")).varSamp()});
        String expected = "0,0,0,0,0.5,0.5,0.500000000000000000,1,1,1,1,0.70710677,0.7071067811865476,0.707106781186547600,0,0,0,0,0.25,0.25,0.250000000000000000,1,1,1,1,0.5,0.5,0.500000000000000000";
        Seq<Row> results = this.executeQuery(res);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testComplexAggregate() {
        Object object;
        TupleTypeInfo elementType;
        Object object2;
        TupleTypeInfo elementType2;
        Top10 top10Fun = new Top10();
        GroupedTable groupedTable = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))});
        Expression[] expressionArray = new Expression[2];
        expressionArray[0] = package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"));
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Float.class), (List)Nil$.MODULE$));
        Class<Tuple2> clazz = Tuple2.class;
        TupleTypeInfo tupleTypeInfo = elementType2 = new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.BOOLEAN_TYPE_INFO;
        TupleTypeInfo tupleTypeInfo2 = tupleTypeInfo;
        if (!(basicTypeInfo != null ? !basicTypeInfo.equals(tupleTypeInfo2) : tupleTypeInfo2 != null)) {
            object2 = PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO;
        } else {
            BasicTypeInfo basicTypeInfo2 = BasicTypeInfo.BYTE_TYPE_INFO;
            TupleTypeInfo tupleTypeInfo3 = tupleTypeInfo;
            if (!(basicTypeInfo2 != null ? !basicTypeInfo2.equals(tupleTypeInfo3) : tupleTypeInfo3 != null)) {
                object2 = PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
            } else {
                BasicTypeInfo basicTypeInfo3 = BasicTypeInfo.CHAR_TYPE_INFO;
                TupleTypeInfo tupleTypeInfo4 = tupleTypeInfo;
                if (!(basicTypeInfo3 != null ? !basicTypeInfo3.equals(tupleTypeInfo4) : tupleTypeInfo4 != null)) {
                    object2 = PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO;
                } else {
                    BasicTypeInfo basicTypeInfo4 = BasicTypeInfo.DOUBLE_TYPE_INFO;
                    TupleTypeInfo tupleTypeInfo5 = tupleTypeInfo;
                    if (!(basicTypeInfo4 != null ? !basicTypeInfo4.equals(tupleTypeInfo5) : tupleTypeInfo5 != null)) {
                        object2 = PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO;
                    } else {
                        BasicTypeInfo basicTypeInfo5 = BasicTypeInfo.FLOAT_TYPE_INFO;
                        TupleTypeInfo tupleTypeInfo6 = tupleTypeInfo;
                        if (!(basicTypeInfo5 != null ? !basicTypeInfo5.equals(tupleTypeInfo6) : tupleTypeInfo6 != null)) {
                            object2 = PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO;
                        } else {
                            BasicTypeInfo basicTypeInfo6 = BasicTypeInfo.INT_TYPE_INFO;
                            TupleTypeInfo tupleTypeInfo7 = tupleTypeInfo;
                            if (!(basicTypeInfo6 != null ? !basicTypeInfo6.equals(tupleTypeInfo7) : tupleTypeInfo7 != null)) {
                                object2 = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
                            } else {
                                BasicTypeInfo basicTypeInfo7 = BasicTypeInfo.LONG_TYPE_INFO;
                                TupleTypeInfo tupleTypeInfo8 = tupleTypeInfo;
                                if (!(basicTypeInfo7 != null ? !basicTypeInfo7.equals(tupleTypeInfo8) : tupleTypeInfo8 != null)) {
                                    object2 = PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO;
                                } else {
                                    BasicTypeInfo basicTypeInfo8 = BasicTypeInfo.SHORT_TYPE_INFO;
                                    TupleTypeInfo tupleTypeInfo9 = tupleTypeInfo;
                                    if (!(basicTypeInfo8 != null ? !basicTypeInfo8.equals(tupleTypeInfo9) : tupleTypeInfo9 != null)) {
                                        object2 = PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO;
                                    } else {
                                        BasicTypeInfo basicTypeInfo9 = BasicTypeInfo.STRING_TYPE_INFO;
                                        TupleTypeInfo tupleTypeInfo10 = tupleTypeInfo;
                                        object2 = !(basicTypeInfo9 != null ? !basicTypeInfo9.equals(tupleTypeInfo10) : tupleTypeInfo10 != null) ? BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO : ObjectArrayTypeInfo.getInfoFor((TypeInformation)elementType2);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        PrimitiveArrayTypeInfo result = object2;
        .colon.colon fields2 = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Integer.class), (List)new .colon.colon((Object)BasicTypeInfo.getInfoFor(Float.class), (List)Nil$.MODULE$));
        Class<Tuple2> clazz2 = Tuple2.class;
        TupleTypeInfo tupleTypeInfo11 = elementType = new TupleTypeInfo(clazz2, (TypeInformation[])fields2.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class)));
        BasicTypeInfo basicTypeInfo10 = BasicTypeInfo.BOOLEAN_TYPE_INFO;
        TupleTypeInfo tupleTypeInfo12 = tupleTypeInfo11;
        if (!(basicTypeInfo10 != null ? !basicTypeInfo10.equals(tupleTypeInfo12) : tupleTypeInfo12 != null)) {
            object = PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO;
        } else {
            BasicTypeInfo basicTypeInfo11 = BasicTypeInfo.BYTE_TYPE_INFO;
            TupleTypeInfo tupleTypeInfo13 = tupleTypeInfo11;
            if (!(basicTypeInfo11 != null ? !basicTypeInfo11.equals(tupleTypeInfo13) : tupleTypeInfo13 != null)) {
                object = PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
            } else {
                BasicTypeInfo basicTypeInfo12 = BasicTypeInfo.CHAR_TYPE_INFO;
                TupleTypeInfo tupleTypeInfo14 = tupleTypeInfo11;
                if (!(basicTypeInfo12 != null ? !basicTypeInfo12.equals(tupleTypeInfo14) : tupleTypeInfo14 != null)) {
                    object = PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO;
                } else {
                    BasicTypeInfo basicTypeInfo13 = BasicTypeInfo.DOUBLE_TYPE_INFO;
                    TupleTypeInfo tupleTypeInfo15 = tupleTypeInfo11;
                    if (!(basicTypeInfo13 != null ? !basicTypeInfo13.equals(tupleTypeInfo15) : tupleTypeInfo15 != null)) {
                        object = PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO;
                    } else {
                        BasicTypeInfo basicTypeInfo14 = BasicTypeInfo.FLOAT_TYPE_INFO;
                        TupleTypeInfo tupleTypeInfo16 = tupleTypeInfo11;
                        if (!(basicTypeInfo14 != null ? !basicTypeInfo14.equals(tupleTypeInfo16) : tupleTypeInfo16 != null)) {
                            object = PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO;
                        } else {
                            BasicTypeInfo basicTypeInfo15 = BasicTypeInfo.INT_TYPE_INFO;
                            TupleTypeInfo tupleTypeInfo17 = tupleTypeInfo11;
                            if (!(basicTypeInfo15 != null ? !basicTypeInfo15.equals(tupleTypeInfo17) : tupleTypeInfo17 != null)) {
                                object = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
                            } else {
                                BasicTypeInfo basicTypeInfo16 = BasicTypeInfo.LONG_TYPE_INFO;
                                TupleTypeInfo tupleTypeInfo18 = tupleTypeInfo11;
                                if (!(basicTypeInfo16 != null ? !basicTypeInfo16.equals(tupleTypeInfo18) : tupleTypeInfo18 != null)) {
                                    object = PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO;
                                } else {
                                    BasicTypeInfo basicTypeInfo17 = BasicTypeInfo.SHORT_TYPE_INFO;
                                    TupleTypeInfo tupleTypeInfo19 = tupleTypeInfo11;
                                    if (!(basicTypeInfo17 != null ? !basicTypeInfo17.equals(tupleTypeInfo19) : tupleTypeInfo19 != null)) {
                                        object = PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO;
                                    } else {
                                        BasicTypeInfo basicTypeInfo18 = BasicTypeInfo.STRING_TYPE_INFO;
                                        TupleTypeInfo tupleTypeInfo20 = tupleTypeInfo11;
                                        object = !(basicTypeInfo18 != null ? !basicTypeInfo18.equals(tupleTypeInfo20) : tupleTypeInfo20 != null) ? BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO : ObjectArrayTypeInfo.getInfoFor((TypeInformation)elementType);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        PrimitiveArrayTypeInfo result2 = object;
        expressionArray[1] = package$.MODULE$.ImperativeAggregateFunctionCall((ImperativeAggregateFunction)top10Fun, (TypeInformation)result, (TypeInformation)result2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).cast(DataTypes.INT())).ifNull((Object)package$.MODULE$.int2Literal(0)), (Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast(DataTypes.FLOAT())).ifNull((Object)package$.MODULE$.float2Literal(0.0f))}));
        Table t = groupedTable.select(expressionArray);
        String expected = "1,[(1,1.0), null, null, null, null, null, null, null, null, null]\n2,[(2,3.0), (2,2.0), null, null, null, null, null, null, null, null]\n3,[(3,6.0), (3,5.0), (3,4.0), null, null, null, null, null, null, null]\n4,[(4,10.0), (4,9.0), (4,8.0), (4,7.0), null, null, null, null, null, null]\n5,[(5,15.0), (5,14.0), (5,13.0), (5,12.0), (5,11.0), null, null, null, null, null]\n6,[(6,21.0), (6,20.0), (6,19.0), (6,18.0), (6,17.0), (6,16.0), null, null, null, null]";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }

    @Test
    public void testCollect() {
        Table t = CollectionBatchExecTable$.MODULE$.get3TupleDataSet(this.tEnv(), "a, b, c").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).collect()});
        String expected = "1,{1=1}\n2,{2=1, 3=1}\n3,{4=1, 5=1, 6=1}\n4,{7=1, 8=1, 9=1, 10=1}\n5,{11=1, 12=1, 13=1, 14=1, 15=1}\n6,{16=1, 17=1, 18=1, 19=1, 20=1, 21=1}";
        Seq<Row> results = this.executeQuery(t);
        TestBaseUtils.compareResultAsText((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(results).asJava()), (String)expected);
    }
}

