/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;

public class CorrelateJsonPlanITCase
extends JsonPlanTestBase {
    @Before
    public void before() {
        List<Row> data = Collections.singletonList(Row.of((Object[])new Object[]{"1,1,hi"}));
        this.createTestValuesSourceTable("MyTable", data, "a varchar");
    }

    @Test
    public void testSystemFuncByObject() throws ExecutionException, InterruptedException {
        this.tableEnv.createTemporarySystemFunction("STRING_SPLIT", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.createTestValuesSinkTable("MySink", "a STRING", "b STRING");
        String query = "insert into MySink SELECT a, v FROM MyTable, lateral table(STRING_SPLIT(a, ',')) as T(v)";
        this.compileSqlAndExecutePlan(query).await();
        List<String> expected = Arrays.asList("+I[1,1,hi, 1]", "+I[1,1,hi, 1]", "+I[1,1,hi, hi]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }

    @Test
    public void testSystemFuncByClass() throws ExecutionException, InterruptedException {
        this.tableEnv.createTemporarySystemFunction("STRING_SPLIT", JavaUserDefinedTableFunctions.StringSplit.class);
        this.createTestValuesSinkTable("MySink", "a STRING", "b STRING");
        String query = "insert into MySink SELECT a, v FROM MyTable, lateral table(STRING_SPLIT(a, ',')) as T(v)";
        this.compileSqlAndExecutePlan(query).await();
        List<String> expected = Arrays.asList("+I[1,1,hi, 1]", "+I[1,1,hi, 1]", "+I[1,1,hi, hi]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }

    @Test
    public void testTemporaryFuncByObject() throws ExecutionException, InterruptedException {
        this.tableEnv.createTemporaryFunction("STRING_SPLIT", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.createTestValuesSinkTable("MySink", "a STRING", "b STRING");
        String query = "insert into MySink SELECT a, v FROM MyTable, lateral table(STRING_SPLIT(a, ',')) as T(v)";
        this.compileSqlAndExecutePlan(query).await();
        List<String> expected = Arrays.asList("+I[1,1,hi, 1]", "+I[1,1,hi, 1]", "+I[1,1,hi, hi]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }

    @Test
    public void testTemporaryFuncByClass() throws ExecutionException, InterruptedException {
        this.tableEnv.createTemporaryFunction("STRING_SPLIT", JavaUserDefinedTableFunctions.StringSplit.class);
        this.createTestValuesSinkTable("MySink", "a STRING", "b STRING");
        String query = "insert into MySink SELECT a, v FROM MyTable, lateral table(STRING_SPLIT(a, ',')) as T(v)";
        this.compileSqlAndExecutePlan(query).await();
        List<String> expected = Arrays.asList("+I[1,1,hi, 1]", "+I[1,1,hi, 1]", "+I[1,1,hi, hi]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }

    @Test
    public void testFilter() throws ExecutionException, InterruptedException {
        this.tableEnv.createTemporarySystemFunction("STRING_SPLIT", (UserDefinedFunction)new JavaUserDefinedTableFunctions.StringSplit());
        this.createTestValuesSinkTable("MySink", "a STRING", "b STRING");
        String query = "insert into MySink SELECT a, v FROM MyTable, lateral table(STRING_SPLIT(a, ',')) as T(v) where try_cast(v as int) > 0";
        this.compileSqlAndExecutePlan(query).await();
        List<String> expected = Arrays.asList("+I[1,1,hi, 1]", "+I[1,1,hi, 1]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }

    @Test
    public void testUnnest() throws ExecutionException, InterruptedException {
        List<Row> data = Collections.singletonList(Row.of((Object[])new Object[]{"Bob", new Row[]{Row.of((Object[])new Object[]{"1"}), Row.of((Object[])new Object[]{"2"}), Row.of((Object[])new Object[]{"3"})}}));
        this.createTestValuesSourceTable("MyNestedTable", data, "name STRING", "arr ARRAY<ROW<nested STRING>>");
        this.createTestValuesSinkTable("MySink", "name STRING", "nested STRING");
        String query = "INSERT INTO MySink SELECT name, nested FROM MyNestedTable CROSS JOIN UNNEST(arr) AS t (nested)";
        this.compileSqlAndExecutePlan(query).await();
        List<String> expected = Arrays.asList("+I[Bob, 1]", "+I[Bob, 2]", "+I[Bob, 3]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }
}

