/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.junit.Before;
import org.junit.Test;

public class GroupWindowAggregateJsonITCase
extends JsonPlanTestBase {
    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.windowDataWithTimestamp()), new String[]{"ts STRING", "`int` INT", "`double` DOUBLE", "`float` FLOAT", "`bigdec` DECIMAL(10, 2)", "`string` STRING", "`name` STRING", "`rowtime` AS TO_TIMESTAMP(`ts`)", "WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND"}, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("enable-watermark-push-down", "true");
                this.put("failing-source", "true");
            }
        });
    }

    @Test
    public void testEventTimeTumbleWindow() throws Exception {
        this.createTestValuesSinkTable("MySink", "name STRING", "window_start TIMESTAMP(3)", "window_end TIMESTAMP(3)", "cnt BIGINT", "sum_int INT", "distinct_cnt BIGINT");
        this.compileSqlAndExecutePlan("insert into MySink select\n  name,\n  TUMBLE_START(rowtime, INTERVAL '5' SECOND) as window_start,\n  TUMBLE_END(rowtime, INTERVAL '5' SECOND) as window_end,\n  COUNT(*),\n  SUM(`int`),\n  COUNT(DISTINCT `string`)\nFROM MyTable\nGROUP BY name, TUMBLE(rowtime, INTERVAL '5' SECOND)").await();
        List<String> result = TestValuesTableFactory.getResults("MySink");
        this.assertResult(Arrays.asList("+I[a, 2020-10-10T00:00, 2020-10-10T00:00:05, 4, 10, 2]", "+I[a, 2020-10-10T00:00:05, 2020-10-10T00:00:10, 1, 3, 1]", "+I[b, 2020-10-10T00:00:05, 2020-10-10T00:00:10, 2, 9, 2]", "+I[b, 2020-10-10T00:00:15, 2020-10-10T00:00:20, 1, 4, 1]", "+I[b, 2020-10-10T00:00:30, 2020-10-10T00:00:35, 1, 1, 1]", "+I[null, 2020-10-10T00:00:30, 2020-10-10T00:00:35, 1, 7, 0]"), result);
    }

    @Test
    public void testEventTimeHopWindow() throws Exception {
        this.createTestValuesSinkTable("MySink", "name STRING", "cnt BIGINT");
        this.compileSqlAndExecutePlan("insert into MySink select\n  name,\n  COUNT(*)\nFROM MyTable\nGROUP BY name, HOP(rowtime, INTERVAL '5' SECOND, INTERVAL '10' SECOND)").await();
        List<String> result = TestValuesTableFactory.getResults("MySink");
        this.assertResult(Arrays.asList("+I[a, 1]", "+I[a, 4]", "+I[a, 6]", "+I[b, 1]", "+I[b, 1]", "+I[b, 1]", "+I[b, 1]", "+I[b, 2]", "+I[b, 2]", "+I[null, 1]", "+I[null, 1]"), result);
    }

    @Test
    public void testEventTimeSessionWindow() throws Exception {
        this.createTestValuesSinkTable("MySink", "name STRING", "cnt BIGINT");
        this.compileSqlAndExecutePlan("insert into MySink select\n  name,\n  COUNT(*)\nFROM MyTable\nGROUP BY name, Session(rowtime, INTERVAL '3' SECOND)").await();
        List<String> result = TestValuesTableFactory.getResults("MySink");
        this.assertResult(Arrays.asList("+I[a, 1]", "+I[a, 4]", "+I[b, 1]", "+I[b, 1]", "+I[b, 2]", "+I[null, 1]"), result);
    }
}

