/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;

public class LookupJoinJsonPlanITCase
extends JsonPlanTestBase {
    @Override
    public void setup() throws Exception {
        super.setup();
        List<Row> rowT1 = Arrays.asList(Row.of((Object[])new Object[]{1L, 12, "Julian"}), Row.of((Object[])new Object[]{2L, 15, "Hello"}), Row.of((Object[])new Object[]{3L, 15, "Fabian"}), Row.of((Object[])new Object[]{8L, 11, "Hello world"}), Row.of((Object[])new Object[]{9L, 12, "Hello world!"}));
        List<Row> rowT2 = Arrays.asList(Row.of((Object[])new Object[]{11, 1L, "Julian"}), Row.of((Object[])new Object[]{22, 2L, "Jark"}), Row.of((Object[])new Object[]{33, 3L, "Fabian"}), Row.of((Object[])new Object[]{11, 4L, "Hello world"}), Row.of((Object[])new Object[]{11, 5L, "Hello world"}));
        this.createTestValuesSourceTable("src", rowT1, "id bigint", "len int", "content varchar", "proctime as PROCTIME()");
        this.createTestValuesSourceTable("user_table", rowT2, new String[]{"age int", "id bigint", "name varchar"}, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("disable-lookup", "false");
            }
        });
        this.createTestValuesSinkTable("MySink", "id bigint", "len int", "content varchar", "name varchar");
    }

    @Test
    public void testJoinLookupTable() throws Exception {
        this.compileSqlAndExecutePlan("insert into MySink SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table \nfor system_time as of T.proctime AS D ON T.id = D.id \n").await();
        List<String> expected = Arrays.asList("+I[1, 12, Julian, Julian]", "+I[2, 15, Hello, Jark]", "+I[3, 15, Fabian, Fabian]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }

    @Test
    public void testJoinLookupTableWithPushDown() throws Exception {
        this.compileSqlAndExecutePlan("insert into MySink \nSELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table \n for system_time as of T.proctime AS D ON T.id = D.id AND D.age > 20").await();
        List<String> expected = Arrays.asList("+I[2, 15, Hello, Jark]", "+I[3, 15, Fabian, Fabian]");
        this.assertResult(expected, TestValuesTableFactory.getResults("MySink"));
    }
}

