/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TemporalSortJsonITCase
extends JsonPlanTestBase {
    @Test
    public void testSortProcessingTime() throws Exception {
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.smallData3()), "a INT", "b BIGINT", "c STRING", "proctime as PROCTIME()");
        this.createTestValuesSinkTable("MySink", "a INT");
        this.compileSqlAndExecutePlan("insert into MySink SELECT a FROM MyTable order by proctime").await();
        this.assertResult(Arrays.asList("+I[1]", "+I[2]", "+I[3]"), TestValuesTableFactory.getResults("MySink"));
    }

    @Test
    public void testSortRowTime() throws Exception {
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.windowDataWithTimestamp()), new String[]{"ts STRING", "`int` INT", "`double` DOUBLE", "`float` FLOAT", "`bigdec` DECIMAL(10, 2)", "`string` STRING", "`name` STRING", "`rowtime` AS TO_TIMESTAMP(`ts`)", "WATERMARK for `rowtime` AS `rowtime` - INTERVAL '1' SECOND"}, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("enable-watermark-push-down", "true");
                this.put("failing-source", "true");
            }
        });
        this.createTestValuesSinkTable("MySink", "`int` INT");
        this.compileSqlAndExecutePlan("insert into MySink SELECT `int` FROM MyTable order by rowtime, `double`").await();
        Assertions.assertThat(TestValuesTableFactory.getResults("MySink")).isEqualTo(Arrays.asList("+I[1]", "+I[2]", "+I[2]", "+I[5]", "+I[6]", "+I[3]", "+I[3]", "+I[4]", "+I[7]", "+I[1]"));
    }
}

