/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.AsyncLookupJoinITCase$;
import org.apache.flink.table.planner.runtime.utils.InMemoryLookupableTableSource$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestAddWithOpen$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestExceptionThrown$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestMod$;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$TestWrapperUdf$;
import org.apache.flink.table.runtime.functions.table.lookup.LookupCacheManager;
import org.apache.flink.types.Row;
import org.apache.flink.util.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\t\rf\u0001B\u0001\u0003\u0001M\u0011Q#Q:z]\u000edun\\6va*{\u0017N\\%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0012Y\u0016<\u0017mY=UC\ndWmU8ve\u000e,\u0007CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"a\u0002\"p_2,\u0017M\u001c\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u00059!-Y2lK:$\u0007CA\u0013:\u001d\t1sG\u0004\u0002(m9\u0011\u0001&\u000e\b\u0003SQr!AK\u001a\u000f\u0005-\u0012dB\u0001\u00172\u001d\ti\u0003'D\u0001/\u0015\ty##\u0001\u0004=e>|GOP\u0005\u0002#%\u0011q\u0002E\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t9b!\u0003\u00029-\u0005Q2\u000b\u001e:fC6LgnZ,ji\"\u001cF/\u0019;f)\u0016\u001cHOQ1tK&\u0011!h\u000f\u0002\u0011'R\fG/\u001a\"bG.,g\u000eZ'pI\u0016T!\u0001\u000f\f\t\u0011u\u0002!\u0011!Q\u0001\nq\t1b\u001c2kK\u000e$(+Z;tK\"Aq\b\u0001B\u0001B\u0003%\u0001)A\bbgft7mT;uaV$Xj\u001c3f!\t\tEJ\u0004\u0002C\u0013:\u00111I\u0012\b\u0003S\u0011K!!\u0012\u0006\u0002\u0007\u0005\u0004\u0018.\u0003\u0002H\u0011\u000611m\u001c8gS\u001eT!!\u0012\u0006\n\u0005)[\u0015AF#yK\u000e,H/[8o\u0007>tg-[4PaRLwN\\:\u000b\u0005\u001dC\u0015BA'O\u0005=\t5/\u001f8d\u001fV$\b/\u001e;N_\u0012,'B\u0001&L\u0011!\u0001\u0006A!A!\u0002\u0013a\u0012aC3oC\ndWmQ1dQ\u0016DQA\u0015\u0001\u0005\u0002M\u000ba\u0001P5oSRtDC\u0002+W/bK&\f\u0005\u0002V\u00015\t!\u0001C\u0003\u001c#\u0002\u0007A\u0004C\u0003$#\u0002\u0007A\u0005C\u0003>#\u0002\u0007A\u0004C\u0003@#\u0002\u0007\u0001\tC\u0003Q#\u0002\u0007A\u0004C\u0004]\u0001\t\u0007I\u0011A/\u0002\t\u0011\fG/Y\u000b\u0002=B\u0019q\f\u001a4\u000e\u0003\u0001T!!\u00192\u0002\u0013%lW.\u001e;bE2,'BA2\u001f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003K\u0002\u0014A\u0001T5tiB\u0011qM[\u0007\u0002Q*\u0011\u0011\u000eD\u0001\u0006if\u0004Xm]\u0005\u0003W\"\u00141AU8x\u0011\u0019i\u0007\u0001)A\u0005=\u0006)A-\u0019;bA!9q\u000e\u0001b\u0001\n\u0003i\u0016\u0001C;tKJ$\u0015\r^1\t\rE\u0004\u0001\u0015!\u0003_\u0003%)8/\u001a:ECR\f\u0007\u0005C\u0003t\u0001\u0011\u0005C/\u0001\u0004cK\u001a|'/\u001a\u000b\u0002kB\u0011QD^\u0005\u0003oz\u0011A!\u00168ji\"\u0012!/\u001f\t\u0003uvl\u0011a\u001f\u0006\u0003yB\tQA[;oSRL!A`>\u0003\r\t+gm\u001c:f\u0011\u0019\t\t\u0001\u0001C!i\u0006)\u0011M\u001a;fe\"\u001aq0!\u0002\u0011\u0007i\f9!C\u0002\u0002\nm\u0014Q!\u00114uKJDq!!\u0004\u0001\t\u0013\ty!A\tde\u0016\fG/\u001a'p_.,\b\u000fV1cY\u0016$r!^A\t\u0003K\t9\u0004\u0003\u0005\u0002\u0014\u0005-\u0001\u0019AA\u000b\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0005\u0003\u0002\u0018\u0005}a\u0002BA\r\u00037\u0001\"!\f\u0010\n\u0007\u0005ua$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\t\u0019C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003;q\u0002b\u0002/\u0002\f\u0001\u0007\u0011q\u0005\t\u0006\u0003S\t\u0019D\u001a\b\u0005\u0003W\tyCD\u0002.\u0003[I\u0011aH\u0005\u0004\u0003cq\u0012a\u00029bG.\fw-Z\u0005\u0004K\u0006U\"bAA\u0019=!Q\u0011\u0011HA\u0006!\u0003\u0005\r!a\u000f\u0002\u001f1|wn[;q)\"\u0014Xm\u001d5pY\u0012\u00042!HA\u001f\u0013\r\tyD\b\u0002\u0004\u0013:$\bbBA\"\u0001\u0011%\u0011QI\u0001\u0018O\u0016$\u0018i]=oGJ+GO]=M_>\\W\u000f\u001d%j]R$b!!\u0006\u0002H\u0005-\u0003\u0002CA%\u0003\u0003\u0002\r!!\u0006\u0002\u00171|wn[;q)\u0006\u0014G.\u001a\u0005\t\u0003\u001b\n\t\u00051\u0001\u0002<\u0005YQ.\u0019=BiR,W\u000e\u001d;t\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'\nqb\u0019:fCR,7kY1o)\u0006\u0014G.\u001a\u000b\u0006k\u0006U\u0013q\u000b\u0005\t\u0003'\ty\u00051\u0001\u0002\u0016!9A,a\u0014A\u0002\u0005\u001d\u0002BBA.\u0001\u0011\u0005A/\u0001\u0016uKN$\u0018i]=oG*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148Nk2$\u0018nS3z\r&,G\u000eZ:)\t\u0005e\u0013q\f\t\u0004u\u0006\u0005\u0014bAA2w\n!A+Z:u\u0011\u0019\t9\u0007\u0001C\u0001i\u0006QB/Z:u\u0003NLhn\u0019&pS:$V-\u001c9pe\u0006dG+\u00192mK\"\"\u0011QMA0\u0011\u0019\ti\u0007\u0001C\u0001i\u00061C/Z:u\u0003NLhn\u0019&pS:$V-\u001c9pe\u0006dG+\u00192mK^KG\u000f\u001b)vg\"$un\u001e8)\t\u0005-\u0014q\f\u0005\u0007\u0003g\u0002A\u0011\u0001;\u0002YQ,7\u000f^!ts:\u001c'j\\5o)\u0016l\u0007o\u001c:bYR\u000b'\r\\3XSRDgj\u001c8FcV\fGNR5mi\u0016\u0014\b\u0006BA9\u0003?Ba!!\u001f\u0001\t\u0003!\u0018\u0001\r;fgR\f5/\u001f8d\u0019\u00164GOS8j]R+W\u000e]8sC2$\u0016M\u00197f/&$\b\u000eT8dC2\u0004&/\u001a3jG\u0006$X\r\u000b\u0003\u0002x\u0005}\u0003BBA@\u0001\u0011\u0005A/A\u0014uKN$\u0018i]=oG*{\u0017N\u001c+f[B|'/\u00197UC\ndWm\u00148Nk2$\u0018NR5fY\u0012\u001c\b\u0006BA?\u0003?Ba!!\"\u0001\t\u0003!\u0018A\f;fgR\f5/\u001f8d\u0015>Lg\u000eV3na>\u0014\u0018\r\u001c+bE2,wJ\\'vYRLg)[3mIN<\u0016\u000e\u001e5VI\u001aDC!a!\u0002`!1\u00111\u0012\u0001\u0005\u0002Q\fq\u0005^3ti\u0006\u001b\u0018P\\2K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5VI\u001a4\u0015\u000e\u001c;fe\"\"\u0011\u0011RA0\u0011\u0019\t\t\n\u0001C\u0001i\u0006!C/Z:u\u0003\u001e<\u0017I\u001c3Bgft7\rT3gi*{\u0017N\u001c+f[B|'/\u00197UC\ndW\r\u000b\u0003\u0002\u0010\u0006}\u0003BBAL\u0001\u0011\u0005A/A\u0015uKN$\u0018iZ4B]\u0012\f5/\u001f8d\u0019\u00164GOS8j]^KG\u000f\u001b+ssJ+7o\u001c7wK6{G-\u001a\u0015\u0005\u0003+\u000by\u0006\u0003\u0004\u0002\u001e\u0002!\t\u0001^\u0001\u001fi\u0016\u001cH/Q:z]\u000edUM\u001a;K_&tG+Z7q_J\fG\u000eV1cY\u0016DC!a'\u0002`!1\u00111\u0015\u0001\u0005\u0002Q\fQ\u0006^3ti\u0016C8-\u001a9uS>tG\u000b\u001b:po:4%o\\7Bgft7MS8j]R+W\u000e]8sC2$\u0016M\u00197fQ\u0011\t\t+a\u0018\t\r\u0005%\u0006\u0001\"\u0001u\u0003\u0011\"Xm\u001d;M_>\\W\u000f]\"bG\",7\u000b[1sS:<\u0017i\u0019:pgN\u001cVO\u0019;bg.\u001c\b\u0006BAT\u0003?Bq!a,\u0001\t\u0003\t\t,\u0001\u0002kSR!\u00111WAb!\u0011\t),a0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000bA\u0001\\1oO*\u0011\u0011QX\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002B\u0006]&aB%oi\u0016<WM\u001d\u0005\t\u0003\u000b\fi\u000b1\u0001\u0002<\u0005\t\u0011\u000eC\u0004\u0002J\u0002!\t!a3\u0002\u0005)dG\u0003BAg\u0003'\u0004B!!.\u0002P&!\u0011\u0011[A\\\u0005\u0011auN\\4\t\u0011\u0005U\u0017q\u0019a\u0001\u0003/\f\u0011\u0001\u001c\t\u0004;\u0005e\u0017bAAi=!1\u0011Q\u001c\u0001\u0005\u0002Q\f1\u0005^3ti\u0006\u001b\u0018P\\2K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5SKR\u0014\u0018\u0010\u000b\u0003\u0002\\\u0006}\u0003BBAr\u0001\u0011\u0005A/\u0001\"uKN$\u0018i]=oG*{\u0017N\u001c+f[B|'/\u00197UC\ndWmV5uQ2{wn[;q)\"\u0014Xm\u001d5pY\u0012<\u0016\u000e\u001e5J]N,hMZ5dS\u0016tGOU3uefDC!!9\u0002`!1\u0011\u0011\u001e\u0001\u0005\u0002Q\f\u0001\t^3ti\u0006\u001b\u0018P\\2K_&tG+Z7q_J\fG\u000eV1cY\u0016<\u0016\u000e\u001e5M_>\\W\u000f\u001d+ie\u0016\u001c\bn\u001c7e/&$\bnU;gM&\u001c\u0017.\u001a8u%\u0016$(/\u001f\u0015\u0005\u0003O\fy\u0006C\u0005\u0002p\u0002\t\n\u0011\"\u0003\u0002r\u0006Y2M]3bi\u0016dun\\6vaR\u000b'\r\\3%I\u00164\u0017-\u001e7uIM*\"!a=+\t\u0005m\u0012Q_\u0016\u0003\u0003o\u0004B!!?\u0003\u00045\u0011\u00111 \u0006\u0005\u0003{\fy0A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u0001\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0006\u0005m(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\":\u0001A!\u0003\u0003\u0016\t]\u0001\u0003\u0002B\u0006\u0005#i!A!\u0004\u000b\u0007\t=10\u0001\u0004sk:tWM]\u0005\u0005\u0005'\u0011iAA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\te\u0001\u0003\u0002B\u000e\u0005Ci!A!\b\u000b\u0007\t}10A\u0004sk:tWM]:\n\t\t\r\"Q\u0004\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000f\t\u001d\"\u0001#\u0001\u0003*\u0005)\u0012i]=oG2{wn[;q\u0015>Lg.\u0013+DCN,\u0007cA+\u0003,\u00191\u0011A\u0001E\u0001\u0005[\u0019BAa\u000b\u00030A\u0019QD!\r\n\u0007\tMbD\u0001\u0004B]f\u0014VM\u001a\u0005\b%\n-B\u0011\u0001B\u001c)\t\u0011I\u0003\u0003\u0006\u0003<\t-\"\u0019!C\u0001\u0005{\t1\u0003T#H\u0003\u000eKv\fV!C\u0019\u0016{6kT+S\u0007\u0016+\"Aa\u0010\u0011\t\u0005U&\u0011I\u0005\u0004C\u0005]\u0006\"\u0003B#\u0005W\u0001\u000b\u0011\u0002B \u0003QaUiR!D3~#\u0016I\u0011'F?N{UKU\"FA!Q!\u0011\nB\u0016\u0005\u0004%\tA!\u0010\u0002)\u0011Kf*Q'J\u0007~#\u0016I\u0011'F?N{UKU\"F\u0011%\u0011iEa\u000b!\u0002\u0013\u0011y$A\u000bE3:\u000bU*S\"`)\u0006\u0013E*R0T\u001fV\u00136)\u0012\u0011\t\u0015\tE#1\u0006b\u0001\n\u0003\u0011i$A\nF\u001d\u0006\u0013E*R0P\u0005*+5\tV0S\u000bV\u001bV\tC\u0005\u0003V\t-\u0002\u0015!\u0003\u0003@\u0005!RIT!C\u0019\u0016{vJ\u0011&F\u0007R{&+R+T\u000b\u0002B!B!\u0017\u0003,\t\u0007I\u0011\u0001B\u001f\u0003Q!\u0015jU!C\u0019\u0016{vJ\u0011&F\u0007R{&+R+T\u000b\"I!Q\fB\u0016A\u0003%!qH\u0001\u0016\t&\u001b\u0016I\u0011'F?>\u0013%*R\"U?J+UkU#!\u0011)\u0011\tGa\u000bC\u0002\u0013\u0005!QH\u0001\r\u000b:\u000b%\tT#`\u0007\u0006\u001b\u0005*\u0012\u0005\n\u0005K\u0012Y\u0003)A\u0005\u0005\u007f\tQ\"\u0012(B\u00052+ulQ!D\u0011\u0016\u0003\u0003B\u0003B5\u0005W\u0011\r\u0011\"\u0001\u0003>\u0005iA)S*B\u00052+ulQ!D\u0011\u0016C\u0011B!\u001c\u0003,\u0001\u0006IAa\u0010\u0002\u001d\u0011K5+\u0011\"M\u000b~\u001b\u0015i\u0011%FA!A!\u0011\u000fB\u0016\t\u0003\u0011\u0019(\u0001\u0006qCJ\fW.\u001a;feN$\"A!\u001e\u0011\r\t]$Q\u0010BA\u001b\t\u0011IH\u0003\u0003\u0003|\u0005m\u0016\u0001B;uS2LAAa \u0003z\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u000bu\u0011\u0019Ia\"\n\u0007\t\u0015eDA\u0003BeJ\f\u0017\u0010\u0005\u0003\u00026\n%\u0015\u0002\u0002BF\u0003o\u0013aa\u00142kK\u000e$\b\u0006\u0003B8\u0005\u001f\u0013iJa(\u0011\t\tE%q\u0013\b\u0005\u00057\u0011\u0019*\u0003\u0003\u0003\u0016\nu\u0011!\u0004)be\u0006lW\r^3sSj,G-\u0003\u0003\u0003\u001a\nm%A\u0003)be\u0006lW\r^3sg*!!Q\u0013B\u000f\u0003\u0011q\u0017-\\3\"\u0005\t\u0005\u0016A\u0018'fO\u0006\u001c\u0017\u0010V1cY\u0016\u001cv.\u001e:dKvZ\b' \u0017!'R\fG/\u001a\"bG.,g\u000eZ\u001f|cud\u0003e\u00142kK\u000e$(+Z;tKvZ(' \u0017!\u0003NLhnY(viB,H/T8eKvZ8' \u0017!\u000b:\f'\r\\3DC\u000eDW-P>5{\u0002")
public class AsyncLookupJoinITCase
extends StreamingWithStateTestBase {
    private final boolean legacyTableSource;
    private final boolean objectReuse;
    private final ExecutionConfigOptions.AsyncOutputMode asyncOutputMode;
    private final boolean enableCache;
    private final List<Row> data;
    private final List<Row> userData;

    @Parameterized.Parameters(name="LegacyTableSource={0}, StateBackend={1}, ObjectReuse={2}, AsyncOutputMode={3}, EnableCache={4}")
    public static Collection<Object[]> parameters() {
        return AsyncLookupJoinITCase$.MODULE$.parameters();
    }

    public static Boolean DISABLE_CACHE() {
        return AsyncLookupJoinITCase$.MODULE$.DISABLE_CACHE();
    }

    public static Boolean ENABLE_CACHE() {
        return AsyncLookupJoinITCase$.MODULE$.ENABLE_CACHE();
    }

    public static Boolean DISABLE_OBJECT_REUSE() {
        return AsyncLookupJoinITCase$.MODULE$.DISABLE_OBJECT_REUSE();
    }

    public static Boolean ENABLE_OBJECT_REUSE() {
        return AsyncLookupJoinITCase$.MODULE$.ENABLE_OBJECT_REUSE();
    }

    public static Boolean DYNAMIC_TABLE_SOURCE() {
        return AsyncLookupJoinITCase$.MODULE$.DYNAMIC_TABLE_SOURCE();
    }

    public static Boolean LEGACY_TABLE_SOURCE() {
        return AsyncLookupJoinITCase$.MODULE$.LEGACY_TABLE_SOURCE();
    }

    public List<Row> data() {
        return this.data;
    }

    public List<Row> userData() {
        return this.userData;
    }

    @Override
    @Before
    public void before() {
        super.before();
        if (this.legacyTableSource) {
            InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().set(0);
        } else {
            TestValuesTableFactory.RESOURCE_COUNTER.set(0);
        }
        ExecutionConfig executionConfig = this.objectReuse ? this.env().getConfig().enableObjectReuse() : this.env().getConfig().disableObjectReuse();
        this.tEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_ASYNC_LOOKUP_OUTPUT_MODE, (Object)this.asyncOutputMode);
        this.createScanTable("src", this.data());
        this.createLookupTable("user_table", this.userData(), this.createLookupTable$default$3());
        this.createLookupTable("user_table_with_lookup_threshold2", this.userData(), 2);
        this.createLookupTable("user_table_with_lookup_threshold3", this.userData(), 3);
    }

    @Override
    @After
    public void after() {
        super.after();
        if (this.legacyTableSource) {
            Assert.assertEquals((long)0L, (long)InMemoryLookupableTableSource$.MODULE$.RESOURCE_COUNTER().get());
        } else {
            Assert.assertEquals((long)0L, (long)TestValuesTableFactory.RESOURCE_COUNTER.get());
        }
    }

    private void createLookupTable(String tableName, List<Row> data, int lookupThreshold) {
        if (this.legacyTableSource) {
            TableSchema userSchema = TableSchema.builder().field("age", Types.INT()).field("id", Types.LONG()).field("name", Types.STRING()).build();
            InMemoryLookupableTableSource$.MODULE$.createTemporaryTable((TableEnvironment)this.tEnv(), true, data, userSchema, tableName, InMemoryLookupableTableSource$.MODULE$.createTemporaryTable$default$6());
        } else {
            String dataId = TestValuesTableFactory.registerData(data);
            String cacheOptions = this.enableCache ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |  '").append(LookupOptions.CACHE_TYPE.key()).append("' = '").append(LookupOptions.LookupCacheType.PARTIAL).append("',\n             |  '").append(LookupOptions.PARTIAL_CACHE_MAX_ROWS.key()).append("' = '").append(Long.MAX_VALUE).append("',\n             |").toString())).stripMargin() : "";
            String lookupThresholdOption = lookupThreshold > 0 ? new StringBuilder(28).append("'start-lookup-threshold'='").append(lookupThreshold).append("',").toString() : "";
            this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(453).append("\n                         |CREATE TABLE ").append(tableName).append(" (\n                         |  `age` INT,\n                         |  `id` BIGINT,\n                         |  `name` STRING\n                         |) WITH (\n                         |  ").append(cacheOptions).append("\n                         |  ").append(lookupThresholdOption).append("\n                         |  'connector' = 'values',\n                         |  'data-id' = '").append(dataId).append("',\n                         |  'async' = 'true'\n                         |)\n                         |").toString())).stripMargin());
        }
    }

    private int createLookupTable$default$3() {
        return -1;
    }

    private String getAsyncRetryLookupHint(String lookupTable, int maxAttempts) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(239).append("\n       |/*+ LOOKUP('table'='").append(lookupTable).append("', \n       | 'async'='true', \n       | 'time-out'='300s',\n       | 'retry-predicate'='lookup_miss',\n       | 'retry-strategy'='fixed_delay',\n       | 'fixed-delay'='1 ms',\n       | 'max-attempts'='").append(maxAttempts).append("')\n       |*/").toString())).stripMargin();
    }

    private void createScanTable(String tableName, List<Row> data) {
        String dataId = TestValuesTableFactory.registerData(data);
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(386).append("\n                       |CREATE TABLE ").append(tableName).append(" (\n                       |  `id` BIGINT,\n                       |  `len` INT,\n                       |  `content` STRING,\n                       |  `proctime` AS PROCTIME()\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(dataId).append("'\n                       |)\n                       |").toString())).stripMargin());
    }

    @Test
    public void testAsyncJoinTemporalTableOnMultiKeyFields() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT t1.id, t1.len, D.name\n        |FROM (select content, id, len, proctime FROM src AS T) t1\n        |JOIN user_table for system_time as of t1.proctime AS D\n        |ON t1.content = D.name AND t1.id = D.id\n      ")).stripMargin();
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTableWithPushDown() {
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND D.age > 20";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTableWithNonEqualFilter() {
        String sql = "SELECT T.id, T.len, T.content, D.name, D.age FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE T.len <= D.age";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark,22", "3,15,Fabian,Fabian,33"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncLeftJoinTemporalTableWithLocalPredicate() {
        String sql = "SELECT T.id, T.len, T.content, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND T.len > 1 AND D.age > 20 AND D.name = 'Fabian' WHERE T.id > 1";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,null,null", "3,15,Fabian,Fabian,33", "8,11,Hello world,null,null", "9,12,Hello world!,null,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTableOnMultiFields() {
        String sql = "SELECT T.id, T.len, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id AND T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTableOnMultiFieldsWithUdf() {
        this.tEnv().registerFunction("mod1", (ScalarFunction)UserDefinedFunctionTestUtils$TestMod$.MODULE$);
        this.tEnv().registerFunction("wrapper1", (ScalarFunction)UserDefinedFunctionTestUtils$TestWrapperUdf$.MODULE$);
        String sql = "SELECT T.id, T.len, wrapper1(D.name) as name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON mod1(T.id, 4) = D.id AND T.content = D.name";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian", "3,15,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTableWithUdfFilter() {
        this.tEnv().registerFunction("add", (ScalarFunction)new UserDefinedFunctionTestUtils.TestAddWithOpen());
        String sql = "SELECT T.id, T.len, T.content, D.name FROM src AS T JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id WHERE add(T.id, D.id) > 3 AND add(T.id, 2) > 3 AND add (D.id, 2) > 3";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        Assert.assertEquals((long)0L, (long)UserDefinedFunctionTestUtils$TestAddWithOpen$.MODULE$.aliveCounter().get());
    }

    @Test
    public void testAggAndAsyncLeftJoinTemporalTable() {
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().registerTable("t1", table1);
        String sql2 = "SELECT t1.id, D.name, D.age FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON t1.id = D.id";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Fabian,33", "8,null,null", "9,null,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAggAndAsyncLeftJoinWithTryResolveMode() {
        this.thrown().expectMessage("Required sync lookup function by planner");
        this.thrown().expect(TableException.class);
        this.tEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY, (Object)OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE);
        String sql1 = "SELECT max(id) as id, PROCTIME() as proctime FROM src AS T group by len";
        Table table1 = this.tEnv().sqlQuery(sql1);
        this.tEnv().registerTable("t1", table1);
        String sql2 = "SELECT t1.id, D.name, D.age FROM t1 LEFT JOIN user_table for system_time as of t1.proctime AS D ON t1.id = D.id";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql2)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Fabian,33", "8,null,null", "9,null,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncLeftJoinTemporalTable() {
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,11", "2,15,Jark,22", "3,15,Fabian,33", "8,11,null,null", "9,12,null,null"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testExceptionThrownFromAsyncJoinTemporalTable() {
        this.tEnv().registerFunction("errorFunc", (ScalarFunction)UserDefinedFunctionTestUtils$TestExceptionThrown$.MODULE$);
        String sql = "SELECT T.id, T.len, D.name, D.age FROM src AS T LEFT JOIN user_table for system_time as of T.proctime AS D ON T.id = D.id where errorFunc(D.name) > cast(1000 as decimal(10,4))";
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        try {
            this.env().execute();
        }
        catch (Throwable t) {
            Optional exception = ExceptionUtils.findThrowable((Throwable)t, NumberFormatException.class);
            Assert.assertTrue((boolean)exception.isPresent());
            Assert.assertTrue((boolean)((Throwable)exception.get()).getMessage().contains("Cannot parse"));
            return;
        }
        Assert.fail((String)"NumberFormatException is expected here!");
    }

    @Test
    public void testLookupCacheSharingAcrossSubtasks() {
        if (!this.enableCache) {
            return;
        }
        LookupCacheManager.keepCacheOnRelease((boolean)true);
        try {
            String sourceDdl = new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE T (\n           |  id BIGINT,\n           |  proc AS PROCTIME()\n           |) WITH (\n           |  'connector' = 'datagen',\n           |  'fields.id.kind' = 'sequence',\n           |  'fields.id.start' = '1',\n           |  'fields.id.end' = '6'\n           |)\n           |")).stripMargin();
            this.tEnv().executeSql(sourceDdl);
            String sql = new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT T.id, D.name, D.age FROM T \n          |LEFT JOIN user_table FOR SYSTEM_TIME AS OF T.proc AS D \n          |ON T.id = D.id\n          |")).stripMargin();
            TestingAppendSink sink = new TestingAppendSink();
            package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
            this.env().execute();
            Map managedCaches = LookupCacheManager.getInstance().getManagedCaches();
            Assertions.assertThat((int)managedCaches.size()).isEqualTo(1);
            LookupCache cache = ((LookupCacheManager.RefCountedCache)managedCaches.get(managedCaches.keySet().iterator().next())).getCache();
            Assertions.assertThat((long)cache.size()).isEqualTo(6L);
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(1L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(11), this.jl(1L), BinaryStringData.fromString((String)"Julian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(2L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(22), this.jl(2L), BinaryStringData.fromString((String)"Jark")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(3L)}))).containsExactlyInAnyOrder((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{this.ji(33), this.jl(3L), BinaryStringData.fromString((String)"Fabian")})});
            IterableAssert.assertThatIterable((Iterable)cache.getIfPresent((RowData)GenericRowData.of((Object[])new Object[]{this.jl(4L)}))).isEmpty();
        }
        finally {
            LookupCacheManager.getInstance().checkAllReleased();
            LookupCacheManager.getInstance().clear();
            LookupCacheManager.keepCacheOnRelease((boolean)false);
        }
    }

    public Integer ji(int i) {
        return new Integer(i);
    }

    public Long jl(long l) {
        return new Long(l);
    }

    @Test
    public void testAsyncJoinTemporalTableWithRetry() {
        String maxRetryTwiceHint = this.getAsyncRetryLookupHint("D", 2);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n                   |SELECT ").append(maxRetryTwiceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTableWithLookupThresholdWithInsufficientRetry() {
        String maxRetryOnceHint = this.getAsyncRetryLookupHint("D", 1);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n                   |SELECT ").append(maxRetryOnceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table_with_lookup_threshold3 for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = this.legacyTableSource ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"})) : (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testAsyncJoinTemporalTableWithLookupThresholdWithSufficientRetry() {
        String maxRetryTwiceHint = this.getAsyncRetryLookupHint("D", 2);
        TestingAppendSink sink = new TestingAppendSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(226).append("\n                   |SELECT ").append(maxRetryTwiceHint).append(" T.id, T.len, T.content, D.name FROM src AS T\n                   |JOIN user_table_with_lookup_threshold2 for system_time as of T.proctime AS D\n                   |ON T.id = D.id\n                   |").toString())).stripMargin())).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,12,Julian,Julian", "2,15,Hello,Jark", "3,15,Fabian,Fabian"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public AsyncLookupJoinITCase(boolean legacyTableSource, StreamingWithStateTestBase.StateBackendMode backend, boolean objectReuse, ExecutionConfigOptions.AsyncOutputMode asyncOutputMode, boolean enableCache) {
        this.legacyTableSource = legacyTableSource;
        this.objectReuse = objectReuse;
        this.asyncOutputMode = asyncOutputMode;
        this.enableCache = enableCache;
        super(backend);
        this.data = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToInteger((int)12), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToInteger((int)15), "Hello"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToInteger((int)15), "Fabian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)8L), BoxesRunTime.boxToInteger((int)11), "Hello world"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)9L), BoxesRunTime.boxToInteger((int)12), "Hello world!"})), (List)Nil$.MODULE$)))));
        this.userData = new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "Julian"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22), BoxesRunTime.boxToLong((long)2L), "Jark"})), (List)new .colon.colon((Object)this.rowOf((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)33), BoxesRunTime.boxToLong((long)3L), "Fabian"})), (List)Nil$.MODULE$)));
    }
}

