/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.typeutils.Types$;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestSinkUtil$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendRowDataSink;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.TestingAppendTableSink;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.MapDataSerializerTest;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001M\u0011!bQ1mG&#6)Y:f\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\u0012'R\u0014X-Y7j]\u001e$Vm\u001d;CCN,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u00039)8/Z:MK\u001e\f7-\u001f*poN,\u0012A\t\t\u0003G\u0015j\u0011\u0001\n\u0006\u0003/)I!A\n\u0013\u0003#1+w-Y2z%><(+Z:pkJ\u001cW\r\u000b\u0002 QA\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006E\u0001\u0006UVt\u0017\u000e^\u0005\u0003[)\u0012AAU;mK\")q\u0006\u0001C\u0001a\u0005\tC/Z:u'\u0016dWm\u0019;XSRDG*Z4bGf\u001c\u0015m\u001d;J]R$v\u000eR1uKR\t\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0003V]&$\bF\u0001\u00189!\tI\u0013(\u0003\u0002;U\t!A+Z:u\u0011\u0015a\u0004\u0001\"\u00011\u0003\r\"Xm\u001d;DCN$h*^7fe&\u001cGk\u001c\"p_2,\u0017M\\%o\u0007>tG-\u001b;j_:D#a\u000f\u001d\t\u000b}\u0002A\u0011\u0001\u0019\u00021Q,7\u000f^$f]\u0016\u0014\u0018n\u0019*po\u0006sGMU8x\t\u0006$\u0018\r\u000b\u0002?q!)!\t\u0001C\u0001a\u0005\tB/Z:u%><\u0018I\u001c3S_^$\u0015\r^1)\u0005\u0005C\u0004\"B#\u0001\t\u0003\u0001\u0014\u0001\u0006;fgR<UM\\3sS\u000e\u0014vn^!oIJ{w\u000f\u000b\u0002Eq!)\u0001\n\u0001C\u0001a\u0005iA/Z:u%><\u0018I\u001c3S_^D#a\u0012\u001d\t\u000b-\u0003A\u0011\u0001\u0019\u0002)Q,7\u000f\u001e)sS6LG/\u001b<f\u001b\u0006\u0004H+\u001f9fQ\tQ\u0005\bC\u0003O\u0001\u0011\u0005\u0001'A\fuKN$hj\u001c8Qe&l\u0017\u000e^5wK6\u000b\u0007\u000fV=qK\"\u0012Q\n\u000f\u0005\u0006#\u0002!\t\u0001M\u0001\u001ei\u0016\u001cHoU3mK\u000e$8\u000b^1s\rJ|WNT3ti\u0016$G+\u00192mK\"\u0012\u0001\u000b\u000f\u0005\u0006)\u0002!\t\u0001M\u0001\u0007i\u0016\u001cH/\u00138)\u0005MC\u0004\"B,\u0001\t\u0003\u0001\u0014!\u0003;fgRtu\u000e^%oQ\t1\u0006\bC\u0003[\u0001\u0011\u0005\u0001'\u0001\fuKN$Hj\u001c8h!J|'.Z2uS>tG*[:uQ\tI\u0006\bC\u0003^\u0001\u0011\u0005\u0001'\u0001\u0011uKN$8k\\;sG\u0016<\u0016\u000e\u001e5DkN$x.\\%oi\u0016\u0014h.\u00197ECR\f\u0007F\u0001/9\u0011\u0015\u0001\u0007\u0001\"\u00011\u0003E!Xm\u001d;TS6\u0004H.\u001a)s_*,7\r\u001e\u0015\u0003?bBQa\u0019\u0001\u0005\u0002A\n\u0011\u0003^3ti:+7\u000f^3e!J|'.Z2uQ\t\u0011\u0007\bC\u0003g\u0001\u0011\u0005\u0001'\u0001\u0014uKN$H)Z2j[\u0006d\u0017I\u001d:bs^KG\u000f\u001b#jM\u001a,'/\u001a8u!J,7-[:j_:D#!\u001a\u001d\t\u000b%\u0004A\u0011\u0001\u0019\u0002IQ,7\u000f\u001e#fG&l\u0017\r\\'ba^KG\u000f\u001b#jM\u001a,'/\u001a8u!J,7-[:j_:D#\u0001\u001b\u001d\t\u000b1\u0004A\u0011\u0001\u0019\u0002)Q,7\u000f^\"veJ,g\u000e^,bi\u0016\u0014X.\u0019:lQ\tY\u0007\bC\u0003p\u0001\u0011\u0005\u0001'\u0001\u0016uKN$8)\u001e:sK:$x+\u0019;fe6\f'o\u001b$pe:{gNU8xi&lW-\u0011;ue&\u0014W\u000f^3)\u00059D\u0004\"\u0002:\u0001\t\u0003\u0001\u0014A\n;fgR\u001c%/Z1uKR+W\u000e]8sCJLH+\u00192mK\u001a\u0013x.\u001c#fg\u000e\u0014\u0018\u000e\u001d;pe\"\u0012\u0011\u000f\u000f\u0005\u0006k\u0002!\t\u0001M\u0001\u000bi\u0016\u001cHoU3be\u000eD\u0007F\u0001;9\u0011\u0015A\b\u0001\"\u00011\u0003U!Xm\u001d;Nk2$\u0018\u000e\u001d7f\u0007>\fG.Z:dKND#a\u001e\u001d\t\u000bm\u0004A\u0011\u0001\u0019\u0002'Q,7\u000f^\"veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3)\u0005iD\u0004\"\u0002@\u0001\t\u0003\u0001\u0014\u0001\r;fgRd\u0015n[3XSRD7i\u001c8eSRLwN\\\"p]R\f\u0017N\\:E_V\u0014G.Z)v_R\fG/[8o\u001b\u0006\u00148\u000e\u000b\u0002~q\u0001")
public class CalcITCase
extends StreamingTestBase {
    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    @Test
    public void testSelectWithLegacyCastIntToDate() {
        this.tEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_LEGACY_CAST_BEHAVIOUR, (Object)ExecutionConfigOptions.LegacyCastBehaviour.ENABLED);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery("SELECT CASE WHEN true THEN CAST(2 AS INT) ELSE CAST('2017-12-11' AS DATE) END")).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1970-01-03", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCastNumericToBooleanInCondition() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT * FROM MyTableRow WHERE b = CAST(1 AS BOOLEAN)\n         | UNION ALL\n         | SELECT * FROM MyTableRow WHERE b = CAST(0 AS BOOLEAN)\n         |")).stripMargin();
        GenericRowData rowData1 = new GenericRowData(2);
        rowData1.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData1.setField(1, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        GenericRowData rowData2 = new GenericRowData(2);
        rowData2.setField(0, (Object)BoxesRunTime.boxToInteger((int)2));
        rowData2.setField(1, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        .colon.colon data = new .colon.colon((Object)rowData1, (List)new .colon.colon((Object)rowData2, (List)Nil$.MODULE$));
        InternalTypeInfo dataType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new BooleanType()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)dataType);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}));
        this.tEnv().registerTable("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new BooleanType()});
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(RowData.class));
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"+I(1,true)", (List)new .colon.colon((Object)"+I(2,false)", (List)Nil$.MODULE$));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGenericRowAndRowData() {
        String sqlQuery = "SELECT * FROM MyTableRow";
        GenericRowData rowData = new GenericRowData(3);
        rowData.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(1, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(2, (Object)BoxesRunTime.boxToLong((long)1L));
        .colon.colon data = new .colon.colon((Object)rowData, (List)Nil$.MODULE$);
        InternalTypeInfo tpe = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(RowData.class));
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"+I(1,1,1)", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowAndRowData() {
        String sqlQuery = "SELECT * FROM MyTableRow WHERE c < 3";
        .colon.colon data = new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Worlds", BoxesRunTime.boxToInteger((int)1)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Hiden", BoxesRunTime.boxToInteger((int)5)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello again", "Worlds", BoxesRunTime.boxToInteger((int)2)}), (List)Nil$.MODULE$)));
        RowTypeInfo tpe = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTableRow", t);
        InternalTypeInfo outputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{VarCharType.STRING_TYPE, VarCharType.STRING_TYPE, new IntType()});
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(RowData.class));
        TestingAppendRowDataSink sink = new TestingAppendRowDataSink((InternalTypeInfo<RowData>)outputType);
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"+I(Hello,Worlds,1)", (List)new .colon.colon((Object)"+I(Hello again,Worlds,2)", (List)Nil$.MODULE$));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testGenericRowAndRow() {
        String sqlQuery = "SELECT * FROM MyTableRow";
        GenericRowData rowData = new GenericRowData(3);
        rowData.setField(0, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(1, (Object)BoxesRunTime.boxToInteger((int)1));
        rowData.setField(2, (Object)BoxesRunTime.boxToLong((long)1L));
        .colon.colon data = new .colon.colon((Object)rowData, (List)Nil$.MODULE$);
        InternalTypeInfo tpe = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new BigIntType()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,1,1", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testRowAndRow() {
        String sqlQuery = "SELECT * FROM MyTableRow WHERE c < 3";
        .colon.colon data = new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Worlds", BoxesRunTime.boxToInteger((int)1)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello", "Hiden", BoxesRunTime.boxToInteger((int)5)}), (List)new .colon.colon((Object)Row.of((Object[])new Object[]{"Hello again", "Worlds", BoxesRunTime.boxToInteger((int)2)}), (List)Nil$.MODULE$)));
        RowTypeInfo tpe = new RowTypeInfo(new TypeInformation[]{Types$.MODULE$.STRING(), Types$.MODULE$.STRING(), Types$.MODULE$.INT()});
        DataStream ds = this.env().fromCollection((Seq)data, (TypeInformation)tpe);
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(ds).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream((TypeInformation)tpe);
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"Hello,Worlds,1", (List)new .colon.colon((Object)"Hello again,Worlds,2", (List)Nil$.MODULE$));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPrimitiveMapType() {
        String sqlQuery = "SELECT MAP[b, 30, 10, a] FROM MyTableRow";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$9 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"{1=30, 10=1}", (List)new .colon.colon((Object)"{2=30, 10=2}", (List)new .colon.colon((Object)"{2=30, 10=3}", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNonPrimitiveMapType() {
        String sqlQuery = "SELECT MAP[a, c] FROM MyTableRow";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$10 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTableRow", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"{1=Hi}", (List)new .colon.colon((Object)"{2=Hello}", (List)new .colon.colon((Object)"{3=Hello world}", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSelectStarFromNestedTable() {
        String sqlQuery = "SELECT * FROM MyTable";
        Table table = this.tEnv().fromDataStream(this.env().fromCollection((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)"0"), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)"1"), new Tuple2((Object)new Tuple2.mcII.sp(2, 2), (Object)"2")})), (TypeInformation)new CaseClassTypeInfo<Tuple2<Tuple2<Object, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Tuple2<Object, Object>, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>> unused = new ScalaCaseClassSerializer<Tuple2<Tuple2<Object, Object>, String>>(this, fieldSerializers){

                    public Tuple2<Tuple2<Object, Object>, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)((Tuple2)fields[0]), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$11 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_1")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "_2"))}));
        this.tEnv().registerTable("MyTable", table);
        Table result = this.tEnv().sqlQuery(sqlQuery);
        TestingAppendTableSink sink = TestSinkUtil$.MODULE$.configureSink(result, new TestingAppendTableSink());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("MySink", (TableSink)sink);
        table.executeInsert("MySink").await();
        .colon.colon expected = new .colon.colon((Object)"0,0,0", (List)new .colon.colon((Object)"1,1,1", (List)new .colon.colon((Object)"2,2,2", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testIn() {
        String sqlQuery = "SELECT * FROM MyTable WHERE b in (1,3,4,5,6)";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTable", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,1,Hi", "4,3,Hello world, how are you?", "5,3,I am fine.", "6,3,Luke Skywalker", "7,4,Comment#1", "8,4,Comment#2", "9,4,Comment#3", "10,4,Comment#4", "11,5,Comment#5", "12,5,Comment#6", "13,5,Comment#7", "14,5,Comment#8", "15,5,Comment#9", "16,6,Comment#10", "17,6,Comment#11", "18,6,Comment#12", "19,6,Comment#13", "20,6,Comment#14", "21,6,Comment#15"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNotIn() {
        String sqlQuery = "SELECT * FROM MyTable WHERE b not in (1,3,4,5,6)";
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.tupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().registerTable("MyTable", t);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,2,Hello", (List)new .colon.colon((Object)"3,2,Hello world", (List)Nil$.MODULE$));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLongProjectionList() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromCollection(TestData$.MODULE$.smallTupleData3(), (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.runtime.stream.sql.CalcITCase$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), org.apache.flink.table.api.package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}));
        this.tEnv().createTemporaryView("MyTable", t);
        String selectList = ((Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)200), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)i -> CalcITCase.$anonfun$testLongProjectionList$1(BoxesRunTime.unboxToInt((Object)i)), Stream$.MODULE$.canBuildFrom())).mkString(",");
        String sqlQuery = new StringBuilder(20).append("select ").append(selectList).append(" from MyTable").toString();
        DataStream result2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result2.addSink((SinkFunction)sink);
        this.env().execute();
        String expected = ((Stream)((Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)200), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$1 -> CalcITCase.$anonfun$testLongProjectionList$2(BoxesRunTime.unboxToInt((Object)x$1)), Stream$.MODULE$.canBuildFrom())).mkString(",");
        Assert.assertEquals((long)sink.getAppendResults().size(), (long)TestData$.MODULE$.smallTupleData3().size());
        sink.getAppendResults().foreach((Function1 & Serializable & scala.Serializable)result -> {
            CalcITCase.$anonfun$testLongProjectionList$3(expected, result);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSourceWithCustomInternalData() {
        GenericRowData rowData1 = new GenericRowData(2);
        rowData1.setField(0, (Object)BoxesRunTime.boxToLong((long)1L));
        rowData1.setField(1, (Object)CalcITCase.createMapData$1(1L, 2L));
        GenericRowData rowData2 = new GenericRowData(2);
        rowData2.setField(0, (Object)BoxesRunTime.boxToLong((long)2L));
        rowData2.setField(1, (Object)CalcITCase.createMapData$1(4L, 5L));
        .colon.colon values = new .colon.colon((Object)rowData1, (List)new .colon.colon((Object)rowData2, (List)Nil$.MODULE$));
        String myTableDataId = TestValuesTableFactory.registerRowData((Seq<RowData>)values);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(274).append("\n         |CREATE TABLE CustomTable (\n         |  a bigint,\n         |  b map<bigint, bigint>\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'register-internal-data' = 'true',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.env().getConfig().disableObjectReuse();
        this.tEnv().executeSql(ddl);
        TableResult result = this.tEnv().executeSql("select a, b from CustomTable");
        .colon.colon expected = new .colon.colon((Object)"1,{1=2}", (List)new .colon.colon((Object)"2,{4=5}", (List)Nil$.MODULE$));
        Buffer actual = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(CollectionUtil.iteratorToList((Iterator)result.collect())).map((Function1 & Serializable & scala.Serializable)r -> r.toString(), Buffer$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)actual.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSimpleProject() {
        String myTableDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.smallData3());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(233).append("\n         |CREATE TABLE SimpleTable (\n         |  a int,\n         |  b bigint,\n         |  c string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery("select a, c from SimpleTable")).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,Hi", (List)new .colon.colon((Object)"2,Hello", (List)new .colon.colon((Object)"3,Hello world", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testNestedProject() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HI", BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)111), BoxesRunTime.boxToBoolean((boolean)true)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hi", BoxesRunTime.boxToInteger((int)1111)})), "tom"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HELLO", BoxesRunTime.boxToInteger((int)22)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)222), BoxesRunTime.boxToBoolean((boolean)false)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello", BoxesRunTime.boxToInteger((int)2222)})), "mary"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"HELLO WORLD", BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)333), BoxesRunTime.boxToBoolean((boolean)true)}))})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello world", BoxesRunTime.boxToInteger((int)3333)})), "benji"}))}));
        String myTableDataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(448).append("\n         |CREATE TABLE NestedTable (\n         |  id int,\n         |  deepNested row<nested1 row<name string, `value` int>,\n         |                 nested2 row<num int, flag boolean>>,\n         |  nested row<name string, `value` int>,\n         |  name string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'nested-projection-supported' = 'false',\n         |  'data-id' = '").append(myTableDataId).append("',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |select id,\n        |    deepNested.nested1.name AS nestedName,\n        |    nested.`value` AS nestedValue,\n        |    deepNested.nested2.flag AS nestedFlag,\n        |    deepNested.nested2.num AS nestedNum\n        |from NestedTable\n        |")).stripMargin();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"1,HI,1111,true,111", (List)new .colon.colon((Object)"2,HELLO,2222,false,222", (List)new .colon.colon((Object)"3,HELLO WORLD,3333,true,333", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalArrayWithDifferentPrecision() {
        String sqlQuery = "SELECT ARRAY[0.12, 0.5, 0.99]";
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"[0.12, 0.50, 0.99]", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testDecimalMapWithDifferentPrecision() {
        String sqlQuery = "SELECT Map['a', 0.12, 'b', 0.5]";
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sqlQuery)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"{a=0.12, b=0.50}", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCurrentWatermark() {
        Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Instant.ofEpochSecond(644326662L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), Instant.ofEpochSecond(1622466300L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), Instant.ofEpochSecond(1622466300L)}))}));
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)rows);
        this.tEnv().getConfig().set("table.local-time-zone", "Europe/Berlin");
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n                       |CREATE TABLE T (\n                       |  id INT,\n                       |  ts TIMESTAMP_LTZ(3),\n                       |  WATERMARK FOR ts AS ts\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(tableId).append("',\n                       |  'bounded' = 'true'\n                       |)\n       ").toString())).stripMargin());
        List result1 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().from("T").select(new Expression[]{org.apache.flink.table.api.package$.MODULE$.$("id"), org.apache.flink.table.api.package$.MODULE$.currentWatermark(org.apache.flink.table.api.package$.MODULE$.$("ts"))}).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result1), (String)new StringOps(Predef$.MODULE$.augmentString("1,null\n        |2,1990-06-02T11:37:42Z\n        |3,2021-05-31T13:05:00Z\n        |")).stripMargin());
        List result2 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT id, CURRENT_WATERMARK(ts) FROM T").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result2), (String)new StringOps(Predef$.MODULE$.augmentString("1,null\n        |2,1990-06-02T11:37:42Z\n        |3,2021-05-31T13:05:00Z\n        |")).stripMargin());
        List result3 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT id FROM T WHERE CURRENT_WATERMARK(ts) IS NULL OR ts > CURRENT_WATERMARK(ts)\n          |")).stripMargin()).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result3), (String)new StringOps(Predef$.MODULE$.augmentString("1\n        |2\n        |")).stripMargin());
        List result4 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                  |SELECT\n                  |  TUMBLE_END(ts, INTERVAL '1' SECOND),\n                  |  CURRENT_WATERMARK(ts)\n                  |FROM T\n                  |GROUP BY\n                  |  TUMBLE(ts, INTERVAL '1' SECOND),\n                  |  CURRENT_WATERMARK(ts)\n                  |")).stripMargin()).execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result4), (String)new StringOps(Predef$.MODULE$.augmentString("1990-06-02T13:37:43,null\n        |2021-05-31T15:05:01,1990-06-02T11:37:42Z\n        |2021-05-31T15:05:01,2021-05-31T13:05:00Z\n        |")).stripMargin());
    }

    @Test
    public void testCurrentWatermarkForNonRowtimeAttribute() {
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(291).append("\n                       |CREATE TABLE T (\n                       |  ts TIMESTAMP_LTZ(3)\n                       |) WITH (\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(tableId).append("',\n                       |  'bounded' = 'true'\n                       |)\n       ").toString())).stripMargin());
        try {
            this.tEnv().sqlQuery("SELECT CURRENT_WATERMARK(ts) FROM T");
            Assert.fail((String)"CURRENT_WATERMARK for a non-rowtime attribute should have failed.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"SQL validation failed. Invalid function call:\nCURRENT_WATERMARK(TIMESTAMP_LTZ(3))", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTemporaryTableFromDescriptor() {
        Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)42)}))}));
        String tableId = TestValuesTableFactory.registerData((Seq<Row>)rows);
        this.tEnv().createTemporaryTable("T", TableDescriptor.forConnector((String)"values").schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build()).option("data-id", tableId).option("bounded", "true").build());
        List result = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT * FROM T").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result), (String)"42");
    }

    @Test
    public void testSearch() {
        DataStream stream = this.env().fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HC809", "H389N     "}), (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        this.tEnv().createTemporaryView("SimpleTable", stream, Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).build());
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT upper(f0) from SimpleTable where upper(f0) in (\n        |'CTNBSmokeSensor',\n        |'H388N',\n        |'H389N     ',\n        |'GHL-IRD',\n        |'JY-BF-20YN',\n        |'HC809',\n        |'DH-9908N-AEP',\n        |'DH-9908N'\n        |)\n        |")).stripMargin();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"HC809", (List)new .colon.colon((Object)"H389N     ", (List)Nil$.MODULE$));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMultipleCoalesces() {
        List result = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT COALESCE(1),\nCOALESCE(1, 2),\nCOALESCE(cast(NULL as int), 2),\nCOALESCE(1, cast(NULL as int)),\nCOALESCE(cast(NULL as int), cast(NULL as int), 3),\nCOALESCE(4, cast(NULL as int), cast(NULL as int), cast(NULL as int)),\nCOALESCE('1'),\nCOALESCE('1', '23'),\nCOALESCE(cast(NULL as varchar), '2'),\nCOALESCE('1', cast(NULL as varchar)),\nCOALESCE(cast(NULL as varchar), cast(NULL as varchar), '3'),\nCOALESCE('4', cast(NULL as varchar), cast(NULL as varchar), cast(NULL as varchar)),\nCOALESCE(1.0),\nCOALESCE(1.0, 2),\nCOALESCE(cast(NULL as double), 2.0),\nCOALESCE(cast(NULL as double), 2.0, 3.0),\nCOALESCE(2.0, cast(NULL as double), 3.0),\nCOALESCE(cast(NULL as double), cast(NULL as double))").execute().collect()).toList();
        TestBaseUtils.compareResultAsText((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)result), (String)"1,1,2,1,3,4,1,1,2,1,3,4,1.0,1.0,2.0,2.0,2.0,null");
    }

    @Test
    public void testCurrentDatabase() {
        List result1 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT CURRENT_DATABASE()").execute().collect()).toList();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tEnv().getCurrentDatabase()}))})), (Object)result1);
        ((Catalog)this.tEnv().getCatalog(this.tEnv().getCurrentCatalog()).get()).createDatabase("db1", (CatalogDatabase)new CatalogDatabaseImpl(new HashMap(), "db1"), false);
        this.tEnv().useDatabase("db1");
        List result2 = JavaConversions$.MODULE$.deprecated$u0020asScalaIterator((Iterator)this.tEnv().sqlQuery("SELECT CURRENT_DATABASE()").execute().collect()).toList();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tEnv().getCurrentDatabase()}))})), (Object)result2);
    }

    @Test
    public void testLikeWithConditionContainsDoubleQuotationMark() {
        Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)42), "abc"})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "cbc\"ddd"}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)rows);
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(207).append("\n         |CREATE TABLE MyTable (\n         |  a int,\n         |  b string\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'true'\n         |)\n       ").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(this.tEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                  | SELECT * FROM MyTable WHERE b LIKE '%\"%'\n                  |")).stripMargin())).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        .colon.colon expected = new .colon.colon((Object)"2,cbc\"ddd", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static final /* synthetic */ String $anonfun$testLongProjectionList$1(int i) {
        return new StringBuilder(67).append("CASE WHEN a IS NOT NULL AND a > ").append(i).append(" THEN 0 WHEN a < 0 THEN 0 ELSE ").append(i).append(" END").toString();
    }

    public static final /* synthetic */ String $anonfun$testLongProjectionList$2(int x$1) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
    }

    public static final /* synthetic */ void $anonfun$testLongProjectionList$3(String expected$1, String result) {
        Assert.assertEquals((Object)expected$1, (Object)result);
    }

    private static final MapData createMapData$1(long k, long v) {
        HashMap<Long, Long> mapData = new HashMap<Long, Long>();
        mapData.put(BoxesRunTime.boxToLong((long)k), BoxesRunTime.boxToLong((long)v));
        return new MapDataSerializerTest.CustomMapData(mapData);
    }
}

