/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingRetractSink;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001'\t)B*[7ji\u0006\u0014G.Z*pkJ\u001cW-\u0013+DCN,'BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\taa\u001d;sK\u0006l'BA\u0004\t\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0003\u0006\u0002\u000fAd\u0017M\u001c8fe*\u00111\u0002D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001b9\tQA\u001a7j].T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9b!A\u0003vi&d7/\u0003\u0002\u001a-\t\t2\u000b\u001e:fC6Lgn\u001a+fgR\u0014\u0015m]3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%\t!I\u0001\u0005I\u0006$\u0018-F\u0001#!\r\u0019\u0003FK\u0007\u0002I)\u0011QEJ\u0001\u000bG>dG.Z2uS>t'\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%\"#aA*fcB\u00111FL\u0007\u0002Y)\u0011Q\u0006D\u0001\u0006if\u0004Xm]\u0005\u0003_1\u00121AU8x\u0011\u0019\t\u0004\u0001)A\u0005E\u0005)A-\u0019;bA!)1\u0007\u0001C\u0001i\u0005)1/\u001a;vaR\tQ\u0007\u0005\u00027o5\ta%\u0003\u00029M\t!QK\\5uQ\t\u0011$\b\u0005\u0002<}5\tAH\u0003\u0002>!\u0005)!.\u001e8ji&\u0011q\b\u0010\u0002\u0007\u0005\u00164wN]3\t\u000b\u0005\u0003A\u0011\u0001\u001b\u0002\u0013Q,7\u000f\u001e'j[&$\bF\u0001!D!\tYD)\u0003\u0002Fy\t!A+Z:u\u0011\u00159\u0005\u0001\"\u00015\u0003I!Xm\u001d;PM\u001a\u001cX\r^!oI\u001a+Go\u00195)\u0005\u0019\u001b\u0005")
public class LimitableSourceITCase
extends StreamingTestBase {
    private final Seq<Row> data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"book", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)12)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"book", BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)19)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"book", BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)11)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fruit", BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)33)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fruit", BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)44)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fruit", BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)22)}))}));

    public Seq<Row> data() {
        return this.data;
    }

    @Before
    public void setup() {
        String dataId = TestValuesTableFactory.registerData(this.data());
        String ddl = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(243).append("\n         |CREATE TABLE Source (\n         |  category STRING,\n         |  shopId INT,\n         |  num INT\n         |) WITH (\n         |  'connector' = 'values',\n         |  'data-id' = '").append(dataId).append("',\n         |  'bounded' = 'false'\n         |)\n         |").toString())).stripMargin();
        this.tEnv().executeSql(ddl);
    }

    @Test
    public void testLimit() {
        String sql = "SELECT * FROM Source LIMIT 4";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"book,1,12", "book,2,19", "book,4,11", "fruit,4,33"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testOffsetAndFetch() {
        String sql = "SELECT * FROM Source LIMIT 4 OFFSET 2";
        TestingRetractSink sink = new TestingRetractSink();
        package$.MODULE$.tableConversions(this.tEnv().sqlQuery(sql)).toRetractStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink).setParallelism(1);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"book,4,11", "fruit,4,33", "fruit,3,44", "fruit,5,22"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getRetractResults().sorted((Ordering)Ordering.String$.MODULE$));
    }
}

