/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.bridge.scala.package$;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.planner.factories.TestValuesCatalog;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.stream.sql.PartitionableSourceITCase$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0001\u0003\u0001M\u0011\u0011\u0004U1si&$\u0018n\u001c8bE2,7k\\;sG\u0016LEkQ1tK*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003\u0019\u0019HO]3b[*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0019\tQ!\u001e;jYNL!!\u0007\f\u0003#M#(/Z1nS:<G+Z:u\u0005\u0006\u001cX\r\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003U\u0019x.\u001e:dK\u001a+Go\u00195QCJ$\u0018\u000e^5p]N,\u0012!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\b\u0005>|G.Z1o\u0011!!\u0003A!A!\u0002\u0013i\u0012AF:pkJ\u001cWMR3uG\"\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u0011\u0019\u0002!Q1A\u0005\u0002q\t\u0001#^:f\u0007\u0006$\u0018\r\\8h\r&dG/\u001a:\t\u0011!\u0002!\u0011!Q\u0001\nu\t\u0011#^:f\u0007\u0006$\u0018\r\\8h\r&dG/\u001a:!\u0011\u0015Q\u0003\u0001\"\u0001,\u0003\u0019a\u0014N\\5u}Q\u0019AFL\u0018\u0011\u00055\u0002Q\"\u0001\u0002\t\u000bmI\u0003\u0019A\u000f\t\u000b\u0019J\u0003\u0019A\u000f\t\u000bE\u0002A\u0011\t\u001a\u0002\r\t,gm\u001c:f)\u0005\u0019\u0004C\u0001\u00105\u0013\t)tD\u0001\u0003V]&$\bF\u0001\u00198!\tA4(D\u0001:\u0015\tQ\u0004#A\u0003kk:LG/\u0003\u0002=s\t1!)\u001a4pe\u0016DQA\u0010\u0001\u0005\u0002I\n!\u0005^3tiNKW\u000e\u001d7f!\u0006\u0014H/\u001b;j_:4\u0015.\u001a7e!J,G-[2bi\u0016\f\u0004FA\u001fA!\tA\u0014)\u0003\u0002Cs\t!A+Z:u\u0011\u0015!\u0005\u0001\"\u00013\u0003)\"Xm\u001d;QCJ$\u0018.\u00197QCJ$\u0018\u000e^5p]\u001aKW\r\u001c3Qe\u0016$\u0017nY1uKB+8\u000f\u001b#po:D#a\u0011!\t\u000b\u001d\u0003A\u0011\u0001\u001a\u00023Q,7\u000f^+oG>tg/\u001a:uK\u0012,\u0005\u0010\u001d:fgNLwN\u001c\u0015\u0003\r\u0002CQA\u0013\u0001\u0005\u0002I\n1\u0007^3tiB+8\u000f\u001b#po:\u0004\u0016M\u001d;ji&|g.\u00118e\r&dG/\u001a:t\u0007>tG/Y5o!\u0006\u0014H/\u001b;j_:\\U-_:)\u0005%\u0003\u0005\"B'\u0001\t\u0003\u0011\u0014a\u0012;fgR\u0004Vo\u001d5E_^t\u0007+\u0019:uSRLwN\\!oI\u001aKG\u000e^3sg\u000e{g\u000e^1j]B\u000b'\u000f^5uS>t7*Z=t/&$\bnU5oO2,\u0007K]8kK\u000e$\u0018n\u001c8)\u00051\u0003\u0005\u0006\u0002\u0001Q-^\u0003\"!\u0015+\u000e\u0003IS!aU\u001d\u0002\rI,hN\\3s\u0013\t)&KA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0003a\u0003\"!\u0017/\u000e\u0003iS!aW\u001d\u0002\u000fI,hN\\3sg&\u0011QL\u0017\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000b}\u0013\u0001\u0012\u00011\u00023A\u000b'\u000f^5uS>t\u0017M\u00197f'>,(oY3J)\u000e\u000b7/\u001a\t\u0003[\u00054Q!\u0001\u0002\t\u0002\t\u001c\"!Y2\u0011\u0005y!\u0017BA3 \u0005\u0019\te.\u001f*fM\")!&\u0019C\u0001OR\t\u0001\rC\u0003jC\u0012\u0005!.\u0001\u0006qCJ\fW.\u001a;feN$\u0012a\u001b\t\u0004YF\u001cX\"A7\u000b\u00059|\u0017\u0001B;uS2T\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007y!h/\u0003\u0002v?\t)\u0011I\u001d:bsB\u0011ad^\u0005\u0003q~\u00111!\u00118zQ\u0019A'0a\u0001\u0002\u0006A\u00111P \b\u00033rL!! .\u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0013\ry\u0018\u0011\u0001\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c(BA?[\u0003\u0011q\u0017-\\3\"\u0005\u0005\u001d\u0011aL:pkJ\u001cWMR3uG\"\u0004\u0016M\u001d;ji&|gn]\u001f|aud\u0003%^:f\u0007\u0006$\u0018\r\\8h\r&dG/\u001a:>wFj\b")
public class PartitionableSourceITCase
extends StreamingTestBase {
    private final boolean sourceFetchPartitions;
    private final boolean useCatalogFilter;

    @Parameterized.Parameters(name="sourceFetchPartitions={0}, useCatalogFilter={1}")
    public static Collection<Object[]> parameters() {
        return PartitionableSourceITCase$.MODULE$.parameters();
    }

    public boolean sourceFetchPartitions() {
        return this.sourceFetchPartitions;
    }

    public boolean useCatalogFilter() {
        return this.useCatalogFilter;
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.env().setParallelism(1);
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "ZhangSan", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "LiSi", "A", BoxesRunTime.boxToInteger((int)1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Jack", "A", BoxesRunTime.boxToInteger((int)2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Tom", "B", BoxesRunTime.boxToInteger((int)3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "Vivi", "C", BoxesRunTime.boxToInteger((int)1)}))}));
        String dataId = TestValuesTableFactory.registerData((Seq<Row>)data);
        String partitionableTable = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(401).append("\n         |CREATE TABLE PartitionableTable (\n         |  id int,\n         |  name string,\n         |  part1 string,\n         |  part2 int,\n         |  virtualField as part2 + 1)\n         |  partitioned by (part1, part2)\n         |  with (\n         |    'connector' = 'values',\n         |    'data-id' = '").append(dataId).append("',\n         |    'bounded' = 'true',\n         |    'partition-list' = '%s'\n         |)\n         |").toString())).stripMargin();
        String partitionableAndFilterableTable = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(468).append("\n         |CREATE TABLE PartitionableAndFilterableTable (\n         |  id int,\n         |  name string,\n         |  part1 string,\n         |  part2 int,\n         |  virtualField as part2 + 1)\n         |  partitioned by (part1, part2)\n         |  with (\n         |    'connector' = 'values',\n         |    'data-id' = '").append(dataId).append("',\n         |    'bounded' = 'true',\n         |    'partition-list' = '%s',\n         |    'filterable-fields' = 'id;part1;part2'\n         |)\n         |").toString())).stripMargin();
        if (this.sourceFetchPartitions()) {
            String partitions = "part1:A,part2:1;part1:A,part2:2;part1:B,part2:3;part1:C,part2:1";
            this.tEnv().executeSql(String.format(partitionableTable, partitions));
            this.tEnv().executeSql(String.format(partitionableAndFilterableTable, partitions));
        } else {
            TestValuesCatalog catalog = new TestValuesCatalog("test_catalog", "test_database", this.useCatalogFilter());
            this.tEnv().registerCatalog("test_catalog", (Catalog)catalog);
            this.tEnv().useCatalog("test_catalog");
            this.tEnv().executeSql(String.format(partitionableTable, ""));
            this.tEnv().executeSql(String.format(partitionableAndFilterableTable, ""));
            ObjectPath partitionableTablePath = ObjectPath.fromString((String)"test_database.PartitionableTable");
            ObjectPath partitionableAndFilterableTablePath = ObjectPath.fromString((String)"test_database.PartitionableAndFilterableTable");
            Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"A"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"2")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"B"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"3")})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part1"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"part2"), (Object)"1")}))}));
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionableSourceITCase.$anonfun$before$1(catalog, partitionableTablePath, partitionableAndFilterableTablePath, partition);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testSimplePartitionFieldPredicate1() {
        String query = "SELECT * FROM PartitionableTable WHERE part1 = 'A'";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,ZhangSan,A,1,2", "2,LiSi,A,1,2", "3,Jack,A,2,3"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPartialPartitionFieldPredicatePushDown() {
        String query = "SELECT * FROM PartitionableTable WHERE (id > 2 OR part1 = 'A') AND part2 > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Jack,A,2,3", "4,Tom,B,3,4"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testUnconvertedExpression() {
        String query = "select * from PartitionableTable where trim(part1) = 'A' and part2 > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Jack,A,2,3"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPushDownPartitionAndFiltersContainPartitionKeys() {
        String query = "SELECT * FROM PartitionableAndFilterableTable WHERE part1 = 'A' AND id > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2,LiSi,A,1,2", "3,Jack,A,2,3"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPushDownPartitionAndFiltersContainPartitionKeysWithSingleProjection() {
        String query = "SELECT name FROM PartitionableAndFilterableTable WHERE part1 = 'A' AND id > 1";
        DataStream result = package$.MODULE$.tableConversions(this.tEnv().sqlQuery(query)).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LiSi", "Jack"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$before$1(TestValuesCatalog catalog$1, ObjectPath partitionableTablePath$1, ObjectPath partitionableAndFilterableTablePath$1, scala.collection.immutable.Map partition) {
        CatalogPartitionSpec catalogPartitionSpec = new CatalogPartitionSpec(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)partition));
        CatalogPartitionImpl catalogPartition = new CatalogPartitionImpl(new HashMap(), "");
        catalog$1.createPartition(partitionableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
        catalog$1.createPartition(partitionableAndFilterableTablePath$1, catalogPartitionSpec, (CatalogPartition)catalogPartition, true);
    }

    public PartitionableSourceITCase(boolean sourceFetchPartitions, boolean useCatalogFilter) {
        this.sourceFetchPartitions = sourceFetchPartitions;
        this.useCatalogFilter = useCatalogFilter;
    }
}

