/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import org.apache.flink.table.api.bridge.scala.StreamStatementSet;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.TestNonDeterministicUdf;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001'\tyA+\u00192mKNKgn[%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0006kRLGn]\u0005\u00033Y\u0011!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0005[>$W\r\u0005\u0002\u001ec9\u0011ad\f\b\u0003?9r!\u0001I\u0017\u000f\u0005\u0005bcB\u0001\u0012,\u001d\t\u0019#F\u0004\u0002%S9\u0011Q\u0005K\u0007\u0002M)\u0011qEE\u0001\u0007yI|w\u000e\u001e \n\u0003EI!a\u0004\t\n\u00055q\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011qCB\u0005\u0003aY\t!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016L!AM\u001a\u0003!M#\u0018\r^3CC\u000e\\WM\u001c3N_\u0012,'B\u0001\u0019\u0017\u0011\u0015)\u0004\u0001\"\u00017\u0003\u0019a\u0014N\\5u}Q\u0011q'\u000f\t\u0003q\u0001i\u0011A\u0001\u0005\u00067Q\u0002\r\u0001\b\u0005\u0006w\u0001!\t\u0005P\u0001\u0007E\u00164wN]3\u0015\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012A!\u00168ji\")A\t\u0001C\u0001y\u0005IB/Z:u\u0015>Lg\u000eR5t_J$WM]\"iC:<W\rT8hQ\t\u0019e\t\u0005\u0002H\u00156\t\u0001J\u0003\u0002J!\u0005)!.\u001e8ji&\u00111\n\u0013\u0002\u0005)\u0016\u001cH\u000fC\u0003N\u0001\u0011\u0005A(A\ruKN$8+\u001b8l\t&\u001cxN\u001d3fe\u000eC\u0017M\\4f\u0019><\u0007F\u0001'G\u0011\u0015\u0001\u0006\u0001\"\u0001=\u0003\u0005\"Xm\u001d;TS:\\G)[:pe\u0012,'o\u00115b]\u001e,Gj\\4XSRD'+\u00198lQ\tye\tC\u0003T\u0001\u0011\u0005A(\u0001 uKN$8\t[1oO\u0016dwnZ*pkJ\u001cWmV5uQ:{g\u000eR3uKJl\u0017N\\5ti&\u001cg)\u001e8d'&t7nV5uQ\u0012KgMZ3sK:$\bk\u001b\u0015\u0003%\u001aCQA\u0016\u0001\u0005\u0002q\nA\u0003^3ti&s7/\u001a:u!\u0006\u0014HoQ8mk6t\u0007FA+G\u0011\u0015I\u0006\u0001\"\u0001=\u0003]!Xm\u001d;De\u0016\fG/\u001a+bE2,\u0017i]*fY\u0016\u001cG\u000f\u000b\u0002Y\r\")A\f\u0001C\u0001y\u0005)C/Z:u\u0007J,\u0017\r^3UC\ndW-Q:TK2,7\r^,ji\"|W\u000f^(qi&|gn\u001d\u0015\u00037\u001aCC\u0001A0fMB\u0011\u0001mY\u0007\u0002C*\u0011!\rS\u0001\u0007eVtg.\u001a:\n\u0005\u0011\f'a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0002OB\u0011\u0001n[\u0007\u0002S*\u0011!\u000eS\u0001\beVtg.\u001a:t\u0013\ta\u0017NA\u0007QCJ\fW.\u001a;fe&TX\r\u001a")
public class TableSinkITCase
extends StreamingWithStateTestBase {
    @Override
    public void before() {
        super.before();
        String srcDataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"jason", BoxesRunTime.boxToLong((long)1L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"jason", BoxesRunTime.boxToLong((long)1L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"jason", BoxesRunTime.boxToLong((long)1L)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"jason", BoxesRunTime.boxToLong((long)1L)}))}))));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(219).append("\n                       |CREATE TABLE src (person String, votes BIGINT) WITH(\n                       |  'connector' = 'values',\n                       |  'data-id' = '").append(srcDataId).append("'\n                       |)\n                       |").toString())).stripMargin());
        String awardDataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)5.2)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), BoxesRunTime.boxToDouble((double)12.1)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)3L), BoxesRunTime.boxToDouble((double)18.3)})), BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)4L), BoxesRunTime.boxToDouble((double)22.5)}))}))));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(183).append("\n         |CREATE TABLE award (votes BIGINT, prize DOUBLE, PRIMARY KEY(votes) NOT ENFORCED) WITH(\n         |  'connector' = 'values',\n         |  'data-id' = '").append(awardDataId).append("'\n         |)\n         |").toString())).stripMargin());
        String peopleDataId = TestValuesTableFactory.registerData((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{BatchTestBase$.MODULE$.row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"jason", BoxesRunTime.boxToInteger((int)22)}))}))));
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(181).append("\n         |CREATE TABLE people (person STRING, age INT, PRIMARY KEY(person) NOT ENFORCED) WITH(\n         |  'connector' = 'values',\n         |  'data-id' = '").append(peopleDataId).append("'\n         |)\n         |").toString())).stripMargin());
        String userDataId = TestValuesTableFactory.registerData(TestData$.MODULE$.userChangelog());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(511).append("\n                       |CREATE TABLE users (\n                       |  user_id STRING,\n                       |  user_name STRING,\n                       |  email STRING,\n                       |  balance DECIMAL(18,2),\n                       |  primary key (user_id) not enforced\n                       |) WITH (\n                       | 'connector' = 'values',\n                       | 'data-id' = '").append(userDataId).append("',\n                       | 'changelog-mode' = 'I,UA,UB,D'\n                       |)\n                       |").toString())).stripMargin());
    }

    @Test
    public void testJoinDisorderChangeLog() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE JoinDisorderChangeLog (\n                      |  person STRING, votes BIGINT, prize DOUBLE, age INT,\n                      |  PRIMARY KEY(person) NOT ENFORCED) WITH(\n                      |  'connector' = 'values',\n                      |  'sink-insert-only' = 'false'\n                      |)\n                      |")).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                    |INSERT INTO JoinDisorderChangeLog\n                    |SELECT T1.person, T1.sum_votes, T1.prize, T2.age FROM\n                    | (SELECT T.person, T.sum_votes, award.prize FROM\n                    |   (SELECT person, SUM(votes) AS sum_votes FROM src GROUP BY person) T,\n                    |   award\n                    |   WHERE T.sum_votes = award.votes) T1, people T2\n                    | WHERE T1.person = T2.person\n                    |")).stripMargin()).await();
        java.util.List<String> result = TestValuesTableFactory.getResults("JoinDisorderChangeLog");
        .colon.colon expected = new .colon.colon((Object)"+I[jason, 4, 22.5, 22]", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSinkDisorderChangeLog() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE SinkDisorderChangeLog (\n                      |  person STRING, votes BIGINT, prize DOUBLE,\n                      |  PRIMARY KEY(person) NOT ENFORCED) WITH(\n                      |  'connector' = 'values',\n                      |  'sink-insert-only' = 'false'\n                      |)\n                      |")).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                    |INSERT INTO SinkDisorderChangeLog\n                    |SELECT T.person, T.sum_votes, award.prize FROM\n                    |   (SELECT person, SUM(votes) AS sum_votes FROM src GROUP BY person) T, award\n                    |   WHERE T.sum_votes = award.votes\n                    |")).stripMargin()).await();
        java.util.List<String> result = TestValuesTableFactory.getResults("SinkDisorderChangeLog");
        .colon.colon expected = new .colon.colon((Object)"+I[jason, 4, 22.5]", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testSinkDisorderChangeLogWithRank() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE SinkRankChangeLog (\n                      |  person STRING, votes BIGINT,\n                      |  PRIMARY KEY(person) NOT ENFORCED) WITH(\n                      |  'connector' = 'values',\n                      |  'sink-insert-only' = 'false'\n                      |)\n                      |")).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n          |INSERT INTO SinkRankChangeLog\n          |SELECT person, sum_votes FROM\n          | (SELECT person, sum_votes,\n          |   ROW_NUMBER() OVER (PARTITION BY vote_section ORDER BY sum_votes DESC) AS rank_number\n          |   FROM (SELECT person, SUM(votes) AS sum_votes, SUM(votes) / 2 AS vote_section FROM src\n          |      GROUP BY person))\n          |   WHERE rank_number < 10\n          |")).stripMargin()).await();
        java.util.List<String> result = TestValuesTableFactory.getResults("SinkRankChangeLog");
        .colon.colon expected = new .colon.colon((Object)"+I[jason, 4]", (List)Nil$.MODULE$);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testChangelogSourceWithNonDeterministicFuncSinkWithDifferentPk() {
        this.tEnv().createTemporaryFunction("ndFunc", (UserDefinedFunction)new TestNonDeterministicUdf());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE sink_with_pk (\n                      |  user_id STRING,\n                      |  user_name STRING,\n                      |  email STRING,\n                      |  balance DECIMAL(18,2),\n                      |  PRIMARY KEY(email) NOT ENFORCED\n                      |) WITH(\n                      |  'connector' = 'values',\n                      |  'sink-insert-only' = 'false'\n                      |)\n                      |")).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                     |insert into sink_with_pk\n                     |select user_id, SPLIT_INDEX(ndFunc(user_name), '-', 0), email, balance\n                     |from users\n                     |")).stripMargin()).await();
        java.util.List<String> result = TestValuesTableFactory.getResults("sink_with_pk");
        .colon.colon expected = new .colon.colon((Object)"+I[user1, Tom, tom123@gmail.com, 8.10]", (List)new .colon.colon((Object)"+I[user3, Bailey, bailey@qq.com, 9.99]", (List)new .colon.colon((Object)"+I[user4, Tina, tina@gmail.com, 11.30]", (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
        java.util.List<String> rawResult = TestValuesTableFactory.getRawResults("sink_with_pk");
        List expectedRaw = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+I[user1, Tom, tom@gmail.com, 10.02]", "+I[user2, Jack, jack@hotmail.com, 71.20]", "-D[user1, Tom, tom@gmail.com, 10.02]", "+I[user1, Tom, tom123@gmail.com, 8.10]", "+I[user3, Bailey, bailey@gmail.com, 9.99]", "-D[user2, Jack, jack@hotmail.com, 71.20]", "+I[user4, Tina, tina@gmail.com, 11.30]", "-D[user3, Bailey, bailey@gmail.com, 9.99]", "+I[user3, Bailey, bailey@qq.com, 9.99]"}));
        Assert.assertEquals((Object)expectedRaw, (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rawResult).toList());
    }

    @Test
    public void testInsertPartColumn() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                      |CREATE TABLE zm_test (\n                      |  `person` String,\n                      |  `votes` BIGINT,\n                      |  `m1` MAP<STRING, BIGINT>,\n                      |  `m2` MAP<STRING NOT NULL, BIGINT>,\n                      |  `m3` MAP<STRING, BIGINT NOT NULL>,\n                      |  `m4` MAP<STRING NOT NULL, BIGINT NOT NULL>\n                      |) WITH (\n                      |  'connector' = 'values',\n                      |  'sink-insert-only' = 'true'\n                      |)\n                      |")).stripMargin());
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                    |insert into zm_test(`person`, `votes`)\n                    |  select\n                    |    `person`,\n                    |    `votes`\n                    |  from\n                    |    src\n                    |")).stripMargin()).await();
        java.util.List<String> result = TestValuesTableFactory.getResults("zm_test");
        .colon.colon expected = new .colon.colon((Object)"+I[jason, 1, null, null, null, null]", (List)new .colon.colon((Object)"+I[jason, 1, null, null, null, null]", (List)new .colon.colon((Object)"+I[jason, 1, null, null, null, null]", (List)new .colon.colon((Object)"+I[jason, 1, null, null, null, null]", (List)Nil$.MODULE$))));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(result).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCreateTableAsSelect() {
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                    |CREATE TABLE MyCtasTable\n                    | WITH (\n                    |   'connector' = 'values',\n                    |   'sink-insert-only' = 'true'\n                    |) AS\n                    |  SELECT\n                    |    `person`,\n                    |    `votes`\n                    |  FROM\n                    |    src\n                    |")).stripMargin()).await();
        java.util.List<String> actual = TestValuesTableFactory.getResults("MyCtasTable");
        .colon.colon expected = new .colon.colon((Object)"+I[jason, 1]", (List)new .colon.colon((Object)"+I[jason, 1]", (List)new .colon.colon((Object)"+I[jason, 1]", (List)new .colon.colon((Object)"+I[jason, 1]", (List)Nil$.MODULE$))));
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(actual).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
        StreamStatementSet statementSet = this.tEnv().createStatementSet();
        statementSet.addInsertSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyCtasTableUseStatement\n                                | WITH (\n                                |   'connector' = 'values',\n                                |   'sink-insert-only' = 'true'\n                                |) AS\n                                |  SELECT\n                                |    `person`,\n                                |    `votes`\n                                |  FROM\n                                |    src\n                                |")).stripMargin());
        statementSet.execute().await();
        java.util.List<String> actualUseStatement = TestValuesTableFactory.getResults("MyCtasTableUseStatement");
        Assertions.assertThat((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(actualUseStatement).sorted((Ordering)Ordering.String$.MODULE$)).isEqualTo(expected.sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testCreateTableAsSelectWithoutOptions() {
        Assertions.assertThatThrownBy(() -> this.tEnv().executeSql("CREATE TABLE MyCtasTable AS SELECT `person`, `votes` FROM src")).hasMessage("You should enable the checkpointing for sinking to managed table 'default_catalog.default_database.MyCtasTable', managed table relies on checkpoint to commit and the data is visible only after commit.");
    }

    public TableSinkITCase(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

