/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.expressions.utils.Func18$;
import org.apache.flink.table.planner.expressions.utils.FuncWithOpen;
import org.apache.flink.table.planner.expressions.utils.RichFunc2;
import org.apache.flink.table.planner.runtime.stream.table.CorrelateITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.runtime.utils.UserDefinedFunctionTestUtils$;
import org.apache.flink.table.planner.utils.PojoTableFunc;
import org.apache.flink.table.planner.utils.RF;
import org.apache.flink.table.planner.utils.RichTableFunc1;
import org.apache.flink.table.planner.utils.TableFunc0;
import org.apache.flink.table.planner.utils.TableFunc2;
import org.apache.flink.table.planner.utils.TableFunc3;
import org.apache.flink.table.planner.utils.TableFunc6;
import org.apache.flink.table.planner.utils.TableFunc7;
import org.apache.flink.table.planner.utils.VarArgsFunc0;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.types.Row;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001I\u0011qbQ8se\u0016d\u0017\r^3J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\tQ\u0001^1cY\u0016T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0007-Q!\u0001D\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\r\u0005)Q\u000f^5mg&\u0011\u0001$\u0006\u0002\u001b'R\u0014X-Y7j]\u001e<\u0016\u000e\u001e5Ti\u0006$X\rV3ti\n\u000b7/\u001a\u0005\t5\u0001\u0011\t\u0011)A\u00057\u0005!Qn\u001c3f!\ta\u0002G\u0004\u0002\u001e]9\u0011a$\f\b\u0003?1r!\u0001I\u0016\u000f\u0005\u0005RcB\u0001\u0012*\u001d\t\u0019\u0003F\u0004\u0002%O5\tQE\u0003\u0002'#\u00051AH]8pizJ\u0011\u0001E\u0005\u0003\u001d=I!\u0001D\u0007\n\u0005\rY\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0017\r%\u0011q&F\u0001\u001b'R\u0014X-Y7j]\u001e<\u0016\u000e\u001e5Ti\u0006$X\rV3ti\n\u000b7/Z\u0005\u0003cI\u0012\u0001c\u0015;bi\u0016\u0014\u0015mY6f]\u0012lu\u000eZ3\u000b\u0005=*\u0002\"\u0002\u001b\u0001\t\u0003)\u0014A\u0002\u001fj]&$h\b\u0006\u00027qA\u0011q\u0007A\u0007\u0002\u0005!)!d\ra\u00017!)!\b\u0001C\u0001w\u0005qQo]3t\u0019\u0016<\u0017mY=S_^\u001cX#\u0001\u001f\u0011\u0005uzT\"\u0001 \u000b\u0005YQ\u0011B\u0001!?\u0005EaUmZ1dsJ{wOU3t_V\u00148-\u001a\u0015\u0003s\t\u0003\"a\u0011$\u000e\u0003\u0011S!!R\b\u0002\u000b),h.\u001b;\n\u0005\u001d#%\u0001\u0002*vY\u0016DQ!\u0013\u0001\u0005\u0002)\u000bQ\u0002^3ti\u000e\u0013xn]:K_&tG#A&\u0011\u00051{U\"A'\u000b\u00039\u000bQa]2bY\u0006L!\u0001U'\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0011J\u0003\"aQ*\n\u0005Q#%\u0001\u0002+fgRDQA\u0016\u0001\u0005\u0002)\u000b!\u0005^3ti2+g\r^(vi\u0016\u0014(j\\5o/&$\bn\\;u!J,G-[2bi\u0016\u001c\bFA+S\u0011\u0015I\u0006\u0001\"\u0001K\u0003}!Xm\u001d;MK\u001a$x*\u001e;fe*{\u0017N\\,ji\"\u0004&/\u001a3jG\u0006$Xm\u001d\u0015\u00051J[F,\u0001\u0005fqB,7\r^3eG\u0005i\u0006C\u00010b\u001b\u0005y&B\u00011\u000b\u0003\r\t\u0007/[\u0005\u0003E~\u00131CV1mS\u0012\fG/[8o\u000bb\u001cW\r\u001d;j_:DQ\u0001\u001a\u0001\u0005\u0002)\u000ba\u0006^3tiV\u001bXM\u001d#fM&tW\r\u001a+bE2,g)\u001e8di&|gnV5uQN\u001b\u0017\r\\1s\rVt7\r^5p]\"\u00121M\u0015\u0005\u0006O\u0002!\tAS\u0001*i\u0016\u001cH/V:fe\u0012+g-\u001b8fIR\u000b'\r\\3Gk:\u001cG/[8o/&$\b\u000eU1sC6,G/\u001a:)\u0005\u0019\u0014\u0006\"\u00026\u0001\t\u0003Q\u0015!\u000f;fgR,6/\u001a:EK\u001aLg.\u001a3UC\ndWMR;oGRLwN\\,ji\",6/\u001a:EK\u001aLg.\u001a3TG\u0006d\u0017M\u001d$v]\u000e$\u0018n\u001c8)\u0005%\u0014\u0006\"B7\u0001\t\u0003Q\u0015A\n;fgR$\u0016M\u00197f\rVt7\r^5p]\u000e{gn\u001d;sk\u000e$xN],ji\"\u0004\u0016M]1ng\"\u0012AN\u0015\u0005\u0006a\u0002!\tAS\u0001'i\u0016\u001cH\u000fV1cY\u00164UO\\2uS>tw+\u001b;i-\u0006\u0014\u0018.\u00192mK\u0006\u0013x-^7f]R\u001c\bFA8S\u0011\u0015\u0019\b\u0001\"\u0001K\u0003-!Xm\u001d;S_^$\u0016\u0010]3)\u0005I\u0014\u0006\"\u0002<\u0001\t\u0003Q\u0015a\t;fgR$\u0016M\u00197f\rVt7\r^5p]\u000e{G\u000e\\3di>\u0014x\n]3o\u00072|7/\u001a\u0015\u0003kJCQ!\u001f\u0001\u0005\u0002)\u000ba\u0004^3tiR\u000b'\r\\3Gk:\u001cG/[8o\u0007>dG.Z2u_JLe.\u001b;)\u0005a\u0014\u0006\"\u0002?\u0001\t\u0003Q\u0015a\u0003;fgR4E.\u0019;NCBD#a\u001f*\t\u000b}\u0004A\u0011\u0001&\u0002#Q,7\u000f^'vYRL\u0007\u000f\\3Fm\u0006d7\u000f\u000b\u0002\u007f%\"9\u0011Q\u0001\u0001\u0005\n\u0005\u001d\u0011\u0001\u0003;fgR$\u0015\r^1\u0015\t\u0005%\u00111\b\t\u0007\u0003\u0017\t)\"!\u0007\u000e\u0005\u00055!b\u0001(\u0002\u0010)\u0019\u0001-!\u0005\u000b\u0007\u0005M1\"A\u0005tiJ,\u0017-\\5oO&!\u0011qCA\u0007\u0005)!\u0015\r^1TiJ,\u0017-\u001c\t\n\u0019\u0006m\u0011qDA\u0013\u0003WI1!!\bN\u0005\u0019!V\u000f\u001d7fgA\u0019A*!\t\n\u0007\u0005\rRJA\u0002J]R\u00042\u0001TA\u0014\u0013\r\tI#\u0014\u0002\u0005\u0019>tw\r\u0005\u0003\u0002.\u0005Ub\u0002BA\u0018\u0003c\u0001\"\u0001J'\n\u0007\u0005MR*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\tID\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003gi\u0005\u0002CA\u001f\u0003\u0007\u0001\r!a\u0010\u0002\u0007\u0015tg\u000f\u0005\u0003\u0002\f\u0005\u0005\u0013\u0002BA\"\u0003\u001b\u0011!d\u0015;sK\u0006lW\t_3dkRLwN\\#om&\u0014xN\\7f]RDs\u0001AA$\u0003'\n)\u0006\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\ti\u0005R\u0001\u0007eVtg.\u001a:\n\t\u0005E\u00131\n\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\t\t9\u0006\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\ti\u0006R\u0001\beVtg.\u001a:t\u0013\u0011\t\t'a\u0017\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0001")
public class CorrelateITCase
extends StreamingWithStateTestBase {
    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    @Test
    public void testCrossJoin() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        PojoTableFunc pojoFunc0 = new PojoTableFunc();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}).joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)pojoFunc0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "name")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "age"))})).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Jack#22,Jack,22", "Anna#44,Anna,44"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testLeftOuterJoinWithoutPredicates() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t.leftOuterJoinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nosharp,null,null", "Jack#22,Jack,22", "John#19,John,19", "Anna#44,Anna,44"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test(expected=ValidationException.class)
    public void testLeftOuterJoinWithPredicates() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t.leftOuterJoinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "l")})), package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l")))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "l"))})).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        String expected = "John#19,null,null\nJohn#22,null,null\nAnna44,null,null\nnosharp,null,null";
        Assert.assertEquals((Object)new StringOps(Predef$.MODULE$.augmentString(expected)).sorted((Ordering)Ordering.Char$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testUserDefinedTableFunctionWithScalarFunction() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).where(package$.MODULE$.ScalarFunctionCall((ScalarFunction)Func18$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.string2Literal("J")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Jack#22,Jack,22", "John#19,John,19"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testUserDefinedTableFunctionWithParameter() {
        RichTableFunc1 tableFunc1 = new RichTableFunc1();
        this.tEnv().registerFunction("RichTableFunc1", (TableFunction)tableFunc1, (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(this.env(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"word_separator"), (Object)" ")}))));
        Table result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.smallTupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.table.CorrelateITCase$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)tableFunc1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"3,Hello", "3,world"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testUserDefinedTableFunctionWithUserDefinedScalarFunction() {
        RichTableFunc1 tableFunc1 = new RichTableFunc1();
        RichFunc2 richFunc2 = new RichFunc2();
        this.tEnv().registerFunction("RichTableFunc1", (TableFunction)tableFunc1, (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        this.tEnv().registerFunction("RichFunc2", (ScalarFunction)richFunc2);
        UserDefinedFunctionTestUtils$.MODULE$.setJobParameters(this.env(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"word_separator"), (Object)"#"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string.value"), (Object)"test")}))));
        Table result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.failingDataSource(TestData$.MODULE$.smallTupleData3(), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.table.CorrelateITCase$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)tableFunc1).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.ScalarFunctionCall((ScalarFunction)richFunc2).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "s"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "s"))});
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,Hi", "1,test", "2,Hello", "2,test", "3,Hello world", "3,test"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testTableFunctionConstructorWithParams() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        Map config = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"value1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"value2")}));
        TableFunc3 func30 = new TableFunc3(null);
        TableFunc3 func31 = new TableFunc3("OneConf_");
        TableFunc3 func32 = new TableFunc3("TwoConf_", (Map<String, String>)config);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func30).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func31).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "f"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "g")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g"))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func32).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "h"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "i")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i"))})).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Anna#44,Anna,OneConf_Anna,TwoConf__key=key1_value=value1_Anna,44,44,44", "Anna#44,Anna,OneConf_Anna,TwoConf__key=key2_value=value2_Anna,44,44,44", "Jack#22,Jack,OneConf_Jack,TwoConf__key=key1_value=value1_Jack,22,22,22", "Jack#22,Jack,OneConf_Jack,TwoConf__key=key2_value=value2_Jack,22,22,22", "John#19,John,OneConf_John,TwoConf__key=key1_value=value1_John,19,19,19", "John#19,John,OneConf_John,TwoConf__key=key2_value=value2_John,19,19,19"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testTableFunctionWithVariableArguments() {
        VarArgsFunc0 varArgsFunc0 = new VarArgsFunc0();
        this.tEnv().registerFunction("VarArgsFunc0", (TableFunction)varArgsFunc0, (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        Table result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}).joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)varArgsFunc0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("1"), package$.MODULE$.string2Literal("2"), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})));
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Anna#44,1", "Anna#44,2", "Anna#44,Anna#44", "Jack#22,1", "Jack#22,2", "Jack#22,Jack#22", "John#19,1", "John#19,2", "John#19,John#19", "nosharp,1", "nosharp,2", "nosharp,nosharp"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        Table result1 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}).joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)varArgsFunc0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("1"), package$.MODULE$.string2Literal("2")})));
        TestingAppendSink sink1 = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result1).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink1);
        this.env().execute();
        MutableList expected1 = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Anna#44,1", "Anna#44,2", "Jack#22,1", "Jack#22,2", "John#19,1", "John#19,2", "nosharp,1", "nosharp,2"}));
        Assert.assertEquals((Object)expected1.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink1.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        Table result2 = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}).joinLateral(package$.MODULE$.TableFunctionCall((TableFunction)varArgsFunc0).apply((Seq)Nil$.MODULE$));
        TestingAppendSink sink2 = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result2).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink2);
        this.env().execute();
        Assert.assertTrue((boolean)sink2.getAppendResults().isEmpty());
    }

    @Test
    public void testRowType() {
        Row row = Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToBoolean((boolean)true), Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})});
        TypeInformation rowType = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT(), Types.BOOLEAN(), Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT(), Types.INT(), Types.INT()})});
        Table in = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{row, row}), rowType)).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc6 tableFunc = new TableFunc6();
        Table result = in.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)tableFunc).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "f0"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "f1"), SymbolLiteral.bootstrap("apply", "f2")}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2"))});
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,2,3,3", "1,2,3,3"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testTableFunctionCollectorOpenClose() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        FuncWithOpen func26 = new FuncWithOpen();
        this.tEnv().registerFunction("func26", (ScalarFunction)func26);
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).where(package$.MODULE$.ScalarFunctionCall((ScalarFunction)func26).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Jack#22,Jack,22", "John#19,John,19", "Anna#44,Anna,44"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testTableFunctionCollectorInit() {
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        TableFunc0 func0 = new TableFunc0();
        DataStream result = org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(t.joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.TableFunctionCall((TableFunction)func0).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{SymbolLiteral.bootstrap("apply", "e")}))).where(package$.MODULE$.WithOperations(package$.MODULE$.dateFormat(package$.MODULE$.currentTimestamp(), package$.MODULE$.string2Literal("yyyyMMdd"))).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e"))})).toAppendStream(TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        result.addSink((SinkFunction)sink);
        this.env().execute();
        Assert.assertTrue((boolean)sink.getAppendResults().isEmpty());
    }

    @Test
    public void testFlatMap() {
        Table ds = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.testData(this.env())).toTable(this.tEnv(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).flatMap(package$.MODULE$.call(TableFunc2.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))}).flatMap(package$.MODULE$.call(TableFunc2.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.concat(package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.string2Literal("#")}))}))).as("f0", new String[]{"f1"}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f1"))});
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(ds).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        MutableList expected = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Jack,4", "22,2", "John,4", "19,2", "Anna,4", "44,2"}));
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testMultipleEvals() {
        RF rf = new RF();
        TableFunc7 tf = new TableFunc7();
        Row row = Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToBoolean((boolean)true), Row.of((Object[])new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})});
        TypeInformation rowType = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT(), Types.BOOLEAN(), Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT(), Types.INT(), Types.INT()})});
        Table in = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(this.env().fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{row, row}), rowType)).toTable(this.tEnv()).as("a", new String[]{"b", "c"});
        Table result = in.select(new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.ScalarFunctionCall((ScalarFunction)rf).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "d"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0]))}).joinLateral(package$.MODULE$.WithOperations(package$.MODULE$.call((UserDefinedFunction)tf, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}))).as((Symbol)SymbolLiteral.bootstrap("apply", "e"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])));
        TestingAppendSink sink = new TestingAppendSink();
        org.apache.flink.table.api.bridge.scala.package$.MODULE$.tableConversions(result).toAppendStream(TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
    }

    private DataStream<Tuple3<Object, Object, String>> testData(StreamExecutionEnvironment env) {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToLong((long)1L), (Object)"Jack#22"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"John#19"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToLong((long)2L), (Object)"Anna#44"));
        data.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToLong((long)3L), (Object)"nosharp"));
        return env.fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.runtime.stream.table.CorrelateITCase$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    public CorrelateITCase(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

