/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.table;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.stream.table.TimeAttributesITCase$;
import org.apache.flink.table.planner.runtime.utils.StreamingWithStateTestBase;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.types.Row;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001%\t!B+[7f\u0003R$(/\u001b2vi\u0016\u001c\u0018\nV\"bg\u0016T!a\u0001\u0003\u0002\u000bQ\f'\r\\3\u000b\u0005\u00151\u0011AB:ue\u0016\fWN\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!aA\u0006\u000b\u00051i\u0011!\u00024mS:\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\u0011aCB\u0001\u0006kRLGn]\u0005\u00031U\u0011!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016D\u0001B\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0005[>$W\r\u0005\u0002\u001da9\u0011QD\f\b\u0003=5r!a\b\u0017\u000f\u0005\u0001ZcBA\u0011+\u001d\t\u0011\u0013F\u0004\u0002$Q9\u0011AeJ\u0007\u0002K)\u0011a%E\u0001\u0007yI|w\u000e\u001e \n\u0003AI!AD\b\n\u00051i\u0011BA\u0002\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011aCB\u0005\u0003_U\t!d\u0015;sK\u0006l\u0017N\\4XSRD7\u000b^1uKR+7\u000f\u001e\"bg\u0016L!!\r\u001a\u0003!M#\u0018\r^3CC\u000e\\WM\u001c3N_\u0012,'BA\u0018\u0016\u0011\u0015!\u0004\u0001\"\u00016\u0003\u0019a\u0014N\\5u}Q\u0011a\u0007\u000f\t\u0003o\u0001i\u0011A\u0001\u0005\u00065M\u0002\ra\u0007\u0005\u0006u\u0001!\taO\u0001/i\u0016\u001cH/T5tg&tw\rV5nK\u0006#HO]5ckR,G\u000b\u001b:poN\u001cuN\u001d:fGR,\u0005pY3qi&|g\u000eF\u0001=!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u0011)f.\u001b;)\u0005e\u001a\u0005C\u0001#H\u001b\u0005)%B\u0001$\u0010\u0003\u0015QWO\\5u\u0013\tAUI\u0001\u0003UKN$\b\"\u0002&\u0001\t\u0003Y\u0014\u0001\f;fgR$\u0016.\\3ti\u0006l\u0007/\u0011;ue&\u0014W\u000f^3t/&$\bnV1uKJl\u0017M]6TiJ\fG/Z4zQ\tI5\t\u000b\u0003\u0001\u001bN#\u0006C\u0001(R\u001b\u0005y%B\u0001)F\u0003\u0019\u0011XO\u001c8fe&\u0011!k\u0014\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\u0005)\u0006C\u0001,Z\u001b\u00059&B\u0001-F\u0003\u001d\u0011XO\u001c8feNL!AW,\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0001")
public class TimeAttributesITCase
extends StreamingWithStateTestBase {
    @Test
    public void testMissingTimeAttributeThrowsCorrectException() {
        .colon.colon data = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)"hello"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)"world"), (List)Nil$.MODULE$));
        DataStream stream = this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.runtime.stream.table.TimeAttributesITCase$$anon$3 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.tEnv().createTemporaryView("test", stream, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"event_time"}))).$((Seq)Nil$.MODULE$)).rowtime(), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data"}))).$((Seq)Nil$.MODULE$)}));
        Table result = this.tEnv().sqlQuery("SELECT * FROM test");
        TestingAppendSink sink = new TestingAppendSink();
        this.tEnv().toAppendStream(result, TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        try {
            this.env().execute();
            Assert.fail((String)"should fail");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)FlinkMatchers.containsMessage((String)"Rowtime timestamp is not defined. Please make sure that a proper TimestampAssigner is defined and the stream environment uses the EventTime time characteristic."));
        }
    }

    @Test
    public void testTimestampAttributesWithWatermarkStrategy() {
        .colon.colon data = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)Instant.now().toEpochMilli())), (Object)"hello"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)Instant.now().toEpochMilli())), (Object)"world"), (List)Nil$.MODULE$));
        DataStream stream = this.env().fromCollection((Seq)data, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, String>> unused = new ScalaCaseClassSerializer<Tuple2<Object, String>>(this, fieldSerializers){

                    public Tuple2<Object, String> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((String)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.runtime.stream.table.TimeAttributesITCase$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).assignTimestampsAndWatermarks(WatermarkStrategy.forBoundedOutOfOrderness((Duration)Duration.ofMinutes(5L)).withTimestampAssigner((SerializableTimestampAssigner)new SerializableTimestampAssigner<Tuple2<Object, String>>(null){

            public long extractTimestamp(Tuple2<Object, String> element, long recordTimestamp) {
                return element._1$mcJ$sp();
            }
        }));
        this.tEnv().createTemporaryView("test", stream, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"event_time"}))).$((Seq)Nil$.MODULE$)).rowtime(), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data"}))).$((Seq)Nil$.MODULE$)}));
        Table result = this.tEnv().sqlQuery("SELECT * FROM test");
        TestingAppendSink sink = new TestingAppendSink();
        this.tEnv().toAppendStream(result, TypeExtractor.createTypeInfo(Row.class)).addSink((SinkFunction)sink);
        this.env().execute();
        List formattedData = (List)data.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long timestamp = tuple2._1$mcJ$sp();
            String data = (String)tuple2._2();
            String formattedTimestamp = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC).toString();
            String string = new StringBuilder(1).append(formattedTimestamp).append(",").append(data).toString();
            return string;
        }, List$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$), (Object)formattedData.sorted((Ordering)Ordering.String$.MODULE$));
    }

    public TimeAttributesITCase(StreamingWithStateTestBase.StateBackendMode mode) {
        super(mode);
    }
}

