/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.UUID;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.io.CollectionInputFormat;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public final class BatchTableEnvUtil$ {
    public static BatchTableEnvUtil$ MODULE$;

    static {
        new BatchTableEnvUtil$();
    }

    public Expression[] parseFieldNames(String fields) {
        return fields != null ? (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields.replace(" ", "").split(","))).map((Function1 & Serializable & scala.Serializable)name -> package$.MODULE$.$(name), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class))) : null;
    }

    public <T> void registerCollection(TableEnvironment tEnv, String tableName, Iterable<T> data, TypeInformation<T> typeInfo, String fieldNames) {
        this.registerCollection(tEnv, tableName, data, typeInfo, (Option<Expression[]>)new Some((Object)this.parseFieldNames(fieldNames)), (Option<boolean[]>)None$.MODULE$, (Option<FlinkStatistic>)None$.MODULE$);
    }

    public <T> void registerCollection(TableEnvironment tEnv, String tableName, Iterable<T> data, TypeInformation<T> typeInfo, String fieldNames, boolean[] fieldNullables, Option<FlinkStatistic> statistic) {
        this.registerCollection(tEnv, tableName, data, typeInfo, (Option<Expression[]>)new Some((Object)this.parseFieldNames(fieldNames)), (Option<boolean[]>)Option$.MODULE$.apply((Object)fieldNullables), statistic);
    }

    public <T> void registerCollection(TableEnvironment tEnv, String tableName, Iterable<T> data, String fieldNames, ClassTag<T> evidence$1, TypeInformation<T> evidence$2) {
        TypeInformation typeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$2);
        this.registerCollection(tEnv, tableName, data, typeInfo, (Option<Expression[]>)new Some((Object)this.parseFieldNames(fieldNames)), (Option<boolean[]>)None$.MODULE$, (Option<FlinkStatistic>)None$.MODULE$);
    }

    public <T> void registerCollection(TableEnvironment tEnv, String tableName, Iterable<T> data, String fieldNames, boolean[] fieldNullables, Option<FlinkStatistic> statistic, ClassTag<T> evidence$3, TypeInformation<T> evidence$4) {
        TypeInformation typeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$4);
        this.registerCollection(tEnv, tableName, data, typeInfo, (Option<Expression[]>)new Some((Object)this.parseFieldNames(fieldNames)), (Option<boolean[]>)Option$.MODULE$.apply((Object)fieldNullables), statistic);
    }

    public <T> Table fromElements(TableEnvironment tEnv, Seq<T> data, ClassTag<T> evidence$5, TypeInformation<T> evidence$6) {
        Predef$.MODULE$.require(data != null, (Function0 & Serializable & scala.Serializable)() -> "Data must not be null.");
        TypeInformation typeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$6);
        return this.fromCollection(tEnv, (Iterable<T>)data, (ClassTag<T>)((ClassTag)Predef$.MODULE$.implicitly(evidence$5)), (TypeInformation<T>)typeInfo);
    }

    public <T> Table fromCollection(TableEnvironment tEnv, Iterable<T> data, ClassTag<T> evidence$7, TypeInformation<T> evidence$8) {
        TypeInformation typeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$8);
        return this.fromCollection(tEnv, null, data, typeInfo, null, (Option<FlinkStatistic>)None$.MODULE$);
    }

    public <T> Table fromCollection(TableEnvironment tEnv, Iterable<T> data, String fields, ClassTag<T> evidence$9, TypeInformation<T> evidence$10) {
        Predef$.MODULE$.require(data != null, (Function0 & Serializable & scala.Serializable)() -> "Data must not be null.");
        TypeInformation typeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$10);
        return this.fromCollection(tEnv, data, typeInfo, fields);
    }

    @VisibleForTesting
    public <T> void registerCollection(TableEnvironment tEnv, String tableName, Iterable<T> data, TypeInformation<T> typeInfo, Option<Expression[]> fields, Option<boolean[]> fieldNullables, Option<FlinkStatistic> statistic) {
        StreamExecutionEnvironment execEnv = this.getPlanner(tEnv).getExecEnv();
        DataStreamSource boundedStream = execEnv.createInput((InputFormat)new CollectionInputFormat(JavaConverters$.MODULE$.asJavaCollectionConverter(data).asJavaCollection(), typeInfo.createSerializer(execEnv.getConfig())), typeInfo);
        boundedStream.forceNonParallel();
        this.registerBoundedStreamInternal(tEnv, tableName, (DataStream<T>)boundedStream, fields, fieldNullables, statistic);
    }

    public <T> void registerBoundedStreamInternal(TableEnvironment tEnv, String name, DataStream<T> boundedStream, Option<Expression[]> fields, Option<boolean[]> fieldNullables, Option<FlinkStatistic> statistic) {
        ExecNodeUtil.makeLegacySourceTransformationsBounded((Transformation)boundedStream.getTransformation());
        TableTestUtil$.MODULE$.createTemporaryView(tEnv, name, boundedStream, fields, fieldNullables, statistic);
    }

    public <T> Table fromCollection(TableEnvironment tEnv, String tableName, Iterable<T> data, TypeInformation<T> typeInfo, Expression[] fields, Option<FlinkStatistic> statistic) {
        CollectionInputFormat.checkCollection((Collection)JavaConverters$.MODULE$.asJavaCollectionConverter(data).asJavaCollection(), (Class)typeInfo.getTypeClass());
        StreamExecutionEnvironment execEnv = this.getPlanner(tEnv).getExecEnv();
        DataStreamSource boundedStream = execEnv.createInput((InputFormat)new CollectionInputFormat(JavaConverters$.MODULE$.asJavaCollectionConverter(data).asJavaCollection(), typeInfo.createSerializer(execEnv.getConfig())), typeInfo);
        boundedStream.setParallelism(1);
        String name = tableName == null ? UUID.randomUUID().toString() : tableName;
        this.registerBoundedStreamInternal(tEnv, name, (DataStream<T>)boundedStream, (Option<Expression[]>)Option$.MODULE$.apply((Object)fields), (Option<boolean[]>)None$.MODULE$, statistic);
        return tEnv.from(new StringBuilder(2).append("`").append(name).append("`").toString());
    }

    public <T> Table fromCollection(TableEnvironment tEnv, Iterable<T> data, TypeInformation<T> typeInfo, String fields) {
        return this.fromCollection(tEnv, null, data, typeInfo, this.parseFieldNames(fields), (Option<FlinkStatistic>)None$.MODULE$);
    }

    private PlannerBase getPlanner(TableEnvironment tEnv) {
        return (PlannerBase)((TableEnvironmentImpl)tEnv).getPlanner();
    }

    private BatchTableEnvUtil$() {
        MODULE$ = this;
    }
}

