/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.operations.InternalDataStreamQueryOperation;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraphGenerator;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.typeutils.FieldInfoUtils;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.java8.JFunction0;

public final class TableTestUtil$ {
    public static TableTestUtil$ MODULE$;
    private final ObjectMapper objectMapper;
    private final EnvironmentSettings STREAM_SETTING;
    private final EnvironmentSettings BATCH_SETTING;

    static {
        new TableTestUtil$();
    }

    public Option<CatalogManager> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    private ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public EnvironmentSettings STREAM_SETTING() {
        return this.STREAM_SETTING;
    }

    public EnvironmentSettings BATCH_SETTING() {
        return this.BATCH_SETTING;
    }

    public RelNode toRelNode(Table table) {
        return ((PlannerBase)((TableEnvironmentImpl)((TableImpl)table).getTableEnvironment()).getPlanner()).createRelBuilder().queryOperation(table.getQueryOperation()).build();
    }

    public RelNode toRelNode(TableEnvironment tEnv, ModifyOperation modifyOperation) {
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)tEnv).getPlanner();
        return planner.translateToRel(modifyOperation);
    }

    public ExecNodeGraph toExecNodeGraph(TableEnvironment tEnv, String sqlQuery) {
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)tEnv).getPlanner();
        FlinkPhysicalRel optimizedRel = (FlinkPhysicalRel)planner.optimize(this.toRelNode(tEnv.sqlQuery(sqlQuery)));
        ExecNodeGraphGenerator generator = new ExecNodeGraphGenerator();
        return generator.generate(Collections.singletonList(optimizedRel), false);
    }

    public <T> void createTemporaryView(TableEnvironment tEnv, String name, DataStream<T> dataStream, Option<Expression[]> fields, Option<boolean[]> fieldNullables, Option<FlinkStatistic> statistic) {
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)tEnv).getPlanner();
        StreamExecutionEnvironment execEnv = planner.getExecEnv();
        TypeInformation streamType = dataStream.getType();
        FieldInfoUtils.TypeInfoSchema typeInfoSchema = (FieldInfoUtils.TypeInfoSchema)fields.map((Function1 & Serializable & scala.Serializable)f -> {
            void var3_3;
            FieldInfoUtils.TypeInfoSchema fieldsInfo = FieldInfoUtils.getFieldsInfo((TypeInformation)streamType, (Expression[])f);
            if (fieldsInfo.isRowtimeDefined() && execEnv.getStreamTimeCharacteristic() != TimeCharacteristic.EventTime) {
                throw new ValidationException(String.format("A rowtime attribute requires an EventTime time characteristic in stream environment. But is: %s", execEnv.getStreamTimeCharacteristic()));
            }
            return var3_3;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> FieldInfoUtils.getFieldsInfo((TypeInformation)streamType));
        int fieldCnt = typeInfoSchema.getFieldTypes().length;
        InternalDataStreamQueryOperation dataStreamQueryOperation = new InternalDataStreamQueryOperation(ObjectIdentifier.of((String)tEnv.getCurrentCatalog(), (String)tEnv.getCurrentDatabase(), (String)name), dataStream, typeInfoSchema.getIndices(), typeInfoSchema.toResolvedSchema(), (boolean[])fieldNullables.getOrElse((Function0 & Serializable & scala.Serializable)() -> (boolean[])Array$.MODULE$.fill(fieldCnt, (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true, ClassTag$.MODULE$.Boolean())), (FlinkStatistic)statistic.getOrElse((Function0 & Serializable & scala.Serializable)() -> FlinkStatistic$.MODULE$.UNKNOWN()));
        TableImpl table = ((TableEnvironmentImpl)tEnv).createTable((QueryOperation)dataStreamQueryOperation);
        tEnv.registerTable(name, (Table)table);
    }

    public <T> Option<Expression[]> createTemporaryView$default$4() {
        return None$.MODULE$;
    }

    public <T> Option<boolean[]> createTemporaryView$default$5() {
        return None$.MODULE$;
    }

    public <T> Option<FlinkStatistic> createTemporaryView$default$6() {
        return None$.MODULE$;
    }

    public String readFromResource(String path) {
        String basePath = this.getClass().getResource("/").getFile();
        String fullPath = path.startsWith("/") ? new StringBuilder(0).append(basePath).append(path.substring(1)).toString() : new StringBuilder(0).append(basePath).append(path).toString();
        BufferedSource source = Source$.MODULE$.fromFile(fullPath, Codec$.MODULE$.fallbackSystemCodec());
        String str = source.mkString();
        source.close();
        return str;
    }

    public Seq<String> readFromFile(String path) {
        File file = new File(path);
        return file.isDirectory() ? (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).foldLeft((Object)Seq$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(lines, p) -> (Seq)lines.$plus$plus(MODULE$.readFromFile(p.getAbsolutePath()), Seq$.MODULE$.canBuildFrom())) : (file.isHidden() ? (Seq)Seq$.MODULE$.empty() : JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(Files.readAllLines(Paths.get(file.toURI()))).toSeq());
    }

    public String getFormattedJson(String json) throws IOException {
        JsonParser parser = this.objectMapper().getFactory().createParser(json);
        JsonNode jsonNode = (JsonNode)parser.readValueAsTree();
        return jsonNode.toString();
    }

    public String getPrettyJson(String json) throws IOException {
        JsonParser parser = this.objectMapper().getFactory().createParser(json);
        JsonNode jsonNode = (JsonNode)parser.readValueAsTree();
        return jsonNode.toPrettyString();
    }

    public String replaceStageId(String s) {
        return s.replaceAll("\\r\\n", "\n").replaceAll("Stage \\d+", "");
    }

    public String replaceStreamNodeId(String s) {
        return s.replaceAll("\"id\"\\s*:\\s*\\d+", "\"id\" : ").trim();
    }

    public String replaceExecNodeId(String s) {
        return s.replaceAll("\"id\"\\s*:\\s*\\d+", "\"id\": 0").replaceAll("\"source\"\\s*:\\s*\\d+", "\"source\": 0").replaceAll("\"target\"\\s*:\\s*\\d+", "\"target\": 0");
    }

    public String replaceFlinkVersion(String s) {
        return s.replaceAll("\"flinkVersion\"\\s*:\\s*\"[\\w.-]*\"", "\"flinkVersion\": \"\"");
    }

    public String replaceNodeIdInOperator(String s) {
        return s.replaceAll("\"contents\"\\s*:\\s*\"\\[\\d+\\]:", "\"contents\" : \"[]:").replaceAll("(\"type\"\\s*:\\s*\".*?)\\[\\d+\\]", "$1[]");
    }

    private TableTestUtil$() {
        MODULE$ = this;
        this.objectMapper = JacksonMapperFactory.createObjectMapper();
        this.STREAM_SETTING = EnvironmentSettings.newInstance().inStreamingMode().build();
        this.BATCH_SETTING = EnvironmentSettings.newInstance().inBatchMode().build();
    }
}

