/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream.compact;

import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.filesystem.stream.AbstractStreamingWriter;
import org.apache.flink.table.filesystem.stream.compact.CompactMessages;

public class CompactFileWriter<T>
extends AbstractStreamingWriter<T, CompactMessages.CoordinatorInput> {
    private static final long serialVersionUID = 1L;

    public CompactFileWriter(long bucketCheckInterval, StreamingFileSink.BucketsBuilder<T, String, ? extends StreamingFileSink.BucketsBuilder<T, String, ?>> bucketsBuilder) {
        super(bucketCheckInterval, bucketsBuilder);
    }

    @Override
    protected void partitionCreated(String partition) {
    }

    @Override
    protected void partitionInactive(String partition) {
    }

    @Override
    protected void onPartFileOpened(String partition, Path newPath) {
        this.output.collect((Object)new StreamRecord((Object)new CompactMessages.InputFile(partition, newPath)));
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        super.notifyCheckpointComplete(checkpointId);
        this.output.collect((Object)new StreamRecord((Object)new CompactMessages.EndCheckpoint(checkpointId, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getNumberOfParallelSubtasks())));
    }
}

