/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.networking;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.networking.NetworkFailureHandler;
import org.apache.flink.shaded.testutils.org.jboss.netty.bootstrap.ServerBootstrap;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.Channel;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.ChannelPipeline;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.ChannelPipelineFactory;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.Channels;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkFailuresProxy
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkFailuresProxy.class);
    private static final String NETWORK_FAILURE_HANDLER_NAME = "network_failure_handler";
    private final Executor executor = Executors.newCachedThreadPool();
    private final ServerBootstrap serverBootstrap;
    private final Channel channel;
    private final AtomicBoolean blocked = new AtomicBoolean();
    private final Set<NetworkFailureHandler> networkFailureHandlers = Collections.newSetFromMap(new ConcurrentHashMap());

    public NetworkFailuresProxy(int localPort, final String remoteHost, final int remotePort) {
        this.serverBootstrap = new ServerBootstrap(new NioServerSocketChannelFactory(this.executor, this.executor));
        final NioClientSocketChannelFactory channelFactory = new NioClientSocketChannelFactory(this.executor, this.executor);
        this.serverBootstrap.setOption("child.tcpNoDelay", true);
        this.serverBootstrap.setOption("child.keepAlive", true);
        this.serverBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                Set set = NetworkFailuresProxy.this.networkFailureHandlers;
                synchronized (set) {
                    NetworkFailureHandler failureHandler = new NetworkFailureHandler(NetworkFailuresProxy.this.blocked, networkFailureHandler -> NetworkFailuresProxy.this.networkFailureHandlers.remove(networkFailureHandler), channelFactory, remoteHost, remotePort);
                    NetworkFailuresProxy.this.networkFailureHandlers.add(failureHandler);
                    pipeline.addLast(NetworkFailuresProxy.NETWORK_FAILURE_HANDLER_NAME, failureHandler);
                }
                return pipeline;
            }
        });
        this.channel = this.serverBootstrap.bind(new InetSocketAddress(localPort));
        LOG.info("Proxying [*:{}] to [{}:{}]", new Object[]{this.getLocalPort(), remoteHost, remotePort});
    }

    public int getLocalPort() {
        return ((InetSocketAddress)this.channel.getLocalAddress()).getPort();
    }

    public void blockTraffic() {
        this.setTrafficBlocked(true);
    }

    public void unblockTraffic() {
        this.setTrafficBlocked(false);
    }

    @Override
    public void close() throws Exception {
        this.channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTrafficBlocked(boolean blocked) {
        this.blocked.set(blocked);
        if (blocked) {
            Set<NetworkFailureHandler> set = this.networkFailureHandlers;
            synchronized (set) {
                for (NetworkFailureHandler failureHandler : this.networkFailureHandlers) {
                    failureHandler.closeConnections();
                }
            }
        }
    }
}

