/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.test.util.MiniClusterPipelineExecutorServiceLoader;
import org.apache.flink.util.Preconditions;

public class TestEnvironment
extends ExecutionEnvironment {
    private final MiniCluster miniCluster;
    private TestEnvironment lastEnv;

    public TestEnvironment(MiniCluster miniCluster, int parallelism, boolean isObjectReuseEnabled, Collection<Path> jarFiles, Collection<URL> classPaths) {
        super((PipelineExecutorServiceLoader)new MiniClusterPipelineExecutorServiceLoader(miniCluster), MiniClusterPipelineExecutorServiceLoader.createConfiguration(jarFiles, classPaths), null);
        this.miniCluster = (MiniCluster)Preconditions.checkNotNull((Object)miniCluster);
        this.setParallelism(parallelism);
        if (isObjectReuseEnabled) {
            this.getConfig().enableObjectReuse();
        } else {
            this.getConfig().disableObjectReuse();
        }
        this.lastEnv = null;
    }

    public TestEnvironment(MiniCluster executor, int parallelism, boolean isObjectReuseEnabled) {
        this(executor, parallelism, isObjectReuseEnabled, Collections.emptyList(), Collections.emptyList());
    }

    public JobExecutionResult getLastJobExecutionResult() {
        if (this.lastEnv == null) {
            return this.lastJobExecutionResult;
        }
        return this.lastEnv.getLastJobExecutionResult();
    }

    public void setAsContext() {
        ExecutionEnvironmentFactory factory = () -> {
            this.lastEnv = new TestEnvironment(this.miniCluster, this.getParallelism(), this.getConfig().isObjectReuseEnabled());
            return this.lastEnv;
        };
        TestEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    public static void setAsContext(MiniCluster miniCluster, int parallelism, Collection<Path> jarFiles, Collection<URL> classPaths) {
        ExecutionEnvironmentFactory factory = () -> new TestEnvironment(miniCluster, parallelism, false, jarFiles, classPaths);
        TestEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    public static void setAsContext(MiniCluster miniCluster, int parallelism) {
        TestEnvironment.setAsContext(miniCluster, parallelism, Collections.emptyList(), Collections.emptyList());
    }

    public static void unsetAsContext() {
        TestEnvironment.resetContextEnvironment();
    }
}

