/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.datastream;

import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DataStreamCollectTestITCase
extends TestLogger {
    @Test
    public void testStreamingCollect() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(4);
        DataStreamSource stream = env.fromElements((Object[])new Integer[]{1, 2, 3});
        try (CloseableIterator iterator = stream.executeAndCollect();){
            List results = CollectionUtil.iteratorToList((Iterator)iterator);
            Assert.assertThat((String)"Failed to collect all data from the stream", (Object)results, (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}));
        }
    }

    @Test
    public void testStreamingCollectAndLimit() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(4);
        DataStreamSource stream = env.fromElements((Object[])new Integer[]{1, 2, 3, 4, 5});
        List results = stream.executeAndCollect(1);
        Assert.assertEquals((String)"Failed to collect the correct number of elements from the stream", (long)1L, (long)results.size());
    }

    @Test
    public void testBoundedCollect() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(4);
        DataStreamSource stream = env.fromElements((Object[])new Integer[]{1, 2, 3});
        Configuration config = new Configuration();
        config.set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
        env.configure((ReadableConfig)config, DataStreamCollectTestITCase.class.getClassLoader());
        try (CloseableIterator iterator = stream.executeAndCollect();){
            List results = CollectionUtil.iteratorToList((Iterator)iterator);
            Assert.assertThat((String)"Failed to collect all data from the stream", (Object)results, (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}));
        }
    }

    @Test
    public void testBoundedCollectAndLimit() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(4);
        Configuration config = new Configuration();
        config.set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
        env.configure((ReadableConfig)config, DataStreamCollectTestITCase.class.getClassLoader());
        DataStreamSource stream = env.fromElements((Object[])new Integer[]{1, 2, 3, 4, 5});
        List results = stream.executeAndCollect(1);
        Assert.assertEquals((String)"Failed to collect the correct number of elements from the stream", (long)1L, (long)results.size());
    }
}

