/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class JobMasterITCase
extends TestLogger {
    @Test
    public void testRejectionOfEmptyJobGraphs() throws Exception {
        MiniCluster miniCluster = new MiniCluster(new MiniClusterConfiguration.Builder().setNumTaskManagers(1).setNumSlotsPerTaskManager(1).build());
        miniCluster.start();
        JobGraph jobGraph = JobGraphTestUtils.emptyJobGraph();
        try {
            miniCluster.submitJob(jobGraph).get();
            Assert.fail((String)"Expect failure");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)FlinkMatchers.containsMessage((String)"The given job is empty"));
        }
        miniCluster.close();
    }

    @Test
    public void testJobManagerInitializationExceptionsAreForwardedToTheUser() {
        LocalStreamEnvironment see = StreamExecutionEnvironment.createLocalEnvironment();
        FailOnInitializationSource mySource = new FailOnInitializationSource();
        DataStreamSource stream = see.fromSource((Source)mySource, WatermarkStrategy.noWatermarks(), "MySourceName");
        stream.addSink((SinkFunction)new DiscardingSink());
        try {
            see.execute();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)FlinkMatchers.containsMessage((String)"Context was not yet initialized"));
        }
    }

    private static class MockSplit
    implements SourceSplit {
        private MockSplit() {
        }

        public String splitId() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FailOnInitializationSource
    implements Source<String, MockSplit, Void> {
        private FailOnInitializationSource() {
        }

        public Boundedness getBoundedness() {
            return Boundedness.CONTINUOUS_UNBOUNDED;
        }

        public SourceReader<String, MockSplit> createReader(SourceReaderContext readerContext) throws Exception {
            throw new UnsupportedOperationException();
        }

        public SplitEnumerator<MockSplit, Void> createEnumerator(SplitEnumeratorContext<MockSplit> enumContext) throws Exception {
            throw new RuntimeException();
        }

        public SplitEnumerator<MockSplit, Void> restoreEnumerator(SplitEnumeratorContext<MockSplit> enumContext, Void checkpoint) throws Exception {
            throw new UnsupportedOperationException();
        }

        public SimpleVersionedSerializer<MockSplit> getSplitSerializer() {
            throw new RuntimeException();
        }

        public SimpleVersionedSerializer<Void> getEnumeratorCheckpointSerializer() {
            throw new UnsupportedOperationException();
        }
    }
}

