/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.checkpointing.utils;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.IntCounter;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.contrib.streaming.state.RocksDBStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.test.checkpointing.utils.MigrationTestUtils;
import org.apache.flink.test.checkpointing.utils.SavepointMigrationTestBase;
import org.apache.flink.testutils.migration.MigrationVersion;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StatefulJobSavepointMigrationITCase
extends SavepointMigrationTestBase {
    private static final int NUM_SOURCE_ELEMENTS = 4;
    private final ExecutionMode executionMode = ExecutionMode.VERIFY_SAVEPOINT;
    private final MigrationVersion testMigrateVersion;
    private final String testStateBackend;

    @Parameterized.Parameters(name="Migrate Savepoint / Backend: {0}")
    public static Collection<Tuple2<MigrationVersion, String>> parameters() {
        return Arrays.asList(Tuple2.of((Object)MigrationVersion.v1_4, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_4, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_5, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_5, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_6, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_6, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_7, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_7, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_8, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_8, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_9, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_9, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_10, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_10, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_11, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_11, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_12, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_12, (Object)"rocksdb"));
    }

    public StatefulJobSavepointMigrationITCase(Tuple2<MigrationVersion, String> testMigrateVersionAndBackend) throws Exception {
        this.testMigrateVersion = (MigrationVersion)testMigrateVersionAndBackend.f0;
        this.testStateBackend = (String)testMigrateVersionAndBackend.f1;
    }

    @Test
    public void testSavepoint() throws Exception {
        AbstractStreamOperator timelyOperator;
        RichFlatMapFunction flatMap;
        CheckpointedFunction parallelSource;
        CheckpointedFunction nonParallelSource;
        int parallelism = 4;
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setRestartStrategy(RestartStrategies.noRestart());
        switch (this.testStateBackend) {
            case "rocksdb": {
                env.setStateBackend((StateBackend)new RocksDBStateBackend((AbstractStateBackend)new MemoryStateBackend()));
                break;
            }
            case "jobmanager": {
                env.setStateBackend((StateBackend)new MemoryStateBackend());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        env.enableCheckpointing(500L);
        env.setParallelism(4);
        env.setMaxParallelism(4);
        if (this.executionMode == ExecutionMode.PERFORM_SAVEPOINT) {
            nonParallelSource = new MigrationTestUtils.CheckpointingNonParallelSourceWithListState(4);
            parallelSource = new MigrationTestUtils.CheckpointingParallelSourceWithUnionListState(4);
            flatMap = new CheckpointingKeyedStateFlatMap();
            timelyOperator = new CheckpointingTimelyStatefulOperator();
        } else if (this.executionMode == ExecutionMode.VERIFY_SAVEPOINT) {
            nonParallelSource = new MigrationTestUtils.CheckingNonParallelSourceWithListState(4);
            parallelSource = new MigrationTestUtils.CheckingParallelSourceWithUnionListState(4);
            flatMap = new CheckingKeyedStateFlatMap();
            timelyOperator = new CheckingTimelyStatefulOperator();
        } else {
            throw new IllegalStateException("Unknown ExecutionMode " + (Object)((Object)this.executionMode));
        }
        env.addSource((SourceFunction)nonParallelSource).uid("CheckpointingSource1").keyBy(new int[]{0}).flatMap((FlatMapFunction)flatMap).startNewChain().uid("CheckpointingKeyedStateFlatMap1").keyBy(new int[]{0}).transform("timely_stateful_operator", new TypeHint<Tuple2<Long, Long>>(){}.getTypeInfo(), (OneInputStreamOperator)timelyOperator).uid("CheckpointingTimelyStatefulOperator1").addSink(new MigrationTestUtils.AccumulatorCountingSink());
        env.addSource((SourceFunction)parallelSource).uid("CheckpointingSource2").keyBy(new int[]{0}).flatMap((FlatMapFunction)flatMap).startNewChain().uid("CheckpointingKeyedStateFlatMap2").keyBy(new int[]{0}).transform("timely_stateful_operator", new TypeHint<Tuple2<Long, Long>>(){}.getTypeInfo(), (OneInputStreamOperator)timelyOperator).uid("CheckpointingTimelyStatefulOperator2").addSink(new MigrationTestUtils.AccumulatorCountingSink());
        if (this.executionMode == ExecutionMode.PERFORM_SAVEPOINT) {
            this.executeAndSavepoint(env, "src/test/resources/" + this.getSavepointPath(this.testMigrateVersion, this.testStateBackend), new Tuple2((Object)MigrationTestUtils.AccumulatorCountingSink.NUM_ELEMENTS_ACCUMULATOR, (Object)8));
        } else {
            this.restoreAndExecute(env, StatefulJobSavepointMigrationITCase.getResourceFilename(this.getSavepointPath(this.testMigrateVersion, this.testStateBackend)), new Tuple2((Object)MigrationTestUtils.CheckingNonParallelSourceWithListState.SUCCESSFUL_RESTORE_CHECK_ACCUMULATOR, (Object)1), new Tuple2((Object)MigrationTestUtils.CheckingParallelSourceWithUnionListState.SUCCESSFUL_RESTORE_CHECK_ACCUMULATOR, (Object)4), new Tuple2((Object)CheckingKeyedStateFlatMap.SUCCESSFUL_RESTORE_CHECK_ACCUMULATOR, (Object)8), new Tuple2((Object)CheckingTimelyStatefulOperator.SUCCESSFUL_PROCESS_CHECK_ACCUMULATOR, (Object)8), new Tuple2((Object)CheckingTimelyStatefulOperator.SUCCESSFUL_EVENT_TIME_CHECK_ACCUMULATOR, (Object)8), new Tuple2((Object)CheckingTimelyStatefulOperator.SUCCESSFUL_PROCESSING_TIME_CHECK_ACCUMULATOR, (Object)8), new Tuple2((Object)MigrationTestUtils.AccumulatorCountingSink.NUM_ELEMENTS_ACCUMULATOR, (Object)8));
        }
    }

    private String getSavepointPath(MigrationVersion savepointVersion, String backendType) {
        switch (backendType) {
            case "rocksdb": {
                return "new-stateful-udf-migration-itcase-flink" + savepointVersion + "-rocksdb-savepoint";
            }
            case "jobmanager": {
                return "new-stateful-udf-migration-itcase-flink" + savepointVersion + "-savepoint";
            }
        }
        throw new UnsupportedOperationException();
    }

    private static class CheckingTimelyStatefulOperator
    extends AbstractStreamOperator<Tuple2<Long, Long>>
    implements OneInputStreamOperator<Tuple2<Long, Long>, Tuple2<Long, Long>>,
    Triggerable<Long, Long> {
        private static final long serialVersionUID = 1L;
        static final String SUCCESSFUL_PROCESS_CHECK_ACCUMULATOR = CheckingTimelyStatefulOperator.class + "_PROCESS_CHECKS";
        static final String SUCCESSFUL_EVENT_TIME_CHECK_ACCUMULATOR = CheckingTimelyStatefulOperator.class + "_ET_CHECKS";
        static final String SUCCESSFUL_PROCESSING_TIME_CHECK_ACCUMULATOR = CheckingTimelyStatefulOperator.class + "_PT_CHECKS";
        private final ValueStateDescriptor<Long> stateDescriptor = new ValueStateDescriptor("state-name", (TypeSerializer)LongSerializer.INSTANCE);

        private CheckingTimelyStatefulOperator() {
        }

        public void open() throws Exception {
            super.open();
            this.getInternalTimerService("timer", (TypeSerializer)LongSerializer.INSTANCE, this);
            this.getRuntimeContext().addAccumulator(SUCCESSFUL_PROCESS_CHECK_ACCUMULATOR, (Accumulator)new IntCounter());
            this.getRuntimeContext().addAccumulator(SUCCESSFUL_EVENT_TIME_CHECK_ACCUMULATOR, (Accumulator)new IntCounter());
            this.getRuntimeContext().addAccumulator(SUCCESSFUL_PROCESSING_TIME_CHECK_ACCUMULATOR, (Accumulator)new IntCounter());
        }

        public void processElement(StreamRecord<Tuple2<Long, Long>> element) throws Exception {
            ValueState state = (ValueState)this.getKeyedStateBackend().getPartitionedState(((Tuple2)element.getValue()).f0, (TypeSerializer)LongSerializer.INSTANCE, this.stateDescriptor);
            Assert.assertEquals((Object)state.value(), (Object)((Tuple2)element.getValue()).f1);
            this.getRuntimeContext().getAccumulator(SUCCESSFUL_PROCESS_CHECK_ACCUMULATOR).add((Object)1);
            this.output.collect(element);
        }

        public void onEventTime(InternalTimer<Long, Long> timer) throws Exception {
            ValueState state = (ValueState)this.getKeyedStateBackend().getPartitionedState(timer.getNamespace(), (TypeSerializer)LongSerializer.INSTANCE, this.stateDescriptor);
            Assert.assertEquals((Object)state.value(), (Object)timer.getNamespace());
            this.getRuntimeContext().getAccumulator(SUCCESSFUL_EVENT_TIME_CHECK_ACCUMULATOR).add((Object)1);
        }

        public void onProcessingTime(InternalTimer<Long, Long> timer) throws Exception {
            ValueState state = (ValueState)this.getKeyedStateBackend().getPartitionedState(timer.getNamespace(), (TypeSerializer)LongSerializer.INSTANCE, this.stateDescriptor);
            Assert.assertEquals((Object)state.value(), (Object)timer.getNamespace());
            this.getRuntimeContext().getAccumulator(SUCCESSFUL_PROCESSING_TIME_CHECK_ACCUMULATOR).add((Object)1);
        }
    }

    private static class CheckpointingTimelyStatefulOperator
    extends AbstractStreamOperator<Tuple2<Long, Long>>
    implements OneInputStreamOperator<Tuple2<Long, Long>, Tuple2<Long, Long>>,
    Triggerable<Long, Long> {
        private static final long serialVersionUID = 1L;
        private final ValueStateDescriptor<Long> stateDescriptor = new ValueStateDescriptor("state-name", (TypeSerializer)LongSerializer.INSTANCE);
        private transient InternalTimerService<Long> timerService;

        private CheckpointingTimelyStatefulOperator() {
        }

        public void open() throws Exception {
            super.open();
            this.timerService = this.getInternalTimerService("timer", (TypeSerializer)LongSerializer.INSTANCE, this);
        }

        public void processElement(StreamRecord<Tuple2<Long, Long>> element) throws Exception {
            ValueState state = (ValueState)this.getKeyedStateBackend().getPartitionedState(((Tuple2)element.getValue()).f0, (TypeSerializer)LongSerializer.INSTANCE, this.stateDescriptor);
            state.update(((Tuple2)element.getValue()).f1);
            this.timerService.registerEventTimeTimer(((Tuple2)element.getValue()).f0, this.timerService.currentWatermark() + 10L);
            this.timerService.registerProcessingTimeTimer(((Tuple2)element.getValue()).f0, this.timerService.currentProcessingTime() + 30000L);
            this.output.collect(element);
        }

        public void onEventTime(InternalTimer<Long, Long> timer) {
        }

        public void onProcessingTime(InternalTimer<Long, Long> timer) {
        }

        public void processWatermark(Watermark mark) {
            this.output.emitWatermark(mark);
        }
    }

    private static class CheckingKeyedStateFlatMap
    extends RichFlatMapFunction<Tuple2<Long, Long>, Tuple2<Long, Long>> {
        private static final long serialVersionUID = 1L;
        static final String SUCCESSFUL_RESTORE_CHECK_ACCUMULATOR = CheckingKeyedStateFlatMap.class + "_RESTORE_CHECK";
        private final ValueStateDescriptor<Long> stateDescriptor = new ValueStateDescriptor("state-name", (TypeSerializer)LongSerializer.INSTANCE);

        private CheckingKeyedStateFlatMap() {
        }

        public void open(Configuration parameters) throws Exception {
            super.open(parameters);
            this.getRuntimeContext().addAccumulator(SUCCESSFUL_RESTORE_CHECK_ACCUMULATOR, (Accumulator)new IntCounter());
        }

        public void flatMap(Tuple2<Long, Long> value, Collector<Tuple2<Long, Long>> out) throws Exception {
            out.collect(value);
            ValueState state = this.getRuntimeContext().getState(this.stateDescriptor);
            if (state == null) {
                throw new RuntimeException("Missing key value state for " + value);
            }
            Assert.assertEquals((Object)value.f1, (Object)state.value());
            this.getRuntimeContext().getAccumulator(SUCCESSFUL_RESTORE_CHECK_ACCUMULATOR).add((Object)1);
        }
    }

    private static class CheckpointingKeyedStateFlatMap
    extends RichFlatMapFunction<Tuple2<Long, Long>, Tuple2<Long, Long>> {
        private static final long serialVersionUID = 1L;
        private final ValueStateDescriptor<Long> stateDescriptor = new ValueStateDescriptor("state-name", (TypeSerializer)LongSerializer.INSTANCE);

        private CheckpointingKeyedStateFlatMap() {
        }

        public void flatMap(Tuple2<Long, Long> value, Collector<Tuple2<Long, Long>> out) throws Exception {
            out.collect(value);
            this.getRuntimeContext().getState(this.stateDescriptor).update(value.f1);
        }
    }

    public static enum ExecutionMode {
        PERFORM_SAVEPOINT,
        VERIFY_SAVEPOINT;

    }
}

