/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.broadcastvars;

import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.Collector;

public class BroadcastBranchingITCase
extends JavaProgramTestBase {
    private static final String RESULT = "(2,112)\n";

    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(1);
        DataSource sc1 = env.fromElements((Object[])new Tuple4[]{new Tuple4((Object)"1", (Object)61, (Object)6, (Object)29), new Tuple4((Object)"2", (Object)7, (Object)13, (Object)10), new Tuple4((Object)"3", (Object)8, (Object)13, (Object)27)});
        DataSource sc2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)"1", (Object)5), new Tuple2((Object)"2", (Object)3), new Tuple2((Object)"3", (Object)6)});
        DataSource sc3 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)"1", (Object)2), new Tuple2((Object)"2", (Object)3), new Tuple2((Object)"3", (Object)7)});
        JoinOperator.EquiJoin jn1 = sc2.join((DataSet)sc3).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new Jn1());
        JoinOperator.EquiJoin jn2 = jn1.join((DataSet)sc1).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new Jn2());
        FlatMapOperator mp1 = jn1.flatMap((FlatMapFunction)new Mp1());
        List result = ((FlatMapOperator)jn2.flatMap((FlatMapFunction)new Mp2()).withBroadcastSet((DataSet)mp1, "z")).collect();
        TestBaseUtils.compareResultAsText((List)result, (String)RESULT);
    }

    private static class Mp2
    extends RichFlatMapFunction<Tuple2<String, Integer>, Tuple2<String, Integer>> {
        private static final long serialVersionUID = 1L;
        private Collection<Tuple2<String, Integer>> zs;

        private Mp2() {
        }

        public void open(Configuration parameters) throws Exception {
            this.zs = this.getRuntimeContext().getBroadcastVariable("z");
        }

        public void flatMap(Tuple2<String, Integer> value, Collector<Tuple2<String, Integer>> out) throws Exception {
            int p = (Integer)value.f1;
            for (Tuple2<String, Integer> z : this.zs) {
                if (!((String)z.f0).equals(value.f0) || p % (Integer)z.f1 == 0) continue;
                out.collect(value);
            }
        }
    }

    private static class Mp1
    implements FlatMapFunction<Tuple3<String, Integer, Integer>, Tuple2<String, Integer>> {
        private static final long serialVersionUID = 1L;

        private Mp1() {
        }

        public void flatMap(Tuple3<String, Integer, Integer> value, Collector<Tuple2<String, Integer>> out) throws Exception {
            if (((Integer)value.f1).compareTo((Integer)value.f2) == 0) {
                out.collect((Object)new Tuple2(value.f0, value.f1));
            }
        }
    }

    private static class Jn2
    implements JoinFunction<Tuple3<String, Integer, Integer>, Tuple4<String, Integer, Integer, Integer>, Tuple2<String, Integer>> {
        private static final long serialVersionUID = 1L;

        private Jn2() {
        }

        private static int p(int x, int a, int b, int c) {
            return a * x * x + b * x + c;
        }

        public Tuple2<String, Integer> join(Tuple3<String, Integer, Integer> first, Tuple4<String, Integer, Integer, Integer> second) throws Exception {
            int x = (Integer)first.f1;
            int y = (Integer)first.f2;
            int a = (Integer)second.f1;
            int b = (Integer)second.f2;
            int c = (Integer)second.f3;
            int pX = Jn2.p(x, a, b, c);
            int pY = Jn2.p(y, a, b, c);
            int min = Math.min(pX, pY);
            return new Tuple2(first.f0, (Object)min);
        }
    }

    private static class Jn1
    implements JoinFunction<Tuple2<String, Integer>, Tuple2<String, Integer>, Tuple3<String, Integer, Integer>> {
        private static final long serialVersionUID = 1L;

        private Jn1() {
        }

        public Tuple3<String, Integer, Integer> join(Tuple2<String, Integer> first, Tuple2<String, Integer> second) throws Exception {
            return new Tuple3(first.f0, first.f1, second.f1);
        }
    }
}

