/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.util.List;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.test.operators.util.CollectionDataSets;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.Collector;
import org.junit.Test;

public class TypeHintITCase
extends AbstractTestBase {
    @Test
    public void testIdentityMapWithMissingTypesAndStringTypeHint() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
        SingleInputUdfOperator identityMapDs = ds.map(new Mapper()).returns((TypeHint)new TypeHint<Tuple3<Integer, Long, String>>(){});
        List result = identityMapDs.collect();
        String expectedResult = "(2,2,Hello)\n(3,2,Hello world)\n(1,1,Hi)\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    @Test
    public void testIdentityMapWithMissingTypesAndTypeInformationTypeHint() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
        SingleInputUdfOperator identityMapDs = ds.map(new Mapper()).returns((TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}));
        List result = identityMapDs.collect();
        String expectedResult = "(2,2,Hello)\n(3,2,Hello world)\n(1,1,Hi)\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    @Test
    public void testFlatMapWithClassTypeHint() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
        SingleInputUdfOperator identityMapDs = ds.flatMap(new FlatMapper()).returns(Integer.class);
        List result = identityMapDs.collect();
        String expectedResult = "2\n3\n1\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    @Test
    public void testJoinWithTypeInformationTypeHint() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
        DataSet<Tuple3<Integer, Long, String>> ds2 = CollectionDataSets.getSmall3TupleDataSet(env);
        TwoInputUdfOperator resultDs = ds1.join(ds2).where(new int[]{0}).equalTo(new int[]{0}).with(new Joiner()).returns((TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        List result = resultDs.collect();
        String expectedResult = "2\n3\n1\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    @Test
    public void testFlatJoinWithTypeInformationTypeHint() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
        DataSet<Tuple3<Integer, Long, String>> ds2 = CollectionDataSets.getSmall3TupleDataSet(env);
        TwoInputUdfOperator resultDs = ds1.join(ds2).where(new int[]{0}).equalTo(new int[]{0}).with(new FlatJoiner()).returns((TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        List result = resultDs.collect();
        String expectedResult = "2\n3\n1\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    @Test
    public void testUnsortedGroupReduceWithTypeInformationTypeHint() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
        SingleInputUdfOperator resultDs = ds.groupBy(new int[]{0}).reduceGroup(new GroupReducer()).returns((TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        List result = resultDs.collect();
        String expectedResult = "2\n3\n1\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    @Test
    public void testSortedGroupReduceWithTypeInformationTypeHint() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
        SingleInputUdfOperator resultDs = ds.groupBy(new int[]{0}).sortGroup(0, Order.ASCENDING).reduceGroup(new GroupReducer()).returns((TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        List result = resultDs.collect();
        String expectedResult = "2\n3\n1\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    @Test
    public void testCombineGroupWithTypeInformationTypeHint() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
        SingleInputUdfOperator resultDs = ds.groupBy(new int[]{0}).combineGroup(new GroupCombiner()).returns((TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        List result = resultDs.collect();
        String expectedResult = "2\n3\n1\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    @Test
    public void testCoGroupWithTypeInformationTypeHint() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
        DataSet<Tuple3<Integer, Long, String>> ds2 = CollectionDataSets.getSmall3TupleDataSet(env);
        TwoInputUdfOperator resultDs = ds1.coGroup(ds2).where(new int[]{0}).equalTo(new int[]{0}).with(new CoGrouper()).returns((TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        List result = resultDs.collect();
        String expectedResult = "2\n3\n1\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    private static class CoGrouper<IN1, IN2, OUT>
    implements CoGroupFunction<IN1, IN2, OUT> {
        private static final long serialVersionUID = 1L;

        private CoGrouper() {
        }

        public void coGroup(Iterable<IN1> first, Iterable<IN2> second, Collector<OUT> out) throws Exception {
            out.collect(((Tuple3)first.iterator().next()).f0);
        }
    }

    private static class GroupCombiner<IN, OUT>
    implements GroupCombineFunction<IN, OUT> {
        private static final long serialVersionUID = 1L;

        private GroupCombiner() {
        }

        public void combine(Iterable<IN> values, Collector<OUT> out) throws Exception {
            out.collect(((Tuple3)values.iterator().next()).f0);
        }
    }

    private static class GroupReducer<IN, OUT>
    implements GroupReduceFunction<IN, OUT> {
        private static final long serialVersionUID = 1L;

        private GroupReducer() {
        }

        public void reduce(Iterable<IN> values, Collector<OUT> out) throws Exception {
            out.collect(((Tuple3)values.iterator().next()).f0);
        }
    }

    private static class FlatJoiner<IN1, IN2, OUT>
    implements FlatJoinFunction<IN1, IN2, OUT> {
        private static final long serialVersionUID = 1L;

        private FlatJoiner() {
        }

        public void join(IN1 first, IN2 second, Collector<OUT> out) throws Exception {
            out.collect(((Tuple3)first).f0);
        }
    }

    private static class Joiner<IN1, IN2, OUT>
    implements JoinFunction<IN1, IN2, OUT> {
        private static final long serialVersionUID = 1L;

        private Joiner() {
        }

        public OUT join(IN1 first, IN2 second) throws Exception {
            return (OUT)((Tuple3)first).f0;
        }
    }

    private static class FlatMapper<T, V>
    implements FlatMapFunction<T, V> {
        private static final long serialVersionUID = 1L;

        private FlatMapper() {
        }

        public void flatMap(T value, Collector<V> out) throws Exception {
            out.collect(((Tuple3)value).f0);
        }
    }

    private static class Mapper<T, V>
    implements MapFunction<T, V> {
        private static final long serialVersionUID = 1L;

        private Mapper() {
        }

        public V map(T value) throws Exception {
            return (V)value;
        }
    }
}

