/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.streaming.api;

import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StreamExecutionEnvironmentITCase {
    @ClassRule
    public static MiniClusterWithClientResource miniClusterResource = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(1).build());
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void executeThrowsProgramInvocationException() throws Exception {
        UnmodifiableConfiguration clientConfiguration = miniClusterResource.getClientConfiguration();
        Configuration config = new Configuration((Configuration)clientConfiguration);
        config.set(DeploymentOptions.TARGET, (Object)"remote");
        config.setBoolean(DeploymentOptions.ATTACHED, true);
        StreamExecutionEnvironment env = new StreamExecutionEnvironment(config);
        env.fromElements((Object[])new String[]{"hello"}).map((MapFunction & Serializable)in -> {
            throw new RuntimeException("Failing");
        }).print();
        this.thrown.expect(ProgramInvocationException.class);
        env.execute();
    }
}

