/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MetricsSnapshot;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CloneSnapshotProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.CloneSnapshotState> {
    private static final Logger LOG = LoggerFactory.getLogger(CloneSnapshotProcedure.class);
    private TableDescriptor tableDescriptor;
    private SnapshotProtos.SnapshotDescription snapshot;
    private boolean restoreAcl;
    private List<RegionInfo> newRegions = null;
    private Map<String, Pair<String, String>> parentsToChildrenPairMap = new HashMap<String, Pair<String, String>>();
    private MonitoredTask monitorStatus = null;

    public CloneSnapshotProcedure() {
    }

    public CloneSnapshotProcedure(MasterProcedureEnv env, TableDescriptor tableDescriptor, SnapshotProtos.SnapshotDescription snapshot) {
        this(env, tableDescriptor, snapshot, false);
    }

    public CloneSnapshotProcedure(MasterProcedureEnv env, TableDescriptor tableDescriptor, SnapshotProtos.SnapshotDescription snapshot, boolean restoreAcl) {
        super(env);
        this.tableDescriptor = tableDescriptor;
        this.snapshot = snapshot;
        this.restoreAcl = restoreAcl;
        this.getMonitorStatus();
    }

    private MonitoredTask getMonitorStatus() {
        if (this.monitorStatus == null) {
            this.monitorStatus = TaskMonitor.get().createStatus("Cloning  snapshot '" + this.snapshot.getName() + "' to table " + this.getTableName());
        }
        return this.monitorStatus;
    }

    private void restoreSnapshotAcl(MasterProcedureEnv env) throws IOException {
        Configuration conf = env.getMasterServices().getConfiguration();
        if (this.restoreAcl && this.snapshot.hasUsersAndPermissions() && this.snapshot.getUsersAndPermissions() != null && SnapshotDescriptionUtils.isSecurityAvailable(conf)) {
            RestoreSnapshotHelper.restoreSnapshotAcl(this.snapshot, this.tableDescriptor.getTableName(), conf);
        }
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.CloneSnapshotState state) throws InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case CLONE_SNAPSHOT_PRE_OPERATION: {
                    this.prepareClone(env);
                    this.preCloneSnapshot(env);
                    this.setNextState(MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_WRITE_FS_LAYOUT);
                    break;
                }
                case CLONE_SNAPSHOT_WRITE_FS_LAYOUT: {
                    this.newRegions = this.createFilesystemLayout(env, this.tableDescriptor, this.newRegions);
                    this.setNextState(MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_ADD_TO_META);
                    break;
                }
                case CLONE_SNAPSHOT_ADD_TO_META: {
                    this.addRegionsToMeta(env);
                    this.setNextState(MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_ASSIGN_REGIONS);
                    break;
                }
                case CLONE_SNAPSHOT_ASSIGN_REGIONS: {
                    CreateTableProcedure.setEnablingState(env, this.getTableName());
                    this.addChildProcedure(env.getAssignmentManager().createRoundRobinAssignProcedures(this.newRegions));
                    this.setNextState(MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_UPDATE_DESC_CACHE);
                    break;
                }
                case CLONE_SNAPSHOT_UPDATE_DESC_CACHE: {
                    CreateTableProcedure.setEnabledState(env, this.getTableName());
                    CreateTableProcedure.updateTableDescCache(env, this.getTableName());
                    this.setNextState(MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPHOST_RESTORE_ACL);
                    break;
                }
                case CLONE_SNAPHOST_RESTORE_ACL: {
                    this.restoreSnapshotAcl(env);
                    this.setNextState(MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_POST_OPERATION);
                    break;
                }
                case CLONE_SNAPSHOT_POST_OPERATION: {
                    this.postCloneSnapshot(env);
                    MetricsSnapshot metricsSnapshot = new MetricsSnapshot();
                    metricsSnapshot.addSnapshotClone(this.getMonitorStatus().getCompletionTimestamp() - this.getMonitorStatus().getStartTime());
                    this.getMonitorStatus().markComplete("Clone snapshot '" + this.snapshot.getName() + "' completed!");
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-clone-snapshot", e);
            }
            LOG.warn("Retriable error trying to clone snapshot=" + this.snapshot.getName() + " to table=" + this.getTableName() + " state=" + state, (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.CloneSnapshotState state) throws IOException {
        if (state == MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_PRE_OPERATION) {
            DeleteTableProcedure.deleteTableStates(env, this.getTableName());
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.CloneSnapshotState state) {
        switch (state) {
            case CLONE_SNAPSHOT_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    protected MasterProcedureProtos.CloneSnapshotState getState(int stateId) {
        return MasterProcedureProtos.CloneSnapshotState.valueOf((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.CloneSnapshotState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.CloneSnapshotState getInitialState() {
        return MasterProcedureProtos.CloneSnapshotState.CLONE_SNAPSHOT_PRE_OPERATION;
    }

    @Override
    public TableName getTableName() {
        return this.tableDescriptor.getTableName();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.CREATE;
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.getTableName());
        sb.append(" snapshot=");
        sb.append(this.snapshot);
        sb.append(")");
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.CloneSnapshotStateData.Builder cloneSnapshotMsg = MasterProcedureProtos.CloneSnapshotStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setSnapshot(this.snapshot).setTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)this.tableDescriptor));
        if (this.newRegions != null) {
            for (RegionInfo hri : this.newRegions) {
                cloneSnapshotMsg.addRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)hri));
            }
        }
        if (!this.parentsToChildrenPairMap.isEmpty()) {
            for (Map.Entry<String, Pair<String, String>> entry : this.parentsToChildrenPairMap.entrySet()) {
                MasterProcedureProtos.RestoreParentToChildRegionsPair.Builder parentToChildrenPair = MasterProcedureProtos.RestoreParentToChildRegionsPair.newBuilder().setParentRegionName(entry.getKey()).setChild1RegionName((String)entry.getValue().getFirst()).setChild2RegionName((String)entry.getValue().getSecond());
                cloneSnapshotMsg.addParentToChildRegionsPairList(parentToChildrenPair);
            }
        }
        serializer.serialize((Message)cloneSnapshotMsg.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.CloneSnapshotStateData cloneSnapshotMsg = (MasterProcedureProtos.CloneSnapshotStateData)serializer.deserialize(MasterProcedureProtos.CloneSnapshotStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(cloneSnapshotMsg.getUserInfo()));
        this.snapshot = cloneSnapshotMsg.getSnapshot();
        this.tableDescriptor = ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)cloneSnapshotMsg.getTableSchema());
        if (cloneSnapshotMsg.getRegionInfoCount() == 0) {
            this.newRegions = null;
        } else {
            this.newRegions = new ArrayList<RegionInfo>(cloneSnapshotMsg.getRegionInfoCount());
            for (HBaseProtos.RegionInfo hri : cloneSnapshotMsg.getRegionInfoList()) {
                this.newRegions.add(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)hri));
            }
        }
        if (cloneSnapshotMsg.getParentToChildRegionsPairListCount() > 0) {
            this.parentsToChildrenPairMap = new HashMap<String, Pair<String, String>>();
            for (MasterProcedureProtos.RestoreParentToChildRegionsPair parentToChildrenPair : cloneSnapshotMsg.getParentToChildRegionsPairListList()) {
                this.parentsToChildrenPairMap.put(parentToChildrenPair.getParentRegionName(), (Pair<String, String>)new Pair((Object)parentToChildrenPair.getChild1RegionName(), (Object)parentToChildrenPair.getChild2RegionName()));
            }
        }
        this.getMonitorStatus();
    }

    private void prepareClone(MasterProcedureEnv env) throws IOException {
        TableName tableName = this.getTableName();
        if (MetaTableAccessor.tableExists((Connection)env.getMasterServices().getConnection(), (TableName)tableName)) {
            throw new TableExistsException(this.getTableName());
        }
    }

    private void preCloneSnapshot(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost;
        if (!this.getTableName().isSystemTable()) {
            MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
            SnapshotManifest manifest = SnapshotManifest.open(env.getMasterConfiguration(), mfs.getFileSystem(), SnapshotDescriptionUtils.getCompletedSnapshotDir(this.snapshot, mfs.getRootDir()), this.snapshot);
            ProcedureSyncWait.getMasterQuotaManager(env).checkNamespaceTableAndRegionQuota(this.getTableName(), manifest.getRegionManifestsMap().size());
        }
        if ((cpHost = env.getMasterCoprocessorHost()) != null) {
            cpHost.preCreateTableAction(this.tableDescriptor, null, this.getUser());
        }
    }

    private void postCloneSnapshot(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            RegionInfo[] regions = this.newRegions == null ? null : this.newRegions.toArray(new RegionInfo[this.newRegions.size()]);
            cpHost.postCompletedCreateTableAction(this.tableDescriptor, regions, this.getUser());
        }
    }

    private List<RegionInfo> createFilesystemLayout(MasterProcedureEnv env, final TableDescriptor tableDescriptor, List<RegionInfo> newRegions) throws IOException {
        return this.createFsLayout(env, tableDescriptor, newRegions, new CreateTableProcedure.CreateHdfsRegions(){

            @Override
            public List<RegionInfo> createHdfsRegions(MasterProcedureEnv env, Path tableRootDir, TableName tableName, List<RegionInfo> newRegions) throws IOException {
                MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
                FileSystem fs = mfs.getFileSystem();
                Path rootDir = mfs.getRootDir();
                Configuration conf = env.getMasterConfiguration();
                ForeignExceptionDispatcher monitorException = new ForeignExceptionDispatcher();
                CloneSnapshotProcedure.this.getMonitorStatus().setStatus("Clone snapshot - creating regions for table: " + tableName);
                try {
                    Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(CloneSnapshotProcedure.this.snapshot, rootDir);
                    SnapshotManifest manifest = SnapshotManifest.open(conf, fs, snapshotDir, CloneSnapshotProcedure.this.snapshot);
                    RestoreSnapshotHelper restoreHelper = new RestoreSnapshotHelper(conf, fs, manifest, tableDescriptor, tableRootDir, monitorException, CloneSnapshotProcedure.this.monitorStatus);
                    RestoreSnapshotHelper.RestoreMetaChanges metaChanges = restoreHelper.restoreHdfsRegions();
                    Preconditions.checkArgument((!metaChanges.hasRegionsToRestore() ? 1 : 0) != 0, (Object)"A clone should not have regions to restore");
                    Preconditions.checkArgument((!metaChanges.hasRegionsToRemove() ? 1 : 0) != 0, (Object)"A clone should not have regions to remove");
                    String msg = "Clone snapshot=" + CloneSnapshotProcedure.this.snapshot.getName() + " on table=" + tableName + " completed!";
                    LOG.info(msg);
                    CloneSnapshotProcedure.this.monitorStatus.setStatus(msg + " Waiting for table to be enabled...");
                    return metaChanges.getRegionsToAdd();
                }
                catch (Exception e) {
                    String msg = "clone snapshot=" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)CloneSnapshotProcedure.this.snapshot) + " failed because " + e.getMessage();
                    LOG.error(msg, (Throwable)e);
                    RestoreSnapshotException rse = new RestoreSnapshotException(msg, (Throwable)e, ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)CloneSnapshotProcedure.this.snapshot));
                    monitorException.receive(new ForeignException("Master CloneSnapshotProcedure", (Throwable)rse));
                    throw rse;
                }
            }
        });
    }

    private List<RegionInfo> createFsLayout(MasterProcedureEnv env, TableDescriptor tableDescriptor, List<RegionInfo> newRegions, CreateTableProcedure.CreateHdfsRegions hdfsRegionHandler) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tempdir = mfs.getTempDir();
        Path tempTableDir = FSUtils.getTableDir((Path)tempdir, (TableName)tableDescriptor.getTableName());
        ((FSTableDescriptors)env.getMasterServices().getTableDescriptors()).createTableDescriptorForTableDirectory(tempTableDir, TableDescriptorBuilder.newBuilder((TableDescriptor)tableDescriptor).build(), false);
        newRegions = hdfsRegionHandler.createHdfsRegions(env, tempdir, tableDescriptor.getTableName(), newRegions);
        CreateTableProcedure.moveTempDirectoryToHBaseRoot(env, tableDescriptor, tempTableDir);
        Path tempMobTableDir = MobUtils.getMobTableDir(tempdir, tableDescriptor.getTableName());
        if (mfs.getFileSystem().exists(tempMobTableDir)) {
            this.moveTempMobDirectoryToHBaseRoot(mfs, tableDescriptor, tempMobTableDir);
        }
        return newRegions;
    }

    private void moveTempMobDirectoryToHBaseRoot(MasterFileSystem mfs, TableDescriptor tableDescriptor, Path tempMobTableDir) throws IOException {
        Path tableMobDir;
        FileSystem fs = mfs.getFileSystem();
        if (!fs.delete(tableMobDir = MobUtils.getMobTableDir(mfs.getRootDir(), tableDescriptor.getTableName()), true) && fs.exists(tableMobDir)) {
            throw new IOException("Couldn't delete mob table " + tableMobDir);
        }
        if (!fs.exists(tableMobDir.getParent())) {
            fs.mkdirs(tableMobDir.getParent());
        }
        if (!fs.rename(tempMobTableDir, tableMobDir)) {
            throw new IOException("Unable to move mob table from temp=" + tempMobTableDir + " to hbase root=" + tableMobDir);
        }
    }

    private void addRegionsToMeta(MasterProcedureEnv env) throws IOException {
        this.newRegions = CreateTableProcedure.addTableToMeta(env, this.tableDescriptor, this.newRegions);
        RestoreSnapshotHelper.RestoreMetaChanges metaChanges = new RestoreSnapshotHelper.RestoreMetaChanges(this.tableDescriptor, this.parentsToChildrenPairMap);
        metaChanges.updateMetaParentRegions(env.getMasterServices().getConnection(), this.newRegions);
    }
}

