/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;

public final class LlapDataBuffer
extends LlapCacheableBuffer
implements MemoryBuffer {
    private static final int EVICTED_REFCOUNT = -1;
    public static final int UNKNOWN_CACHED_LENGTH = -1;
    protected final AtomicInteger refCount = new AtomicInteger(0);
    public ByteBuffer byteBuffer;
    public int arenaIndex = -1;
    public int allocSize;
    public int declaredCachedLength = -1;

    public void initialize(int arenaIndex, ByteBuffer byteBuffer, int offset, int length) {
        this.byteBuffer = byteBuffer.slice();
        this.byteBuffer.position(offset);
        this.byteBuffer.limit(offset + length);
        this.arenaIndex = arenaIndex;
        this.allocSize = length;
    }

    public ByteBuffer getByteBufferDup() {
        return this.byteBuffer.duplicate();
    }

    public ByteBuffer getByteBufferRaw() {
        return this.byteBuffer;
    }

    @Override
    public long getMemoryUsage() {
        return this.allocSize;
    }

    @Override
    public void notifyEvicted(EvictionDispatcher evictionDispatcher) {
        evictionDispatcher.notifyEvicted(this);
    }

    int incRef() {
        int oldRefCount;
        int newRefCount = -1;
        do {
            if ((oldRefCount = this.refCount.get()) == -1) {
                return -1;
            }
            assert (oldRefCount >= 0) : "oldRefCount is " + oldRefCount + " " + this;
        } while (!this.refCount.compareAndSet(oldRefCount, newRefCount = oldRefCount + 1));
        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
            LlapIoImpl.LOCKING_LOGGER.trace("Locked {}; new ref count {}", (Object)this, (Object)newRefCount);
        }
        return newRefCount;
    }

    @VisibleForTesting
    int getRefCount() {
        return this.refCount.get();
    }

    @Override
    @VisibleForTesting
    public boolean isLocked() {
        return this.refCount.get() > 0;
    }

    @VisibleForTesting
    public boolean isInvalid() {
        return this.refCount.get() == -1;
    }

    int decRef() {
        int newRefCount = this.refCount.decrementAndGet();
        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
            LlapIoImpl.LOCKING_LOGGER.trace("Unlocked {}; refcount {}", (Object)this, (Object)newRefCount);
        }
        if (newRefCount < 0) {
            throw new AssertionError((Object)("Unexpected refCount " + newRefCount + ": " + this));
        }
        return newRefCount;
    }

    @Override
    public boolean invalidate() {
        int value;
        do {
            if ((value = this.refCount.get()) == 0) continue;
            return false;
        } while (!this.refCount.compareAndSet(value, -1));
        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
            LlapIoImpl.LOCKING_LOGGER.trace("Invalidated {} due to eviction", (Object)this);
        }
        return true;
    }

    @Override
    public String toString() {
        int refCount = this.refCount.get();
        return "0x" + Integer.toHexString(System.identityHashCode(this)) + "(" + refCount + ")";
    }

    public static String toDataString(MemoryBuffer s) {
        if (s == null || s.getByteBufferRaw().remaining() == 0) {
            return "" + s;
        }
        byte b = s.getByteBufferRaw().get(s.getByteBufferRaw().position());
        byte i = b < 0 ? -b : b;
        return s + " (0x" + Integer.toHexString(i) + ")";
    }
}

