/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.BuddyAllocatorMXBean;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import sun.misc.Cleaner;

public final class SimpleAllocator
implements Allocator,
BuddyAllocatorMXBean {
    private final boolean isDirect;
    private static Field cleanerField;

    public SimpleAllocator(Configuration conf) {
        this.isDirect = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT);
        if (LlapIoImpl.LOG.isInfoEnabled()) {
            LlapIoImpl.LOG.info("Simple allocator with " + (this.isDirect ? "direct" : "byte") + " buffers");
        }
    }

    public void allocateMultiple(MemoryBuffer[] dest, int size) {
        for (int i = 0; i < dest.length; ++i) {
            LlapDataBuffer buf = null;
            if (dest[i] == null) {
                buf = this.createUnallocated();
                dest[i] = buf;
            } else {
                buf = (LlapDataBuffer)dest[i];
            }
            ByteBuffer bb = this.isDirect ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
            buf.initialize(0, bb, 0, size);
        }
    }

    public void deallocate(MemoryBuffer buffer) {
        LlapDataBuffer buf = (LlapDataBuffer)buffer;
        ByteBuffer bb = buf.byteBuffer;
        buf.byteBuffer = null;
        if (!bb.isDirect()) {
            return;
        }
        Field field = cleanerField;
        if (field == null) {
            return;
        }
        try {
            ((Cleaner)field.get(bb)).clean();
        }
        catch (Throwable t) {
            LlapIoImpl.LOG.warn("Error using DirectByteBuffer cleaner; stopping its use", t);
            cleanerField = null;
        }
    }

    public boolean isDirectAlloc() {
        return this.isDirect;
    }

    public LlapDataBuffer createUnallocated() {
        return new LlapDataBuffer();
    }

    @Override
    public boolean getIsDirect() {
        return this.isDirect;
    }

    @Override
    public int getMinAllocation() {
        return 0;
    }

    @Override
    public int getMaxAllocation() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getArenaSize() {
        return -1;
    }

    @Override
    public long getMaxCacheSize() {
        return Integer.MAX_VALUE;
    }

    static {
        try {
            Class<?> dbClazz = Class.forName("java.nio.DirectByteBuffer");
            cleanerField = dbClazz.getDeclaredField("cleaner");
            cleanerField.setAccessible(true);
        }
        catch (Throwable t) {
            LlapIoImpl.LOG.warn("Cannot initialize DirectByteBuffer cleaner", t);
            cleanerField = null;
        }
    }
}

