/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import jline.TerminalFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapOptionsProcessor {
    public static final String OPTION_INSTANCES = "instances";
    public static final String OPTION_NAME = "name";
    public static final String OPTION_DIRECTORY = "directory";
    public static final String OPTION_EXECUTORS = "executors";
    public static final String OPTION_CACHE = "cache";
    public static final String OPTION_SIZE = "size";
    public static final String OPTION_XMX = "xmx";
    public static final String OPTION_AUXJARS = "auxjars";
    public static final String OPTION_AUXHIVE = "auxhive";
    public static final String OPTION_AUXHBASE = "auxhbase";
    public static final String OPTION_JAVA_HOME = "javaHome";
    public static final String OPTION_HIVECONF = "hiveconf";
    public static final String OPTION_SLIDER_AM_CONTAINER_MB = "slider-am-container-mb";
    public static final String OPTION_SLIDER_APPCONFIG_GLOBAL = "slider-appconfig-global";
    public static final String OPTION_LLAP_QUEUE = "queue";
    public static final String OPTION_IO_THREADS = "iothreads";
    public static final String OPTION_ARGS = "args";
    public static final String OPTION_LOGLEVEL = "loglevel";
    public static final String OPTION_LOGGER = "logger";
    public static final String OPTION_CHAOS_MONKEY = "chaosmonkey";
    public static final String OPTION_SLIDER_KEYTAB_DIR = "slider-keytab-dir";
    public static final String OPTION_SLIDER_KEYTAB = "slider-keytab";
    public static final String OPTION_SLIDER_PRINCIPAL = "slider-principal";
    public static final String OPTION_SLIDER_PLACEMENT = "slider-placement";
    public static final String OPTION_SLIDER_DEFAULT_KEYTAB = "slider-default-keytab";
    public static final String OPTION_OUTPUT_DIR = "output";
    public static final String OPTION_START = "startImmediately";
    protected static final Logger l4j = LoggerFactory.getLogger((String)LlapOptionsProcessor.class.getName());
    private final Options options = new Options();
    private CommandLine commandLine;

    public LlapOptionsProcessor() {
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_INSTANCES);
        OptionBuilder.withLongOpt((String)OPTION_INSTANCES);
        OptionBuilder.withDescription((String)"Specify the number of instances to run this on");
        this.options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_NAME);
        OptionBuilder.withLongOpt((String)OPTION_NAME);
        OptionBuilder.withDescription((String)"Cluster name for YARN registry");
        this.options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_DIRECTORY);
        OptionBuilder.withLongOpt((String)OPTION_DIRECTORY);
        OptionBuilder.withDescription((String)"Temp directory for jars etc.");
        this.options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_ARGS);
        OptionBuilder.withLongOpt((String)OPTION_ARGS);
        OptionBuilder.withDescription((String)"java arguments to the llap instance");
        this.options.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_LOGLEVEL);
        OptionBuilder.withLongOpt((String)OPTION_LOGLEVEL);
        OptionBuilder.withDescription((String)"log levels for the llap instance");
        this.options.addOption(OptionBuilder.create((char)'l'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_LOGGER);
        OptionBuilder.withLongOpt((String)OPTION_LOGGER);
        OptionBuilder.withDescription((String)"logger for llap instance ([RFA], query-routing, console");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_CHAOS_MONKEY);
        OptionBuilder.withLongOpt((String)OPTION_CHAOS_MONKEY);
        OptionBuilder.withDescription((String)"chaosmonkey interval");
        this.options.addOption(OptionBuilder.create((char)'m'));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withArgName((String)OPTION_SLIDER_DEFAULT_KEYTAB);
        OptionBuilder.withLongOpt((String)OPTION_SLIDER_DEFAULT_KEYTAB);
        OptionBuilder.withDescription((String)"try to set default settings for Slider AM keytab; mostly for dev testing");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_SLIDER_KEYTAB_DIR);
        OptionBuilder.withLongOpt((String)OPTION_SLIDER_KEYTAB_DIR);
        OptionBuilder.withDescription((String)"Slider AM keytab directory on HDFS (where the headless user keytab is stored by Slider keytab installation, e.g. .slider/keytabs/llap)");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_SLIDER_KEYTAB);
        OptionBuilder.withLongOpt((String)OPTION_SLIDER_KEYTAB);
        OptionBuilder.withDescription((String)"Slider AM keytab file name inside slider-keytab-dir");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_SLIDER_PRINCIPAL);
        OptionBuilder.withLongOpt((String)OPTION_SLIDER_PRINCIPAL);
        OptionBuilder.withDescription((String)"Slider AM principal; should be the user running the cluster, e.g. hive@EXAMPLE.COM");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_SLIDER_PLACEMENT);
        OptionBuilder.withLongOpt((String)OPTION_SLIDER_PLACEMENT);
        OptionBuilder.withDescription((String)"Slider placement policy; see slider documentation at https://slider.incubator.apache.org/docs/placement.html. 4 means anti-affinity (the default; unnecessary if LLAP is going to take more than half of the YARN capacity of a node), 0 is normal.");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_EXECUTORS);
        OptionBuilder.withLongOpt((String)OPTION_EXECUTORS);
        OptionBuilder.withDescription((String)"executor per instance");
        this.options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_CACHE);
        OptionBuilder.withLongOpt((String)OPTION_CACHE);
        OptionBuilder.withDescription((String)"cache size per instance");
        this.options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_SIZE);
        OptionBuilder.withLongOpt((String)OPTION_SIZE);
        OptionBuilder.withDescription((String)"container size per instance");
        this.options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_XMX);
        OptionBuilder.withLongOpt((String)OPTION_XMX);
        OptionBuilder.withDescription((String)"working memory size");
        this.options.addOption(OptionBuilder.create((char)'w'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_LLAP_QUEUE);
        OptionBuilder.withLongOpt((String)OPTION_LLAP_QUEUE);
        OptionBuilder.withDescription((String)"The queue within which LLAP will be started");
        this.options.addOption(OptionBuilder.create((char)'q'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_OUTPUT_DIR);
        OptionBuilder.withLongOpt((String)OPTION_OUTPUT_DIR);
        OptionBuilder.withDescription((String)"Output directory for the generated scripts");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_AUXJARS);
        OptionBuilder.withLongOpt((String)OPTION_AUXJARS);
        OptionBuilder.withDescription((String)"additional jars to package (by default, JSON SerDe jar is packaged if available)");
        this.options.addOption(OptionBuilder.create((char)'j'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_AUXHBASE);
        OptionBuilder.withLongOpt((String)OPTION_AUXHBASE);
        OptionBuilder.withDescription((String)"whether to package the HBase jars (true by default)");
        this.options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_AUXHIVE);
        OptionBuilder.withLongOpt((String)OPTION_AUXHIVE);
        OptionBuilder.withDescription((String)"whether to package the Hive aux jars (true by default)");
        this.options.addOption(OptionBuilder.create((String)OPTION_AUXHIVE));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_JAVA_HOME);
        OptionBuilder.withLongOpt((String)OPTION_JAVA_HOME);
        OptionBuilder.withDescription((String)"Path to the JRE/JDK. This should be installed at the same location on all cluster nodes ($JAVA_HOME, java.home by default)");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)OPTION_HIVECONF);
        OptionBuilder.withDescription((String)"Use value for given property. Overridden by explicit parameters");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"b");
        OptionBuilder.withLongOpt((String)OPTION_SLIDER_AM_CONTAINER_MB);
        OptionBuilder.withDescription((String)"The size of the slider AppMaster container in MB");
        this.options.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)OPTION_SLIDER_APPCONFIG_GLOBAL);
        OptionBuilder.withDescription((String)"Property (key=value) to be set in the global section of the Slider appConfig");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OPTION_IO_THREADS);
        OptionBuilder.withLongOpt((String)OPTION_IO_THREADS);
        OptionBuilder.withDescription((String)"executor per instance");
        this.options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withArgName((String)OPTION_START);
        OptionBuilder.withLongOpt((String)OPTION_START);
        OptionBuilder.withDescription((String)"immediately start the cluster");
        this.options.addOption(OptionBuilder.create((char)'z'));
        this.options.addOption(new Option("H", "help", false, "Print help information"));
    }

    private static long parseSuffixed(String value) {
        return StringUtils.TraditionalBinaryPrefix.string2long((String)value);
    }

    public LlapOptions processOptions(String[] argv) throws ParseException, IOException {
        this.commandLine = new GnuParser().parse(this.options, argv);
        if (this.commandLine.hasOption('H') || !this.commandLine.hasOption(OPTION_INSTANCES)) {
            this.printUsage();
            return null;
        }
        int instances = Integer.parseInt(this.commandLine.getOptionValue(OPTION_INSTANCES));
        String directory = this.commandLine.getOptionValue(OPTION_DIRECTORY);
        String jars = this.commandLine.getOptionValue(OPTION_AUXJARS);
        String name = this.commandLine.getOptionValue(OPTION_NAME, null);
        int executors = Integer.parseInt(this.commandLine.getOptionValue(OPTION_EXECUTORS, "-1"));
        int ioThreads = Integer.parseInt(this.commandLine.getOptionValue(OPTION_IO_THREADS, Integer.toString(executors)));
        long cache = LlapOptionsProcessor.parseSuffixed(this.commandLine.getOptionValue(OPTION_CACHE, "-1"));
        long size = LlapOptionsProcessor.parseSuffixed(this.commandLine.getOptionValue(OPTION_SIZE, "-1"));
        long xmx = LlapOptionsProcessor.parseSuffixed(this.commandLine.getOptionValue(OPTION_XMX, "-1"));
        boolean isHbase = Boolean.parseBoolean(this.commandLine.getOptionValue(OPTION_AUXHBASE, "true"));
        boolean isHiveAux = Boolean.parseBoolean(this.commandLine.getOptionValue(OPTION_AUXHIVE, "true"));
        boolean doStart = this.commandLine.hasOption(OPTION_START);
        String output = this.commandLine.getOptionValue(OPTION_OUTPUT_DIR, null);
        String queueName = this.commandLine.getOptionValue(OPTION_LLAP_QUEUE, HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME.getDefaultValue());
        Properties hiveconf = this.commandLine.hasOption(OPTION_HIVECONF) ? this.commandLine.getOptionProperties(OPTION_HIVECONF) : new Properties();
        String javaHome = null;
        if (this.commandLine.hasOption(OPTION_JAVA_HOME)) {
            javaHome = this.commandLine.getOptionValue(OPTION_JAVA_HOME);
        }
        String logger = null;
        if (this.commandLine.hasOption(OPTION_LOGGER)) {
            logger = this.commandLine.getOptionValue(OPTION_LOGGER);
            Preconditions.checkArgument((logger.equalsIgnoreCase("query-routing") || logger.equalsIgnoreCase("console") || logger.equalsIgnoreCase("RFA") ? 1 : 0) != 0);
        }
        return new LlapOptions(name, instances, directory, executors, ioThreads, cache, size, xmx, jars, isHbase, hiveconf, javaHome, queueName, logger, doStart, output, isHiveAux);
    }

    private void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        try {
            int width = hf.getWidth();
            int jlineWidth = TerminalFactory.get().getWidth();
            width = Math.min(160, Math.max(jlineWidth, width));
            hf.setWidth(width);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hf.printHelp("llap", this.options);
    }

    public static class LlapOptions {
        private final int instances;
        private final String directory;
        private final String name;
        private final int executors;
        private final int ioThreads;
        private final long cache;
        private final long size;
        private final long xmx;
        private final String jars;
        private final boolean isHbase;
        private final Properties conf;
        private final String javaPath;
        private final String llapQueueName;
        private final String logger;
        private final boolean isStarting;
        private final String output;
        private final boolean isHiveAux;

        public LlapOptions(String name, int instances, String directory, int executors, int ioThreads, long cache, long size, long xmx, String jars, boolean isHbase, @Nonnull Properties hiveconf, String javaPath, String llapQueueName, String logger, boolean isStarting, String output, boolean isHiveAux) throws ParseException {
            if (instances <= 0) {
                throw new ParseException("Invalid configuration: " + instances + " (should be greater than 0)");
            }
            this.instances = instances;
            this.directory = directory;
            this.name = name;
            this.executors = executors;
            this.ioThreads = ioThreads;
            this.cache = cache;
            this.size = size;
            this.xmx = xmx;
            this.jars = jars;
            this.isHbase = isHbase;
            this.isHiveAux = isHiveAux;
            this.conf = hiveconf;
            this.javaPath = javaPath;
            this.llapQueueName = llapQueueName;
            this.logger = logger;
            this.isStarting = isStarting;
            this.output = output;
        }

        public String getOutput() {
            return this.output;
        }

        public String getName() {
            return this.name;
        }

        public int getInstances() {
            return this.instances;
        }

        public String getDirectory() {
            return this.directory;
        }

        public int getExecutors() {
            return this.executors;
        }

        public int getIoThreads() {
            return this.ioThreads;
        }

        public long getCache() {
            return this.cache;
        }

        public long getSize() {
            return this.size;
        }

        public long getXmx() {
            return this.xmx;
        }

        public String getAuxJars() {
            return this.jars;
        }

        public boolean getIsHBase() {
            return this.isHbase;
        }

        public boolean getIsHiveAux() {
            return this.isHiveAux;
        }

        public Properties getConfig() {
            return this.conf;
        }

        public String getJavaPath() {
            return this.javaPath;
        }

        public String getLlapQueueName() {
            return this.llapQueueName;
        }

        public String getLogger() {
            return this.logger;
        }

        public boolean isStarting() {
            return this.isStarting;
        }
    }
}

