/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.util.Collections;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailOnFirstErrorWriteStatus
extends WriteStatus {
    private static final Logger LOG = LoggerFactory.getLogger(FailOnFirstErrorWriteStatus.class);

    public FailOnFirstErrorWriteStatus(Boolean trackSuccessRecords, Double failureFraction) {
        super(trackSuccessRecords, failureFraction);
    }

    @Override
    public void markFailure(HoodieRecord record, Throwable t, Option<Map<String, String>> optionalRecordMetadata) {
        LOG.error(String.format("Error writing record %s with data %s and optionalRecordMetadata %s", record, record.getData(), optionalRecordMetadata.orElse(Collections.emptyMap()), t));
        throw new HoodieException("Error writing record " + record + ": " + t.getMessage());
    }
}

