/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hudi.client.transaction.ConcurrentOperation;
import org.apache.hudi.client.transaction.ConflictResolutionStrategy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SimpleConcurrentFileWritesConflictResolutionStrategy
implements ConflictResolutionStrategy {
    private static final Logger LOG = LogManager.getLogger(SimpleConcurrentFileWritesConflictResolutionStrategy.class);

    @Override
    public Stream<HoodieInstant> getCandidateInstants(HoodieActiveTimeline activeTimeline, HoodieInstant currentInstant, Option<HoodieInstant> lastSuccessfulInstant) {
        Stream<HoodieInstant> completedCommitsInstantStream = activeTimeline.getCommitsTimeline().filterCompletedInstants().findInstantsAfter(lastSuccessfulInstant.isPresent() ? lastSuccessfulInstant.get().getTimestamp() : "00000000000000").getInstantsAsStream();
        Stream<HoodieInstant> compactionAndClusteringPendingTimeline = activeTimeline.getTimelineOfActions(CollectionUtils.createSet("replacecommit", "compaction")).findInstantsAfter(currentInstant.getTimestamp()).filterInflightsAndRequested().getInstantsAsStream();
        return Stream.concat(completedCommitsInstantStream, compactionAndClusteringPendingTimeline);
    }

    @Override
    public boolean hasConflict(ConcurrentOperation thisOperation, ConcurrentOperation otherOperation) {
        Set<Pair<String, String>> partitionAndFileIdsSetForFirstInstant = thisOperation.getMutatedPartitionAndFileIds();
        Set<Pair<String, String>> partitionAndFileIdsSetForSecondInstant = otherOperation.getMutatedPartitionAndFileIds();
        HashSet<Pair<String, String>> intersection = new HashSet<Pair<String, String>>(partitionAndFileIdsSetForFirstInstant);
        intersection.retainAll(partitionAndFileIdsSetForSecondInstant);
        if (!intersection.isEmpty()) {
            LOG.info((Object)("Found conflicting writes between first operation = " + thisOperation + ", second operation = " + otherOperation + " , intersecting file ids " + intersection));
            return true;
        }
        return false;
    }

    @Override
    public Option<HoodieCommitMetadata> resolveConflict(HoodieTable table, ConcurrentOperation thisOperation, ConcurrentOperation otherOperation) {
        if (otherOperation.getOperationType() == WriteOperationType.COMPACT ? HoodieTimeline.compareTimestamps(otherOperation.getInstantTimestamp(), HoodieTimeline.LESSER_THAN, thisOperation.getInstantTimestamp()) : "logcompaction".equals(thisOperation.getInstantActionType())) {
            return thisOperation.getCommitMetadataOption();
        }
        throw new HoodieWriteConflictException(new ConcurrentModificationException("Cannot resolve conflicts for overlapping writes"));
    }
}

