/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.OverwriteNonDefaultsWithLatestAvroPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public class PartialUpdateAvroPayload
extends OverwriteNonDefaultsWithLatestAvroPayload {
    public PartialUpdateAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public PartialUpdateAvroPayload(Option<GenericRecord> record) {
        super(record);
    }

    @Override
    public PartialUpdateAvroPayload preCombine(OverwriteWithLatestAvroPayload oldValue, Schema schema, Properties properties) {
        if (oldValue.recordBytes.length == 0) {
            return this;
        }
        boolean shouldPickOldRecord = oldValue.orderingVal.compareTo(this.orderingVal) > 0;
        try {
            GenericRecord oldRecord = HoodieAvroUtils.bytesToAvro(oldValue.recordBytes, schema);
            Option<IndexedRecord> mergedRecord = this.mergeOldRecord(oldRecord, schema, shouldPickOldRecord, true);
            if (mergedRecord.isPresent()) {
                return new PartialUpdateAvroPayload((GenericRecord)mergedRecord.get(), shouldPickOldRecord ? oldValue.orderingVal : this.orderingVal);
            }
        }
        catch (Exception ex) {
            return this;
        }
        return this;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
        return this.mergeOldRecord(currentValue, schema, false, false);
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema, Properties prop) throws IOException {
        return this.mergeOldRecord(currentValue, schema, PartialUpdateAvroPayload.isRecordNewer(this.orderingVal, currentValue, prop), false);
    }

    @Override
    public Boolean overwriteField(Object value, Object defaultValue) {
        return value == null;
    }

    private Option<IndexedRecord> mergeOldRecord(IndexedRecord oldRecord, Schema schema, boolean isOldRecordNewer, boolean isPreCombining) throws IOException {
        Option<IndexedRecord> recordOption = this.getInsertValue(schema, isPreCombining);
        if (!recordOption.isPresent() && !isPreCombining) {
            return Option.empty();
        }
        if (isOldRecordNewer && schema.getField(HoodieRecord.COMMIT_TIME_METADATA_FIELD) != null) {
            return this.mergeDisorderRecordsWithMetadata(schema, (GenericRecord)oldRecord, (GenericRecord)recordOption.get(), isPreCombining);
        }
        if (isOldRecordNewer) {
            return this.mergeRecords(schema, (GenericRecord)oldRecord, (GenericRecord)recordOption.get());
        }
        return this.mergeRecords(schema, (GenericRecord)recordOption.get(), (GenericRecord)oldRecord);
    }

    public Option<IndexedRecord> getInsertValue(Schema schema, boolean isPreCombining) throws IOException {
        if (this.recordBytes.length == 0 || !isPreCombining && this.isDeletedRecord) {
            return Option.empty();
        }
        return Option.of(HoodieAvroUtils.bytesToAvro(this.recordBytes, schema));
    }

    protected Option<IndexedRecord> mergeDisorderRecordsWithMetadata(Schema schema, GenericRecord oldRecord, GenericRecord updatingRecord, boolean isPreCombining) {
        if (this.isDeleteRecord(oldRecord) && !isPreCombining) {
            return Option.empty();
        }
        GenericRecordBuilder builder = new GenericRecordBuilder(schema);
        List<Schema.Field> fields = schema.getFields();
        fields.forEach(field -> {
            GenericRecord mergedRecord;
            GenericRecord baseRecord;
            if (HoodieRecord.HOODIE_META_COLUMNS_NAME_TO_POS.containsKey(field.name())) {
                baseRecord = updatingRecord;
                mergedRecord = oldRecord;
            } else {
                baseRecord = oldRecord;
                mergedRecord = updatingRecord;
            }
            this.setField(baseRecord, mergedRecord, builder, (Schema.Field)field);
        });
        return Option.of(builder.build());
    }

    private static boolean isRecordNewer(Comparable orderingVal, IndexedRecord record, Properties prop) {
        String orderingField = prop.getProperty("hoodie.payload.ordering.field");
        if (!StringUtils.isNullOrEmpty(orderingField)) {
            boolean consistentLogicalTimestampEnabled = Boolean.parseBoolean(prop.getProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
            Comparable oldOrderingVal = (Comparable)HoodieAvroUtils.getNestedFieldVal((GenericRecord)record, orderingField, true, consistentLogicalTimestampEnabled);
            return oldOrderingVal != null && ReflectionUtils.isSameClass(oldOrderingVal, orderingVal) && oldOrderingVal.compareTo(orderingVal) > 0;
        }
        return false;
    }
}

