/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.collection.BitCaskDiskMap;
import org.apache.hudi.common.util.collection.DiskMap;
import org.apache.hudi.common.util.collection.RocksDbDiskMap;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@NotThreadSafe
public class ExternalSpillableMap<T extends Serializable, R extends Serializable>
implements Map<T, R>,
Serializable {
    private static final int NUMBER_OF_RECORDS_TO_ESTIMATE_PAYLOAD_SIZE = 100;
    private static final Logger LOG = LogManager.getLogger(ExternalSpillableMap.class);
    private final long maxInMemorySizeInBytes;
    private final Map<T, R> inMemoryMap = new HashMap<T, R>();
    private volatile transient DiskMap<T, R> diskBasedMap;
    private final Double sizingFactorForInMemoryMap = 0.8;
    private final SizeEstimator<T> keySizeEstimator;
    private final SizeEstimator<R> valueSizeEstimator;
    private final DiskMapType diskMapType;
    private final boolean isCompressionEnabled;
    private Long currentInMemoryMapSize;
    private volatile long estimatedPayloadSize = 0L;
    private final String baseFilePath;

    public ExternalSpillableMap(Long maxInMemorySizeInBytes, String baseFilePath, SizeEstimator<T> keySizeEstimator, SizeEstimator<R> valueSizeEstimator) throws IOException {
        this(maxInMemorySizeInBytes, baseFilePath, keySizeEstimator, valueSizeEstimator, DiskMapType.BITCASK);
    }

    public ExternalSpillableMap(Long maxInMemorySizeInBytes, String baseFilePath, SizeEstimator<T> keySizeEstimator, SizeEstimator<R> valueSizeEstimator, DiskMapType diskMapType) throws IOException {
        this(maxInMemorySizeInBytes, baseFilePath, keySizeEstimator, valueSizeEstimator, diskMapType, false);
    }

    public ExternalSpillableMap(Long maxInMemorySizeInBytes, String baseFilePath, SizeEstimator<T> keySizeEstimator, SizeEstimator<R> valueSizeEstimator, DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException {
        this.baseFilePath = baseFilePath;
        this.maxInMemorySizeInBytes = (long)Math.floor((double)maxInMemorySizeInBytes.longValue() * this.sizingFactorForInMemoryMap);
        this.currentInMemoryMapSize = 0L;
        this.keySizeEstimator = keySizeEstimator;
        this.valueSizeEstimator = valueSizeEstimator;
        this.diskMapType = diskMapType;
        this.isCompressionEnabled = isCompressionEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiskMap<T, R> getDiskBasedMap() {
        if (null == this.diskBasedMap) {
            ExternalSpillableMap externalSpillableMap = this;
            synchronized (externalSpillableMap) {
                if (null == this.diskBasedMap) {
                    try {
                        switch (this.diskMapType) {
                            case ROCKS_DB: {
                                this.diskBasedMap = new RocksDbDiskMap(this.baseFilePath);
                                break;
                            }
                            default: {
                                this.diskBasedMap = new BitCaskDiskMap(this.baseFilePath, this.isCompressionEnabled);
                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new HoodieIOException(e.getMessage(), e);
                    }
                }
            }
        }
        return this.diskBasedMap;
    }

    public Iterator<R> iterator() {
        return new IteratorWrapper<R>(this.inMemoryMap.values().iterator(), this.getDiskBasedMap().iterator());
    }

    public int getDiskBasedMapNumEntries() {
        return this.getDiskBasedMap().size();
    }

    public long getSizeOfFileOnDiskInBytes() {
        return this.getDiskBasedMap().sizeOfFileOnDiskInBytes();
    }

    public int getInMemoryMapNumEntries() {
        return this.inMemoryMap.size();
    }

    public long getCurrentInMemoryMapSize() {
        return this.currentInMemoryMapSize;
    }

    @Override
    public int size() {
        return this.inMemoryMap.size() + this.getDiskBasedMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.inMemoryMap.isEmpty() && this.getDiskBasedMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.inMemoryMap.containsKey(key) || this.getDiskBasedMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inMemoryMap.containsValue(value) || this.getDiskBasedMap().containsValue(value);
    }

    public boolean inMemoryContainsKey(Object key) {
        return this.inMemoryMap.containsKey(key);
    }

    public boolean inDiskContainsKey(Object key) {
        return this.getDiskBasedMap().containsKey(key);
    }

    @Override
    public R get(Object key) {
        if (this.inMemoryMap.containsKey(key)) {
            return (R)((Serializable)this.inMemoryMap.get(key));
        }
        if (this.getDiskBasedMap().containsKey(key)) {
            return (R)((Serializable)this.getDiskBasedMap().get(key));
        }
        return null;
    }

    @Override
    public R put(T key, R value) {
        if (this.estimatedPayloadSize == 0L) {
            this.estimatedPayloadSize = this.keySizeEstimator.sizeEstimate(key) + this.valueSizeEstimator.sizeEstimate(value);
        } else if (this.inMemoryMap.size() % 100 == 0) {
            this.estimatedPayloadSize = (long)((double)this.estimatedPayloadSize * 0.9 + (double)(this.keySizeEstimator.sizeEstimate(key) + this.valueSizeEstimator.sizeEstimate(value)) * 0.1);
            this.currentInMemoryMapSize = (long)this.inMemoryMap.size() * this.estimatedPayloadSize;
        }
        if (this.inMemoryMap.containsKey(key)) {
            this.inMemoryMap.put(key, value);
        } else if (this.currentInMemoryMapSize < this.maxInMemorySizeInBytes) {
            ExternalSpillableMap externalSpillableMap = this;
            externalSpillableMap.currentInMemoryMapSize = externalSpillableMap.currentInMemoryMapSize + this.estimatedPayloadSize;
            this.inMemoryMap.put(key, value);
        } else {
            this.getDiskBasedMap().put(key, value);
        }
        return value;
    }

    @Override
    public R remove(Object key) {
        if (this.inMemoryMap.containsKey(key)) {
            this.currentInMemoryMapSize = this.currentInMemoryMapSize - this.estimatedPayloadSize;
            return (R)((Serializable)this.inMemoryMap.remove(key));
        }
        if (this.getDiskBasedMap().containsKey(key)) {
            return (R)((Serializable)this.getDiskBasedMap().remove(key));
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends T, ? extends R> m) {
        for (Map.Entry<T, R> entry : m.entrySet()) {
            this.put((T)((Serializable)entry.getKey()), (R)((Serializable)entry.getValue()));
        }
    }

    @Override
    public void clear() {
        this.inMemoryMap.clear();
        this.getDiskBasedMap().clear();
        this.currentInMemoryMapSize = 0L;
    }

    public void close() {
        this.inMemoryMap.clear();
        this.getDiskBasedMap().close();
        this.currentInMemoryMapSize = 0L;
    }

    @Override
    public Set<T> keySet() {
        HashSet<Object> keySet = new HashSet<Object>();
        keySet.addAll(this.inMemoryMap.keySet());
        keySet.addAll(this.getDiskBasedMap().keySet());
        return keySet;
    }

    @Override
    public Collection<R> values() {
        if (this.getDiskBasedMap().isEmpty()) {
            return this.inMemoryMap.values();
        }
        ArrayList<R> result = new ArrayList<R>(this.inMemoryMap.values());
        result.addAll(this.getDiskBasedMap().values());
        return result;
    }

    public Stream<R> valueStream() {
        return Stream.concat(this.inMemoryMap.values().stream(), this.getDiskBasedMap().valueStream());
    }

    @Override
    public Set<Map.Entry<T, R>> entrySet() {
        HashSet<Map.Entry<T, R>> entrySet = new HashSet<Map.Entry<T, R>>();
        entrySet.addAll(this.inMemoryMap.entrySet());
        entrySet.addAll(this.getDiskBasedMap().entrySet());
        return entrySet;
    }

    private class IteratorWrapper<R>
    implements Iterator<R> {
        private final Iterator<R> inMemoryIterator;
        private final Iterator<R> diskLazyFileIterator;

        public IteratorWrapper(Iterator<R> inMemoryIterator, Iterator<R> diskLazyFileIterator) {
            this.inMemoryIterator = inMemoryIterator;
            this.diskLazyFileIterator = diskLazyFileIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.inMemoryIterator.hasNext()) {
                return true;
            }
            return this.diskLazyFileIterator.hasNext();
        }

        @Override
        public R next() {
            if (this.inMemoryIterator.hasNext()) {
                return this.inMemoryIterator.next();
            }
            return this.diskLazyFileIterator.next();
        }
    }

    public static enum DiskMapType {
        BITCASK,
        ROCKS_DB,
        UNKNOWN;

    }
}

