/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hadoop.BootstrapBaseFileSplit;
import org.apache.hudi.hadoop.BootstrapColumnStichingRecordReader;
import org.apache.hudi.hadoop.HoodieColumnProjectionUtils;
import org.apache.hudi.hadoop.HoodieCopyOnWriteTableInputFormat;
import org.apache.hudi.hadoop.HoodieParquetInputFormatBase;
import org.apache.hudi.hadoop.SchemaEvolutionContext;
import org.apache.hudi.hadoop.UseFileSplitsFromInputFormat;
import org.apache.hudi.hadoop.UseRecordReaderFromInputFormat;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.hudi.hadoop.utils.HoodieRealtimeInputFormatUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@UseRecordReaderFromInputFormat
@UseFileSplitsFromInputFormat
public class HoodieParquetInputFormat
extends HoodieParquetInputFormatBase {
    private static final Logger LOG = LogManager.getLogger(HoodieParquetInputFormat.class);

    public HoodieParquetInputFormat() {
        super(new HoodieCopyOnWriteTableInputFormat());
    }

    protected HoodieParquetInputFormat(HoodieCopyOnWriteTableInputFormat delegate) {
        super(delegate);
    }

    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        if (split instanceof BootstrapBaseFileSplit) {
            return this.createBootstrappingRecordReader(split, job, reporter);
        }
        new SchemaEvolutionContext(split, job).doEvolutionForParquetFormat();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("EMPLOYING DEFAULT RECORD READER - " + split));
        }
        HoodieRealtimeInputFormatUtils.addProjectionField((Configuration)job, job.get("partition_columns", "").split("/"));
        return this.getRecordReaderInternal(split, job, reporter);
    }

    private RecordReader<NullWritable, ArrayWritable> getRecordReaderInternal(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return super.getRecordReader(split, job, reporter);
    }

    private RecordReader<NullWritable, ArrayWritable> createBootstrappingRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        BootstrapBaseFileSplit eSplit = (BootstrapBaseFileSplit)split;
        String[] rawColNames = HoodieColumnProjectionUtils.getReadColumnNames((Configuration)job);
        List<Integer> rawColIds = HoodieColumnProjectionUtils.getReadColumnIDs((Configuration)job);
        List projectedColsWithIndex = IntStream.range(0, rawColIds.size()).mapToObj(idx -> Pair.of(rawColIds.get(idx), rawColNames[idx])).collect(Collectors.toList());
        List hoodieColsProjected = projectedColsWithIndex.stream().filter(idxWithName -> HoodieRecord.HOODIE_META_COLUMNS.contains(idxWithName.getValue())).collect(Collectors.toList());
        List externalColsProjected = projectedColsWithIndex.stream().filter(idxWithName -> !HoodieRecord.HOODIE_META_COLUMNS.contains(idxWithName.getValue()) && !HoodieHiveUtils.VIRTUAL_COLUMN_NAMES.contains(idxWithName.getValue())).collect(Collectors.toList());
        List<Pair<String, String>> colNameWithTypes = HoodieColumnProjectionUtils.getIOColumnNameAndTypes((Configuration)job);
        List colNamesWithTypesForExternal = colNameWithTypes.stream().filter(p -> !HoodieRecord.HOODIE_META_COLUMNS.contains(p.getKey())).collect(Collectors.toList());
        LOG.info((Object)("colNameWithTypes =" + colNameWithTypes + ", Num Entries =" + colNameWithTypes.size()));
        if (hoodieColsProjected.isEmpty()) {
            return this.getRecordReaderInternal((InputSplit)eSplit.getBootstrapFileSplit(), job, reporter);
        }
        if (externalColsProjected.isEmpty()) {
            return this.getRecordReaderInternal(split, job, reporter);
        }
        FileSplit rightSplit = eSplit.getBootstrapFileSplit();
        JobConf jobConfCopy = new JobConf((Configuration)job);
        jobConfCopy.unset("hive.io.filter.expr.serialized");
        jobConfCopy.unset("sarg.pushdown");
        LOG.info((Object)("Generating column stitching reader for " + eSplit.getPath() + " and " + rightSplit.getPath()));
        return new BootstrapColumnStichingRecordReader(this.getRecordReaderInternal((InputSplit)eSplit, jobConfCopy, reporter), HoodieRecord.HOODIE_META_COLUMNS.size(), this.getRecordReaderInternal((InputSplit)rightSplit, jobConfCopy, reporter), colNamesWithTypesForExternal.size(), true);
    }
}

