/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.ddl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.ddl.QueryBasedDDLExecutor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class JDBCExecutor
extends QueryBasedDDLExecutor {
    private static final Logger LOG = LogManager.getLogger(QueryBasedDDLExecutor.class);
    private Connection connection;

    public JDBCExecutor(HiveSyncConfig config) {
        super(config);
        Objects.requireNonNull(config.getStringOrDefault(HiveSyncConfigHolder.HIVE_URL), "--jdbc-url option is required for jdbc sync mode");
        Objects.requireNonNull(config.getStringOrDefault(HiveSyncConfigHolder.HIVE_USER), "--user option is required for jdbc sync mode");
        Objects.requireNonNull(config.getStringOrDefault(HiveSyncConfigHolder.HIVE_PASS), "--pass option is required for jdbc sync mode");
        this.createHiveConnection(config.getStringOrDefault(HiveSyncConfigHolder.HIVE_URL), config.getStringOrDefault(HiveSyncConfigHolder.HIVE_USER), config.getStringOrDefault(HiveSyncConfigHolder.HIVE_PASS));
    }

    @Override
    public void runSQL(String s) {
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            LOG.info((Object)("Executing SQL " + s));
            stmt.execute(s);
        }
        catch (SQLException e) {
            throw new HoodieHiveSyncException("Failed in executing SQL " + s, e);
        }
        finally {
            this.closeQuietly(null, stmt);
        }
    }

    private void closeQuietly(ResultSet resultSet, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)"Could not close the statement opened ", (Throwable)e);
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)"Could not close the resultset opened ", (Throwable)e);
        }
    }

    private void createHiveConnection(String jdbcUrl, String hiveUser, String hivePass) {
        if (this.connection == null) {
            try {
                Class.forName("org.apache.hive.jdbc.HiveDriver");
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"Unable to load Hive driver class", (Throwable)e);
                return;
            }
            try {
                this.connection = DriverManager.getConnection(jdbcUrl, hiveUser, hivePass);
                LOG.info((Object)("Successfully established Hive connection to  " + jdbcUrl));
            }
            catch (SQLException e) {
                throw new HoodieHiveSyncException("Cannot create hive connection " + this.getHiveJdbcUrlWithDefaultDBName(jdbcUrl), e);
            }
        }
    }

    private String getHiveJdbcUrlWithDefaultDBName(String jdbcUrl) {
        String hiveJdbcUrl = jdbcUrl;
        String urlAppend = null;
        if (hiveJdbcUrl.contains(";")) {
            urlAppend = hiveJdbcUrl.substring(hiveJdbcUrl.indexOf(";"));
            hiveJdbcUrl = hiveJdbcUrl.substring(0, hiveJdbcUrl.indexOf(";"));
        }
        if (!hiveJdbcUrl.endsWith("/")) {
            hiveJdbcUrl = hiveJdbcUrl + "/";
        }
        return hiveJdbcUrl + (urlAppend == null ? "" : urlAppend);
    }

    @Override
    public Map<String, String> getTableSchema(String tableName) {
        HashMap<String, String> schema = new HashMap<String, String>();
        ResultSet result = null;
        try {
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            result = databaseMetaData.getColumns(null, this.databaseName, tableName, null);
            while (result.next()) {
                String columnName = result.getString(4);
                String columnType = result.getString(6);
                if ("DECIMAL".equals(columnType)) {
                    int columnSize = result.getInt("COLUMN_SIZE");
                    int decimalDigits = result.getInt("DECIMAL_DIGITS");
                    columnType = columnType + String.format("(%s,%s)", columnSize, decimalDigits);
                }
                schema.put(columnName, columnType);
            }
            HashMap<String, String> hashMap = schema;
            this.closeQuietly(result, null);
            return hashMap;
        }
        catch (SQLException e) {
            try {
                throw new HoodieHiveSyncException("Failed to get table schema for " + tableName, e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(result, null);
                throw throwable;
            }
        }
    }

    @Override
    public void dropPartitionsToTable(String tableName, List<String> partitionsToDrop) {
        if (partitionsToDrop.isEmpty()) {
            LOG.info((Object)("No partitions to add for " + tableName));
            return;
        }
        LOG.info((Object)("Dropping partitions " + partitionsToDrop.size() + " from table " + tableName));
        List<String> sqls = this.constructDropPartitions(tableName, partitionsToDrop);
        sqls.stream().forEach(sql -> this.runSQL((String)sql));
    }

    private List<String> constructDropPartitions(String tableName, List<String> partitions) {
        ArrayList<String> result = new ArrayList<String>();
        int batchSyncPartitionNum = this.config.getIntOrDefault(HiveSyncConfigHolder.HIVE_BATCH_SYNC_PARTITION_NUM);
        StringBuilder alterSQL = this.getAlterTableDropPrefix(tableName);
        for (int i = 0; i < partitions.size(); ++i) {
            String partitionClause = this.getPartitionClause(partitions.get(i));
            if (i == 0) {
                alterSQL.append(" PARTITION (").append(partitionClause).append(")");
            } else {
                alterSQL.append(", PARTITION (").append(partitionClause).append(")");
            }
            if ((i + 1) % batchSyncPartitionNum != 0) continue;
            result.add(alterSQL.toString());
            alterSQL = this.getAlterTableDropPrefix(tableName);
        }
        if (partitions.size() % batchSyncPartitionNum != 0) {
            result.add(alterSQL.toString());
        }
        return result;
    }

    public StringBuilder getAlterTableDropPrefix(String tableName) {
        StringBuilder alterSQL = new StringBuilder("ALTER TABLE ");
        alterSQL.append("`").append(this.databaseName).append("`").append(".").append("`").append(tableName).append("`").append(" DROP IF EXISTS ");
        return alterSQL;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Could not close connection ", (Throwable)e);
        }
    }
}

